/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.IntegerDistribution;
import ia.sh.org.apache.commons.math3.exception.MathInternalError;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.NumberIsTooLargeException;
import ia.sh.org.apache.commons.math3.exception.OutOfRangeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomDataImpl;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public abstract class AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    private static final long serialVersionUID = -1146319659338487221L;
    @Deprecated
    protected final RandomDataImpl randomData = new RandomDataImpl();
    protected final RandomGenerator random;

    @Deprecated
    protected AbstractIntegerDistribution() {
        this.random = null;
    }

    protected AbstractIntegerDistribution(RandomGenerator randomGenerator) {
        this.random = randomGenerator;
    }

    public double cumulativeProbability(int n2, int n3) {
        if (n3 < n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)n2, n3, true);
        }
        return this.cumulativeProbability(n3) - this.cumulativeProbability(n2);
    }

    public int inverseCumulativeProbability(double d2) {
        boolean bl2;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        int n2 = this.getSupportLowerBound();
        if (d2 == 0.0) {
            return n2;
        }
        if (n2 == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(n2) >= d2) {
                return n2;
            }
        } else {
            --n2;
        }
        int n3 = this.getSupportUpperBound();
        if (d2 == 1.0) {
            return n3;
        }
        double d3 = this.getNumericalMean();
        double d4 = FastMath.sqrt(this.getNumericalVariance());
        boolean bl3 = bl2 = !Double.isInfinite(d3) && !Double.isNaN(d3) && !Double.isInfinite(d4) && !Double.isNaN(d4) && d4 != 0.0;
        if (bl2) {
            double d5 = FastMath.sqrt((1.0 - d2) / d2);
            double d6 = d3 - d5 * d4;
            if (d6 > (double)n2) {
                n2 = (int)FastMath.ceil(d6) - 1;
            }
            if ((d6 = d3 + (d5 = 1.0 / d5) * d4) < (double)n3) {
                n3 = (int)FastMath.ceil(d6) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(d2, n2, n3);
    }

    protected int solveInverseCumulativeProbability(double d2, int n2, int n3) {
        while (n2 + 1 < n3) {
            double d3;
            int n4 = (n2 + n3) / 2;
            if (n4 < n2 || n4 > n3) {
                n4 = n2 + (n3 - n2) / 2;
            }
            if ((d3 = this.checkedCumulativeProbability(n4)) >= d2) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n3;
    }

    public void reseedRandomGenerator(long l2) {
        this.random.setSeed(l2);
        this.randomData.reSeed(l2);
    }

    public int sample() {
        return this.inverseCumulativeProbability(this.random.nextDouble());
    }

    public int[] sample(int n2) {
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n2);
        }
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.sample();
        }
        return nArray;
    }

    private double checkedCumulativeProbability(int n2) {
        double d2 = Double.NaN;
        d2 = this.cumulativeProbability(n2);
        if (Double.isNaN(d2)) {
            throw new MathInternalError(LocalizedFormats.DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, n2);
        }
        return d2;
    }

    public double logProbability(int n2) {
        return FastMath.log(this.probability(n2));
    }
}

