/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.io.protostuff;

import ia.sh.io.protostuff.Output;
import ia.sh.io.protostuff.StringSerializer$STRING;
import java.io.DataOutput;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class ByteString {
    private final byte[] bytes;
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ByteString EMPTY = new ByteString(EMPTY_BYTE_ARRAY);
    private volatile int hash = 0;

    static ByteString wrap(byte[] byArray) {
        return new ByteString(byArray);
    }

    byte[] getBytes() {
        return this.bytes;
    }

    public static void writeTo(OutputStream outputStream, ByteString byteString) {
        outputStream.write(byteString.bytes);
    }

    public static void writeTo(DataOutput dataOutput, ByteString byteString) {
        dataOutput.write(byteString.bytes);
    }

    public static void writeTo(Output output, ByteString byteString, int n2, boolean bl2) {
        output.writeByteArray(n2, byteString.bytes, bl2);
    }

    public String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    private ByteString(byte[] byArray) {
        this.bytes = byArray;
    }

    public byte byteAt(int n2) {
        return this.bytes[n2];
    }

    public int size() {
        return this.bytes.length;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public static ByteString copyFrom(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new ByteString(byArray2);
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    public static ByteString copyFrom(String string, String string2) {
        try {
            return new ByteString(string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(string2 + " not supported?", unsupportedEncodingException);
        }
    }

    public static ByteString copyFromUtf8(String string) {
        return new ByteString(StringSerializer$STRING.ser(string));
    }

    public void copyTo(byte[] byArray, int n2) {
        System.arraycopy(this.bytes, 0, byArray, n2, this.bytes.length);
    }

    public void copyTo(byte[] byArray, int n2, int n3, int n4) {
        System.arraycopy(this.bytes, n2, byArray, n3, n4);
    }

    public byte[] toByteArray() {
        int n2 = this.bytes.length;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.bytes, 0, byArray, 0, n2);
        return byArray;
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes);
        return byteBuffer.asReadOnlyBuffer();
    }

    public String toStringUtf8() {
        return StringSerializer$STRING.deser(this.bytes);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof ByteString && ByteString.equals(this, (ByteString)object, false);
    }

    public static boolean equals(ByteString byteString, ByteString byteString2, boolean bl2) {
        int n2 = byteString.bytes.length;
        if (n2 != byteString2.bytes.length) {
            return false;
        }
        if (bl2) {
            int n3 = byteString.hash;
            int n4 = byteString2.hash;
            if (n3 != 0 && n4 != 0 && n3 != n4) {
                return false;
            }
        }
        byte[] byArray = byteString.bytes;
        byte[] byArray2 = byteString2.bytes;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(byte[] byArray) {
        return this.equals(byArray, 0, byArray.length);
    }

    public boolean equals(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.bytes;
        if (n3 != byArray2.length) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (byArray2[n4++] == byArray[n2++]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            int n3;
            byte[] byArray = this.bytes;
            n2 = n3 = this.bytes.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 = n2 * 31 + byArray[i2];
            }
            if (n2 == 0) {
                n2 = 1;
            }
            this.hash = n2;
        }
        return n2;
    }

    public static String stringDefaultValue(String string) {
        try {
            return new String(string.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Java VM does not support a standard character set.", unsupportedEncodingException);
        }
    }

    public static ByteString bytesDefaultValue(String string) {
        return new ByteString(ByteString.byteArrayDefaultValue(string));
    }

    public static byte[] byteArrayDefaultValue(String string) {
        try {
            return string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Java VM does not support a standard character set.", unsupportedEncodingException);
        }
    }
}

