/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.io.protostuff;

import ia.sh.io.protostuff.LinkedBuffer;
import ia.sh.io.protostuff.StringSerializer;
import ia.sh.io.protostuff.WriteSession;

public final class StreamedStringSerializer {
    private StreamedStringSerializer() {
    }

    public static LinkedBuffer writeInt(int n2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        if (n2 == Integer.MIN_VALUE) {
            int n3 = StringSerializer.INT_MIN_VALUE.length;
            writeSession.size += n3;
            if (linkedBuffer.offset + n3 > linkedBuffer.buffer.length) {
                linkedBuffer.offset = writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, linkedBuffer.offset - linkedBuffer.start);
            }
            System.arraycopy(StringSerializer.INT_MIN_VALUE, 0, linkedBuffer.buffer, linkedBuffer.offset, n3);
            linkedBuffer.offset += n3;
            return linkedBuffer;
        }
        int n4 = n2 < 0 ? StringSerializer.stringSize(-n2) + 1 : StringSerializer.stringSize(n2);
        writeSession.size += n4;
        if (linkedBuffer.offset + n4 > linkedBuffer.buffer.length) {
            linkedBuffer.offset = writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, linkedBuffer.offset - linkedBuffer.start);
        }
        StringSerializer.putBytesFromInt(n2, linkedBuffer.offset, n4, linkedBuffer.buffer);
        linkedBuffer.offset += n4;
        return linkedBuffer;
    }

    public static LinkedBuffer writeLong(long l2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        if (l2 == Long.MIN_VALUE) {
            int n2 = StringSerializer.LONG_MIN_VALUE.length;
            writeSession.size += n2;
            if (linkedBuffer.offset + n2 > linkedBuffer.buffer.length) {
                linkedBuffer.offset = writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, linkedBuffer.offset - linkedBuffer.start);
            }
            System.arraycopy(StringSerializer.LONG_MIN_VALUE, 0, linkedBuffer.buffer, linkedBuffer.offset, n2);
            linkedBuffer.offset += n2;
            return linkedBuffer;
        }
        int n3 = l2 < 0L ? StringSerializer.stringSize(-l2) + 1 : StringSerializer.stringSize(l2);
        writeSession.size += n3;
        if (linkedBuffer.offset + n3 > linkedBuffer.buffer.length) {
            linkedBuffer.offset = writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, linkedBuffer.offset - linkedBuffer.start);
        }
        StringSerializer.putBytesFromLong(l2, linkedBuffer.offset, n3, linkedBuffer.buffer);
        linkedBuffer.offset += n3;
        return linkedBuffer;
    }

    public static LinkedBuffer writeFloat(float f2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        return StreamedStringSerializer.writeAscii(Float.toString(f2), writeSession, linkedBuffer);
    }

    public static LinkedBuffer writeDouble(double d2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        return StreamedStringSerializer.writeAscii(Double.toString(d2), writeSession, linkedBuffer);
    }

    public static LinkedBuffer writeUTF8(CharSequence charSequence, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return linkedBuffer;
        }
        byte[] byArray = linkedBuffer.buffer;
        int n3 = byArray.length;
        int n4 = linkedBuffer.offset;
        int n5 = 0;
        do {
            char c2;
            if ((c2 = charSequence.charAt(n5++)) < '\u0080') {
                if (n4 == n3) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4 = writeSession.flush(byArray, linkedBuffer.start, n4 - linkedBuffer.start);
                }
                byArray[n4++] = (byte)c2;
                continue;
            }
            if (c2 < '\u0800') {
                if (n4 + 2 > n3) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4 = writeSession.flush(byArray, linkedBuffer.start, n4 - linkedBuffer.start);
                }
                byArray[n4++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            if (Character.isHighSurrogate(c2) && n5 < n2 && Character.isLowSurrogate(charSequence.charAt(n5))) {
                if (n4 + 4 > byArray.length) {
                    writeSession.size += n4 - linkedBuffer.offset;
                    linkedBuffer.offset = n4 = writeSession.flush(byArray, linkedBuffer.start, n4 - linkedBuffer.start);
                }
                int n6 = Character.toCodePoint(c2, charSequence.charAt(n5));
                byArray[n4++] = (byte)(0xF0 | n6 >> 18 & 7);
                byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n6 >> 0 & 0x3F);
                ++n5;
                continue;
            }
            if (n4 + 3 > n3) {
                writeSession.size += n4 - linkedBuffer.offset;
                linkedBuffer.offset = n4 = writeSession.flush(byArray, linkedBuffer.start, n4 - linkedBuffer.start);
            }
            byArray[n4++] = (byte)(0xE0 | c2 >> 12 & 0xF);
            byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            byArray[n4++] = (byte)(0x80 | c2 >> 0 & 0x3F);
        } while (n5 < n2);
        writeSession.size += n4 - linkedBuffer.offset;
        linkedBuffer.offset = n4;
        return linkedBuffer;
    }

    public static LinkedBuffer writeAscii(CharSequence charSequence, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return linkedBuffer;
        }
        int n3 = linkedBuffer.offset;
        int n4 = linkedBuffer.buffer.length;
        byte[] byArray = linkedBuffer.buffer;
        writeSession.size += n2;
        if (n3 + n2 > n4) {
            int n5 = 0;
            int n6 = linkedBuffer.start;
            int n7 = n4 - n6;
            int n8 = n4 - n3;
            int n9 = n2 - n8;
            while (n8-- > 0) {
                byArray[n3++] = (byte)charSequence.charAt(n5++);
            }
            n3 = writeSession.flush(byArray, n6, n7);
            while (n9-- > 0) {
                if (n3 == n4) {
                    n3 = writeSession.flush(byArray, n6, n7);
                }
                byArray[n3++] = (byte)charSequence.charAt(n5++);
            }
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[n3++] = (byte)charSequence.charAt(i2);
            }
        }
        linkedBuffer.offset = n3;
        return linkedBuffer;
    }

    private static void flushAndReset(LinkedBuffer linkedBuffer, WriteSession writeSession) {
        do {
            int n2;
            if ((n2 = linkedBuffer.offset - linkedBuffer.start) <= 0) continue;
            linkedBuffer.offset = writeSession.flush(linkedBuffer, linkedBuffer.buffer, linkedBuffer.start, n2);
        } while ((linkedBuffer = linkedBuffer.next) != null);
    }

    public static LinkedBuffer writeUTF8FixedDelimited(CharSequence charSequence, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        return StreamedStringSerializer.writeUTF8FixedDelimited(charSequence, false, writeSession, linkedBuffer);
    }

    public static LinkedBuffer writeUTF8FixedDelimited(CharSequence charSequence, boolean bl2, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2 = writeSession.size;
        int n3 = linkedBuffer.offset + 2;
        int n4 = charSequence.length();
        if (n3 + n4 > linkedBuffer.buffer.length) {
            linkedBuffer.offset = writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, linkedBuffer.offset - linkedBuffer.start);
            n3 = linkedBuffer.offset + 2;
            if (n4 == 0) {
                StringSerializer.writeFixed2ByteInt(0, linkedBuffer.buffer, n3 - 2, bl2);
                linkedBuffer.offset = n3;
                writeSession.size += 2;
                return linkedBuffer;
            }
            if (n3 + n4 > linkedBuffer.buffer.length) {
                linkedBuffer.offset = n3;
                LinkedBuffer linkedBuffer2 = StringSerializer.writeUTF8(charSequence, 0, n4, linkedBuffer.buffer, n3, linkedBuffer.buffer.length, writeSession, linkedBuffer);
                StringSerializer.writeFixed2ByteInt(writeSession.size - n2, linkedBuffer.buffer, n3 - 2, bl2);
                writeSession.size += 2;
                assert (linkedBuffer2 != linkedBuffer);
                StreamedStringSerializer.flushAndReset(linkedBuffer, writeSession);
                return linkedBuffer;
            }
        } else if (n4 == 0) {
            StringSerializer.writeFixed2ByteInt(0, linkedBuffer.buffer, n3 - 2, bl2);
            linkedBuffer.offset = n3;
            writeSession.size += 2;
            return linkedBuffer;
        }
        linkedBuffer.offset = n3;
        LinkedBuffer linkedBuffer3 = StringSerializer.writeUTF8(charSequence, 0, n4, writeSession, linkedBuffer);
        StringSerializer.writeFixed2ByteInt(writeSession.size - n2, linkedBuffer.buffer, n3 - 2, bl2);
        writeSession.size += 2;
        if (linkedBuffer3 != linkedBuffer) {
            StreamedStringSerializer.flushAndReset(linkedBuffer, writeSession);
        }
        return linkedBuffer;
    }

    private static LinkedBuffer writeUTF8OneByteDelimited(CharSequence charSequence, int n2, int n3, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n4 = writeSession.size;
        int n5 = linkedBuffer.offset + 1;
        if (n5 + n3 > linkedBuffer.buffer.length) {
            linkedBuffer.offset = writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, linkedBuffer.offset - linkedBuffer.start);
            n5 = linkedBuffer.offset + 1;
        }
        linkedBuffer.offset = n5;
        LinkedBuffer linkedBuffer2 = StringSerializer.writeUTF8(charSequence, n2, n3, writeSession, linkedBuffer);
        linkedBuffer.buffer[n5 - 1] = (byte)(writeSession.size - n4);
        ++writeSession.size;
        if (linkedBuffer2 != linkedBuffer) {
            StreamedStringSerializer.flushAndReset(linkedBuffer, writeSession);
        }
        return linkedBuffer;
    }

    private static LinkedBuffer writeUTF8VarDelimited(CharSequence charSequence, int n2, int n3, int n4, int n5, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n6 = writeSession.size;
        int n7 = linkedBuffer.offset;
        int n8 = n7 + n5;
        if (n8 + n3 > linkedBuffer.buffer.length && (n8 = (n7 = writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, linkedBuffer.offset - linkedBuffer.start)) + n5) + n3 > linkedBuffer.buffer.length) {
            linkedBuffer.offset = n8;
            LinkedBuffer linkedBuffer2 = StringSerializer.writeUTF8(charSequence, n2, n3, linkedBuffer.buffer, n8, linkedBuffer.buffer.length, writeSession, linkedBuffer);
            int n9 = writeSession.size - n6;
            if (n9 < n4) {
                writeSession.size += --n5;
                int n10 = ++n7;
                while (--n5 > 0) {
                    linkedBuffer.buffer[n10++] = (byte)(n9 & 0x7F | 0x80);
                    n9 >>>= 7;
                }
                linkedBuffer.buffer[n10] = (byte)n9;
                linkedBuffer.offset = writeSession.flush(linkedBuffer, linkedBuffer.buffer, n7, linkedBuffer.offset - n7);
                assert (linkedBuffer2 != linkedBuffer);
                StreamedStringSerializer.flushAndReset(linkedBuffer.next, writeSession);
                return linkedBuffer;
            }
            writeSession.size += n5;
            while (--n5 > 0) {
                linkedBuffer.buffer[n7++] = (byte)(n9 & 0x7F | 0x80);
                n9 >>>= 7;
            }
            linkedBuffer.buffer[n7] = (byte)n9;
            assert (linkedBuffer2 != linkedBuffer);
            StreamedStringSerializer.flushAndReset(linkedBuffer, writeSession);
            return linkedBuffer;
        }
        linkedBuffer.offset = n8;
        LinkedBuffer linkedBuffer3 = StringSerializer.writeUTF8(charSequence, n2, n3, writeSession, linkedBuffer);
        int n11 = writeSession.size - n6;
        if (n11 < n4) {
            if (linkedBuffer3 != linkedBuffer || n5 != 2) {
                writeSession.size += --n5;
                int n12 = n7++;
                int n13 = n7;
                while (--n5 > 0) {
                    linkedBuffer.buffer[n13++] = (byte)(n11 & 0x7F | 0x80);
                    n11 >>>= 7;
                }
                linkedBuffer.buffer[n13] = (byte)n11;
                linkedBuffer.offset = n12 == linkedBuffer.start ? writeSession.flush(linkedBuffer, linkedBuffer.buffer, n7, linkedBuffer.offset - n7) : writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, n12 - linkedBuffer.start, linkedBuffer.buffer, n7, linkedBuffer.offset - n7);
                if (linkedBuffer3 != linkedBuffer) {
                    StreamedStringSerializer.flushAndReset(linkedBuffer.next, writeSession);
                }
                return linkedBuffer;
            }
            System.arraycopy(linkedBuffer.buffer, n8, linkedBuffer.buffer, n8 - 1, linkedBuffer.offset - n8);
            --n5;
            --linkedBuffer.offset;
        }
        writeSession.size += n5;
        while (--n5 > 0) {
            linkedBuffer.buffer[n7++] = (byte)(n11 & 0x7F | 0x80);
            n11 >>>= 7;
        }
        linkedBuffer.buffer[n7] = (byte)n11;
        if (linkedBuffer3 != linkedBuffer) {
            StreamedStringSerializer.flushAndReset(linkedBuffer, writeSession);
        }
        return linkedBuffer;
    }

    public static LinkedBuffer writeUTF8VarDelimited(CharSequence charSequence, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            if (linkedBuffer.offset == linkedBuffer.buffer.length) {
                linkedBuffer.offset = writeSession.flush(linkedBuffer.buffer, linkedBuffer.start, linkedBuffer.offset - linkedBuffer.start);
            }
            linkedBuffer.buffer[linkedBuffer.offset++] = 0;
            ++writeSession.size;
            return linkedBuffer;
        }
        if (n2 < 43) {
            return StreamedStringSerializer.writeUTF8OneByteDelimited(charSequence, 0, n2, writeSession, linkedBuffer);
        }
        if (n2 < 5462) {
            return StreamedStringSerializer.writeUTF8VarDelimited(charSequence, 0, n2, 128, 2, writeSession, linkedBuffer);
        }
        if (n2 < 699051) {
            return StreamedStringSerializer.writeUTF8VarDelimited(charSequence, 0, n2, 16384, 3, writeSession, linkedBuffer);
        }
        if (n2 < 0x5555556) {
            return StreamedStringSerializer.writeUTF8VarDelimited(charSequence, 0, n2, 0x200000, 4, writeSession, linkedBuffer);
        }
        return StreamedStringSerializer.writeUTF8VarDelimited(charSequence, 0, n2, 0x10000000, 5, writeSession, linkedBuffer);
    }
}

