/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.util.FastMath;

final class ZipfDistribution$ZipfRejectionInversionSampler {
    private final double exponent;
    private final int numberOfElements;
    private final double hIntegralX1;
    private final double hIntegralNumberOfElements;
    private final double s;

    ZipfDistribution$ZipfRejectionInversionSampler(int n2, double d2) {
        this.exponent = d2;
        this.numberOfElements = n2;
        this.hIntegralX1 = this.hIntegral(1.5) - 1.0;
        this.hIntegralNumberOfElements = this.hIntegral((double)n2 + 0.5);
        this.s = 2.0 - this.hIntegralInverse(this.hIntegral(2.5) - this.h(2.0));
    }

    int sample(RandomGenerator randomGenerator) {
        double d2;
        double d3;
        int n2;
        do {
            if ((n2 = (int)((d3 = this.hIntegralInverse(d2 = this.hIntegralNumberOfElements + randomGenerator.nextDouble() * (this.hIntegralX1 - this.hIntegralNumberOfElements))) + 0.5)) < 1) {
                n2 = 1;
                continue;
            }
            if (n2 <= this.numberOfElements) continue;
            n2 = this.numberOfElements;
        } while (!((double)n2 - d3 <= this.s) && !(d2 >= this.hIntegral((double)n2 + 0.5) - this.h(n2)));
        return n2;
    }

    private double hIntegral(double d2) {
        double d3 = FastMath.log(d2);
        return ZipfDistribution$ZipfRejectionInversionSampler.helper2((1.0 - this.exponent) * d3) * d3;
    }

    private double h(double d2) {
        return FastMath.exp(-this.exponent * FastMath.log(d2));
    }

    private double hIntegralInverse(double d2) {
        double d3 = d2 * (1.0 - this.exponent);
        if (d3 < -1.0) {
            d3 = -1.0;
        }
        return FastMath.exp(ZipfDistribution$ZipfRejectionInversionSampler.helper1(d3) * d2);
    }

    static double helper1(double d2) {
        if (FastMath.abs(d2) > 1.0E-8) {
            return FastMath.log1p(d2) / d2;
        }
        return 1.0 - d2 * (0.5 - d2 * (0.3333333333333333 - d2 * 0.25));
    }

    static double helper2(double d2) {
        if (FastMath.abs(d2) > 1.0E-8) {
            return FastMath.expm1(d2) / d2;
        }
        return 1.0 + d2 * 0.5 * (1.0 + d2 * 0.3333333333333333 * (1.0 + d2 * 0.25));
    }
}

