/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.exception.DimensionMismatchException;
import ia.sh.org.apache.commons.math3.exception.OutOfRangeException;
import ia.sh.org.apache.commons.math3.util.ArithmeticUtils;
import ia.sh.org.apache.commons.math3.util.MathArrays;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

class Combinations$LexicographicComparator
implements Serializable,
Comparator {
    private static final long serialVersionUID = 20130906L;
    private final int n;
    private final int k;

    Combinations$LexicographicComparator(int n2, int n3) {
        this.n = n2;
        this.k = n3;
    }

    public int compare(int[] nArray, int[] nArray2) {
        if (nArray.length != this.k) {
            throw new DimensionMismatchException(nArray.length, this.k);
        }
        if (nArray2.length != this.k) {
            throw new DimensionMismatchException(nArray2.length, this.k);
        }
        int[] nArray3 = MathArrays.copyOf(nArray);
        Arrays.sort(nArray3);
        int[] nArray4 = MathArrays.copyOf(nArray2);
        Arrays.sort(nArray4);
        long l2 = this.lexNorm(nArray3);
        long l3 = this.lexNorm(nArray4);
        if (l2 < l3) {
            return -1;
        }
        if (l2 > l3) {
            return 1;
        }
        return 0;
    }

    private long lexNorm(int[] nArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (n2 < 0 || n2 >= this.n) {
                throw new OutOfRangeException(n2, (Number)0, this.n - 1);
            }
            l2 += (long)(nArray[i2] * ArithmeticUtils.pow(this.n, i2));
        }
        return l2;
    }
}

