/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.RealFieldElement;
import ia.sh.org.apache.commons.math3.exception.MathArithmeticException;
import ia.sh.org.apache.commons.math3.exception.NotFiniteNumberException;
import ia.sh.org.apache.commons.math3.exception.NullArgumentException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.util.FastMath;
import java.util.Arrays;

public final class MathUtils {
    public static final double TWO_PI = Math.PI * 2;
    public static final double PI_SQUARED = Math.PI * Math.PI;

    private MathUtils() {
    }

    public static int hash(double d2) {
        return new Double(d2).hashCode();
    }

    public static boolean equals(double d2, double d3) {
        return new Double(d2).equals(new Double(d3));
    }

    public static int hash(double[] dArray) {
        return Arrays.hashCode(dArray);
    }

    public static double normalizeAngle(double d2, double d3) {
        return d2 - Math.PI * 2 * FastMath.floor((d2 + Math.PI - d3) / (Math.PI * 2));
    }

    public static RealFieldElement max(RealFieldElement realFieldElement, RealFieldElement realFieldElement2) {
        return ((RealFieldElement)realFieldElement.subtract(realFieldElement2)).getReal() >= 0.0 ? realFieldElement : realFieldElement2;
    }

    public static RealFieldElement min(RealFieldElement realFieldElement, RealFieldElement realFieldElement2) {
        return ((RealFieldElement)realFieldElement.subtract(realFieldElement2)).getReal() >= 0.0 ? realFieldElement2 : realFieldElement;
    }

    public static double reduce(double d2, double d3, double d4) {
        double d5 = FastMath.abs(d3);
        return d2 - d5 * FastMath.floor((d2 - d4) / d5) - d4;
    }

    public static byte copySign(byte by2, byte by3) {
        if (by2 >= 0 && by3 >= 0 || by2 < 0 && by3 < 0) {
            return by2;
        }
        if (by3 >= 0 && by2 == -128) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -by2;
    }

    public static short copySign(short s2, short s3) {
        if (s2 >= 0 && s3 >= 0 || s2 < 0 && s3 < 0) {
            return s2;
        }
        if (s3 >= 0 && s2 == Short.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -s2;
    }

    public static int copySign(int n2, int n3) {
        if (n2 >= 0 && n3 >= 0 || n2 < 0 && n3 < 0) {
            return n2;
        }
        if (n3 >= 0 && n2 == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -n2;
    }

    public static long copySign(long l2, long l3) {
        if (l2 >= 0L && l3 >= 0L || l2 < 0L && l3 < 0L) {
            return l2;
        }
        if (l3 >= 0L && l2 == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -l2;
    }

    public static void checkFinite(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new NotFiniteNumberException(d2, new Object[0]);
        }
    }

    public static void checkFinite(double[] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2 = dArray[i2];
            if (!Double.isInfinite(d2) && !Double.isNaN(d2)) continue;
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.ARRAY_ELEMENT, d2, i2);
        }
    }

    public static void checkNotNull(Object object, Localizable localizable, Object ... objectArray) {
        if (object == null) {
            throw new NullArgumentException(localizable, objectArray);
        }
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullArgumentException();
        }
    }
}

