/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.addons;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;
import org.kingdoms.addons.AddonFetcher;
import org.kingdoms.addons.StandardAddons;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmName;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.Kingdoms;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\n #*\u0004\u0018\u00010!0!J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%R\u0016\u0010\t\u001a\u00020\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\b8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0007\u001a\u00020\b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0016\u0010\u0004\u001a\u00020\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u001bR*\u0010\u001d\u001a\u0004\u0018\u00010\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u00058G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\f\"\u0004\b\u001f\u0010\u001b\u00a8\u0006("}, d2={"Lorg/kingdoms/addons/AddonRepository;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "name", "", "path", "metaFileURL", "Ljava/net/URL;", "description", "(Lorg/bukkit/plugin/Plugin;Ljava/lang/String;Ljava/lang/String;Ljava/net/URL;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "value", "downloadURL", "getDownloadURL", "()Ljava/net/URL;", "setDownloadURL", "(Ljava/net/URL;)V", "getMetaFileURL", "getName", "getPath", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "supportedCoreVersion", "getSupportedCoreVersion", "setSupportedCoreVersion", "(Ljava/lang/String;)V", "<set-?>", "version", "getVersion", "setVersion", "download", "Ljava/nio/file/Path;", "getDownloadPath", "org.kingdoms.libs.kotlin.jvm.PlatformType", "register", "", "updateInfo", "Companion", "core"})
public final class AddonRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final String path;
    @NotNull
    private final String name;
    @NotNull
    private final URL metaFileURL;
    @NotNull
    private final String description;
    @Nullable
    private URL downloadURL;
    @Nullable
    private String version;
    @Nullable
    private String supportedCoreVersion;
    @NotNull
    private static final Map<String, AddonRepository> REPOSITORY = new HashMap();
    private static final Pattern PATH_PATTERN = Pattern.compile("[a-zA-Z0-9-_]+");

    public AddonRepository(@NotNull Plugin plugin, @NotNull String name, @NotNull String path, @NotNull URL metaFileURL, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)metaFileURL, (String)"metaFileURL");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.plugin = plugin;
        this.path = path;
        if (!(!Strings.isNullOrEmpty((String)name))) {
            boolean $i$a$-require-AddonRepository$32 = false;
            String $i$a$-require-AddonRepository$32 = "Addon name cannot be null or empty";
            throw new IllegalArgumentException($i$a$-require-AddonRepository$32.toString());
        }
        if (!(!Strings.isNullOrEmpty((String)description))) {
            boolean bl = false;
            String string = "Addon description cannot be null or empty";
            throw new IllegalArgumentException(string.toString());
        }
        if (!PATH_PATTERN.matcher(this.path).matches()) {
            throw new IllegalArgumentException("Addon path '" + this.path + "' isn't valid.");
        }
        this.name = name;
        this.metaFileURL = Companion.validateURL$core(metaFileURL);
        this.description = description;
    }

    @JvmName(name="getPlugin")
    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @JvmName(name="getName")
    @NotNull
    public final String getName() {
        return this.name;
    }

    @JvmName(name="getMetaFileURL")
    @NotNull
    public final URL getMetaFileURL() {
        return this.metaFileURL;
    }

    @JvmName(name="getDescription")
    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @JvmName(name="getDownloadURL")
    @Nullable
    public final URL getDownloadURL() {
        return this.downloadURL;
    }

    @JvmName(name="setDownloadURL")
    public final void setDownloadURL(@Nullable URL value) {
        URL uRL = value;
        Intrinsics.checkNotNull((Object)uRL);
        this.downloadURL = Companion.validateURL$core(uRL);
    }

    @JvmName(name="getVersion")
    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @JvmName(name="setVersion")
    public final void setVersion(@Nullable String string) {
        this.version = string;
    }

    @Nullable
    public final String getSupportedCoreVersion() {
        return this.supportedCoreVersion;
    }

    public final void setSupportedCoreVersion(@Nullable String string) {
        this.supportedCoreVersion = string;
    }

    public final void register() {
        REPOSITORY.put(this.path, this);
    }

    public final void updateInfo() {
        AddonFetcher.fetch(this);
    }

    public final Path getDownloadPath() {
        return Kingdoms.getFolder().getParent().resolve("Kingdoms-Addon-" + this.name + '-' + this.version + ".jar");
    }

    @NotNull
    public final Path download() throws IOException {
        URL uRL = this.downloadURL;
        Intrinsics.checkNotNull((Object)uRL);
        ReadableByteChannel readChan = Channels.newChannel(uRL.openStream());
        Path to = this.getDownloadPath();
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
        FileChannel fileChannel = FileChannel.open(to, openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"open(to, StandardOpenOpt\u2026StandardOpenOption.WRITE)");
        FileChannel writeChan = fileChannel;
        writeChan.transferFrom(readChan, 0L, Integer.MAX_VALUE);
        writeChan.close();
        readChan.close();
        Intrinsics.checkNotNullExpressionValue((Object)to, (String)"to");
        return to;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, AddonRepository> getRepository() {
        return Companion.getRepository();
    }

    static {
        StandardAddons.init();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0007J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/addons/AddonRepository$Companion;", "", "()V", "PATH_PATTERN", "Ljava/util/regex/Pattern;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "REPOSITORY", "", "", "Lorg/kingdoms/addons/AddonRepository;", "getRepository", "validateURL", "Ljava/net/URL;", "url", "validateURL$core", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Map<String, AddonRepository> getRepository() {
            return REPOSITORY;
        }

        @NotNull
        public final URL validateURL$core(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            try {
                if (!(!Intrinsics.areEqual((Object)"file", (Object)url.getProtocol()))) {
                    boolean bl = false;
                    String string = "Invalid URL. It must point to http(s) link that is a direct link to a file: " + url;
                    throw new IllegalArgumentException(string.toString());
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid meta file URL", e);
            }
            return url;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

