/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands;

import java.time.Duration;
import java.util.List;
import org.bukkit.Bukkit;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.database.sql.SQLDatabase;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.internal.Fn;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/commands/CommandAdminMigrateDatabase;", "Lorg/kingdoms/commands/KingdomsCommand;", "parentCommand", "Lorg/kingdoms/commands/KingdomsParentCommand;", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "createNewDataCenterAndSaveAll", "", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "loadAllData", "saveAll", "dataCenter", "Lorg/kingdoms/data/KingdomsDataCenter;", "Companion", "core"})
public final class CommandAdminMigrateDatabase
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static long executionCooldown;
    private static long migrationCooldown;
    private static final String oldDbType;
    private static boolean wait;

    public CommandAdminMigrateDatabase(@NotNull KingdomsParentCommand parentCommand) {
        Intrinsics.checkNotNullParameter((Object)parentCommand, (String)"parentCommand");
        super("database", parentCommand);
    }

    public final void loadAllData() {
        KingdomsDataCenter dataCenter = Kingdoms.get().getDataCenter();
        KLogger.info("Loading all data... This might take several minutes.");
        for (DataManager<?, ?> dataManager : dataCenter.getAllDataManagers()) {
            KLogger.info("Loading " + dataManager.getDisplayName() + " data...");
            dataManager.loadAllData();
            KLogger.info("Loaded " + dataManager.getDisplayName() + " data.");
        }
    }

    public final void saveAll(@NotNull KingdomsDataCenter dataCenter) {
        Intrinsics.checkNotNullParameter((Object)dataCenter, (String)"dataCenter");
        KLogger.info("Saving all data... This might take several minutes.");
        for (DataManager<?, ?> dataManager : dataCenter.getAllDataManagers()) {
            KLogger.info("Saving " + dataManager.getDisplayName() + " data...");
            dataManager.saveAll(false);
            KLogger.info("Saved " + dataManager.getDisplayName() + " data.");
        }
    }

    public final void createNewDataCenterAndSaveAll() {
        KLogger.info("Creating new data center...");
        List<DataManager<?, ?>> list2 = Kingdoms.get().getDataCenter().getAllDataManagers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"get().dataCenter.allDataManagers");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataManager x = (DataManager)element$iv;
            boolean bl = false;
            x.setSavingState(false);
        }
        SQLDatabase.ranSchema = false;
        KingdomsDataCenter newDataCenter = new KingdomsDataCenter(Kingdoms.get());
        KLogger.info("Transferring data between data centers...");
        List<DataManager<?, ?>> list3 = Kingdoms.get().getDataCenter().getAllDataManagers();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"get().dataCenter.allDataManagers");
        Iterable $this$forEach$iv2 = list3;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Object v3;
            DataManager x;
            block3: {
                x = (DataManager)element$iv;
                boolean bl = false;
                List<DataManager<?, ?>> list4 = newDataCenter.getAllDataManagers();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"newDataCenter.allDataManagers");
                Iterable iterable = list4;
                for (Object t : iterable) {
                    DataManager y = (DataManager)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(x.getClass(), y.getClass())) continue;
                    v3 = t;
                    break block3;
                }
                v3 = null;
            }
            Intrinsics.checkNotNull(v3);
            DataManager sameDataManager = v3;
            Object t = Fn.cast(sameDataManager);
            Intrinsics.checkNotNullExpressionValue(t, (String)"cast(sameDataManager)");
            x.copyCacheTo((DataManager)t);
        }
        this.saveAll(newDataCenter);
    }

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isPlayer()) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_CONSOLE_ONLY, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLan\u2026TE_DATABASE_CONSOLE_ONLY)");
            return commandResult;
        }
        if (wait) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_PLEASE_WAIT, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLan\u2026ATE_DATABASE_PLEASE_WAIT)");
            return commandResult;
        }
        long now = System.currentTimeMillis();
        if (migrationCooldown != 0L && now - migrationCooldown <= Duration.ofMinutes(5L).toMillis()) {
            KingdomsConfig.MAIN.reload();
            if (StringsKt.equals((String)oldDbType, (String)KingdomsConfig.DATABASE_METHOD.getString(), (boolean)true)) {
                context.var("method", KingdomsConfig.DATABASE_METHOD.getString());
                CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_SAME_DATABASE_TYPE, new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLan\u2026ABASE_SAME_DATABASE_TYPE)");
                return commandResult;
            }
            wait = true;
            Kingdoms.taskScheduler().executeAsync(() -> CommandAdminMigrateDatabase.executeX$lambda-4(this, context));
            return CommandResult.SUCCESS;
        }
        if (now - executionCooldown >= Duration.ofSeconds(5L).toMillis()) {
            executionCooldown = now;
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_COOLDOWN, new Object[0]);
            return CommandResult.PARTIAL;
        }
        wait = true;
        Kingdoms.taskScheduler().executeAsync(() -> CommandAdminMigrateDatabase.executeX$lambda-5(this, now, context));
        return CommandResult.SUCCESS;
    }

    private static final void executeX$lambda-4$lambda-3() {
        Bukkit.shutdown();
    }

    private static final void executeX$lambda-4(CommandAdminMigrateDatabase this$0, CommandContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        try {
            this$0.createNewDataCenterAndSaveAll();
            $context.sendMessage(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_DONE, new Object[0]);
            Kingdoms.taskScheduler().syncLater(CommandAdminMigrateDatabase::executeX$lambda-4$lambda-3, Duration.ofSeconds(10L));
        }
        catch (Throwable ex) {
            $context.sendError(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_ERROR_LOADING_NEW_DATABASE, new Object[0]);
            ex.printStackTrace();
        }
    }

    private static final void executeX$lambda-5(CommandAdminMigrateDatabase this$0, long $now, CommandContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        KingdomsDataCenter kingdomsDataCenter = Kingdoms.get().getDataCenter();
        Intrinsics.checkNotNullExpressionValue((Object)kingdomsDataCenter, (String)"get().dataCenter");
        this$0.saveAll(kingdomsDataCenter);
        this$0.loadAllData();
        migrationCooldown = $now;
        $context.sendMessage(KingdomsLang.COMMAND_ADMIN_MIGRATE_DATABASE_START, new Object[0]);
        wait = false;
    }

    static {
        oldDbType = KingdomsConfig.DATABASE_METHOD.getString();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/CommandAdminMigrateDatabase$Companion;", "", "()V", "executionCooldown", "", "migrationCooldown", "oldDbType", "", "org.kingdoms.libs.kotlin.jvm.PlatformType", "wait", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

