/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;
import org.kingdoms.addons.Addon;
import org.kingdoms.addons.AddonRegistry;
import org.kingdoms.addons.AddonRepository;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.network.UpdateChecker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminAddons;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
public final class CommandAdminAddons
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static long lastCheck;

    public CommandAdminAddons(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("addons", parent);
    }

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)KingdomsCommand.plugin, () -> CommandAdminAddons.executeX$lambda-0(context, player));
        return CommandResult.SUCCESS;
    }

    private static final void executeX$lambda-0(CommandContext $context, Player $player) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullExpressionValue((Object)$player, (String)"player");
        Companion.openGUI($context, $player);
    }

    @JvmStatic
    public static final boolean checkForUpdates() {
        return Companion.checkForUpdates();
    }

    @JvmStatic
    public static final void notifyAboutUpdates(@NotNull CommandSender sender) {
        Companion.notifyAboutUpdates(sender);
    }

    @JvmStatic
    public static final void openGUI(@NotNull CommandContext context, @NotNull Player player) {
        Companion.openGUI(context, player);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/commands/admin/CommandAdminAddons$Companion;", "", "()V", "lastCheck", "", "checkForUpdates", "", "notifyAboutUpdates", "", "sender", "Lorg/bukkit/command/CommandSender;", "openGUI", "context", "Lorg/kingdoms/commands/CommandContext;", "player", "Lorg/bukkit/entity/Player;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean checkForUpdates() {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastCheck < Duration.ofMinutes(5L).toMillis()) {
                return true;
            }
            for (AddonRepository addon : AddonRepository.Companion.getRepository().values()) {
                try {
                    addon.updateInfo();
                }
                catch (Throwable ex) {
                    KLogger.error("Failed to check for addon updates: " + addon.getName() + " -> " + ex.getMessage() + " (Internet connection problems?)");
                    if (KingdomsConfig.DEBUG.getBoolean()) {
                        ex.printStackTrace();
                    }
                    return false;
                }
            }
            lastCheck = currentTime;
            return true;
        }

        @JvmStatic
        public final void notifyAboutUpdates(@NotNull CommandSender sender) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            List outdated = new ArrayList();
            for (AddonRepository addon : AddonRepository.Companion.getRepository().values()) {
                String installedVer;
                Addon installedAddon;
                if (AddonRegistry.getAddon(addon.getPath()) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)installedAddon.getDescription().getVersion(), (String)"installedAddon.description.version");
                if (!UpdateChecker.isHigher(installedVer, addon.getVersion())) continue;
                outdated.add(new Pair((Object)addon, (Object)installedAddon));
            }
            if (outdated.isEmpty()) {
                return;
            }
            boolean isPlayer = sender instanceof Player;
            String firstIndicator = isPlayer ? "\u25cf" : "|";
            String secondIndicator = isPlayer ? "\u279c" : "->";
            String list2 = CollectionsKt.joinToString$default((Iterable)outdated, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Pair<? extends AddonRepository, ? extends Addon>, CharSequence>(firstIndicator, secondIndicator){
                final /* synthetic */ String $firstIndicator;
                final /* synthetic */ String $secondIndicator;
                {
                    this.$firstIndicator = $firstIndicator;
                    this.$secondIndicator = $secondIndicator;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Pair<AddonRepository, ? extends Addon> pair) {
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    AddonRepository repo = (AddonRepository)pair.component1();
                    Addon addon = (Addon)pair.component2();
                    String string = Kingdoms.get().getDescription().getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get().description.version");
                    String currentCoreVersion = string;
                    boolean outdatedCoreVersion = repo.getSupportedCoreVersion() != null && UpdateChecker.isHigher(currentCoreVersion, repo.getSupportedCoreVersion());
                    String coreVersionNotice = outdatedCoreVersion ? " {$sep}({$e}Required Kingdoms Version{$sep}: {$es}" + repo.getSupportedCoreVersion() + "{$sep})" : "";
                    return "  {$sep}" + this.$firstIndicator + " {$p}" + addon.getName() + " {$s}v" + addon.getDescription().getVersion() + " {$sep}" + this.$secondIndicator + " {$s}v" + repo.getVersion() + coreVersionNotice;
                }
            }), (int)30, null);
            MessageBuilder messageBuilder = new MessageBuilder().parse("update", list2);
            Intrinsics.checkNotNullExpressionValue((Object)messageBuilder, (String)"MessageBuilder().parse(\"update\", list)");
            KingdomsLang.COMMAND_ADMIN_ADDONS_NOTIFICATION.sendMessage(sender, messageBuilder);
        }

        @JvmStatic
        public final void openGUI(@NotNull CommandContext context, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_ADDONS_INDEXING, new Object[0]);
            InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.ADDONS);
            if (!this.checkForUpdates()) {
                context.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_INDEXING_FAILED, new Object[0]);
                return;
            }
            ReusableOptionHandler reusableOptionHandler = gui.getReusableOption("addons");
            if (reusableOptionHandler == null) {
                throw new IllegalStateException("Addons option null for gui");
            }
            ReusableOptionHandler addons = reusableOptionHandler;
            String string = Kingdoms.get().getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get().description.version");
            String currentCoreVersion = string;
            gui.getSettings().raw("current-core-version", currentCoreVersion);
            for (AddonRepository addon : AddonRepository.Companion.getRepository().values()) {
                Addon installedAddon = AddonRegistry.getAddon(addon.getPath());
                Addon addon2 = installedAddon;
                String installedVer = addon2 != null && (addon2 = addon2.getDescription()) != null ? addon2.getVersion() : null;
                boolean outdated = installedVer != null && UpdateChecker.isHigher(installedVer, addon.getVersion());
                boolean outdatedCoreVersion = addon.getSupportedCoreVersion() != null && UpdateChecker.isHigher(currentCoreVersion, addon.getSupportedCoreVersion());
                Object[] objectArray = new Object[]{"addon-name", addon.getName(), "latest-version", addon.getVersion(), "supported-core-version", addon.getSupportedCoreVersion(), "installed", installedAddon != null, "installed-version", installedVer, "outdated", outdated, "outdated_core_version", outdatedCoreVersion, "waiting_to_restart", installedAddon == null && Files.exists(addon.getDownloadPath(), new LinkOption[0])};
                ReusableOptionHandler opt = addons.setEdits(objectArray);
                opt.getSettings().parse("description", addon.getDescription());
                if (outdated && Files.exists(addon.getDownloadPath(), new LinkOption[0])) {
                    opt.getSettings().raw("addon-file", addon.getDownloadPath());
                    opt.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_MISMATCH, new Object[0]);
                    continue;
                }
                if (!Files.exists(addon.getDownloadPath(), new LinkOption[0]) && (outdated || installedAddon == null)) {
                    opt.on(ClickType.LEFT, arg_0 -> Companion.openGUI$lambda-2(player, outdatedCoreVersion, addon, outdated, installedAddon, arg_0));
                }
                if (installedAddon != null) {
                    opt.on(ClickType.RIGHT, arg_0 -> Companion.openGUI$lambda-3(player, installedAddon, arg_0));
                }
                opt.done();
            }
            Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
            InteractiveGUI.open$default(gui, false, false, 3, null);
        }

        private static final void openGUI$lambda-2$lambda-1$lambda-0(boolean $outdated, Addon $installedAddon, OptionHandler $ctx) {
            if ($outdated) {
                AddonRegistry.uninstall($installedAddon, true);
                $ctx.sendMessage(KingdomsLang.COMMAND_ADMIN_ADDONS_FINISH_UPDATING, new Object[0]);
            } else {
                $ctx.sendMessage(KingdomsLang.COMMAND_ADMIN_ADDONS_INSTALLED, new Object[0]);
            }
        }

        private static final void openGUI$lambda-2$lambda-1(OptionHandler $ctx, AddonRepository $addon, boolean $outdated, Addon $installedAddon) {
            Intrinsics.checkNotNullParameter((Object)$addon, (String)"$addon");
            try {
                $ctx.sendMessage(KingdomsLang.COMMAND_ADMIN_ADDONS_DOWNLOADING, new Object[0]);
                $addon.download();
            }
            catch (Exception ex) {
                $ctx.getSettings().raw("message", ex.getMessage());
                $ctx.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_DOWNLOAD_FAILED, new Object[0]);
                ex.printStackTrace();
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> Companion.openGUI$lambda-2$lambda-1$lambda-0($outdated, $installedAddon, $ctx));
        }

        private static final void openGUI$lambda-2(Player $player, boolean $outdatedCoreVersion, AddonRepository $addon, boolean $outdated, Addon $installedAddon, OptionHandler ctx) {
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            Intrinsics.checkNotNullParameter((Object)$addon, (String)"$addon");
            $player.closeInventory();
            if ($outdatedCoreVersion) {
                ctx.sendError(KingdomsLang.COMMAND_ADMIN_ADDONS_OUTDATED_CORE_VERSION, new Object[0]);
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> Companion.openGUI$lambda-2$lambda-1(ctx, $addon, $outdated, $installedAddon));
        }

        private static final void openGUI$lambda-3(Player $player, Addon $installedAddon, OptionHandler ctx) {
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            $player.closeInventory();
            KLogger.info("Uninstalling addon " + $installedAddon.getName() + " v" + $installedAddon.getDescription().getVersion());
            ctx.sendMessage(KingdomsLang.COMMAND_ADMIN_ADDONS_UNINSTALLING, new Object[0]);
            AddonRegistry.uninstall($installedAddon, false);
            ctx.sendMessage(KingdomsLang.COMMAND_ADMIN_ADDONS_UNINSTALLING_DONE, new Object[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

