/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminKick
extends KingdomsCommand {
    public CommandAdminKick(KingdomsParentCommand parent) {
        super("kick", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (!context.assertArgs(1)) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_KICK_USAGE, new Object[0]);
            return;
        }
        OfflinePlayer player = context.getOfflinePlayer(0);
        if (player == null) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_KICK_NOT_IN_KINGDOM, "kicked", player.getName());
            return;
        }
        if (player.getUniqueId().equals(kingdom.getKingId())) {
            KingdomPlayer nextKing = Rank.determineNextKing((ArrayList)kingdom.getKingdomPlayers(), null);
            if (nextKing == null) {
                if (!kingdom.disband(GroupDisband.Reason.ADMIN).isCancelled()) {
                    context.sendMessage(KingdomsLang.COMMAND_ADMIN_KICK_KICKED_DISBANDED, "kicked", player.getName(), "kingdom", kingdom.getName());
                }
                return;
            }
            if (kingdom.setKing(nextKing, KingdomKingChangeEvent.Reason.ADMIN).isCancelled()) {
                return;
            }
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_KICK_KICKED_KING, "kicked", player.getName(), "kingdom", kingdom.getName(), "king", nextKing.getOfflinePlayer().getName());
        } else {
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_KICK_KICKED, "kicked", player.getName(), "kingdom", kingdom.getName());
        }
        kp.leaveKingdom(LeaveReason.ADMIN);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getPlayers(0, p -> KingdomPlayer.getKingdomPlayer(p).hasKingdom());
        }
        return CommandAdminKick.emptyTab();
    }
}

