/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.SetterHandler;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminMaxLandModifier
extends KingdomsCommand {
    public CommandAdminMaxLandModifier(KingdomsParentCommand parent) {
        super("maxLandModifier", parent);
    }

    @Override
    public void execute(CommandContext context) {
        String number;
        String action;
        if (context.requireArgs(2)) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        if (args.length > 2) {
            action = args[1];
            number = args[2];
        } else {
            action = "add";
            number = args[1];
        }
        SetterHandler.SetterResult result = SetterHandler.eval(action, (double)kingdom.getMaxLandsModifier(), number);
        if (result == SetterHandler.SetterResult.NOT_NUMBER) {
            KingdomsLang.INVALID_NUMBER.sendMessage(sender, "arg", number);
            return;
        }
        if (result == SetterHandler.SetterResult.UNKNOWN) {
            KingdomsLang.COMMAND_ADMIN_MAXLANDMODIFIER_INVALID_ACTION.sendMessage(sender, "action", action);
            return;
        }
        kingdom.setMaxLandsModifier((int)result.getValue());
        KingdomsLang.COMMAND_ADMIN_MAXLANDMODIFIER_SUCCESS.sendMessage(sender, "kingdom", kingdom.getName(), "amount", kingdom.getMaxLandsModifier());
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getKingdoms(args[0]);
        }
        if (args.length == 2) {
            return SetterHandler.tabComplete(args[1]);
        }
        if (args.length == 3) {
            return Collections.singletonList("<amount>");
        }
        return new ArrayList<String>();
    }
}

