/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminPacifism
extends KingdomsCommand {
    public CommandAdminPacifism(KingdomsParentCommand parent) {
        super("pacifism", parent);
    }

    @Override
    public void execute(CommandContext context) {
        boolean pacifist;
        if (context.requireArgs(1)) {
            return;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        if (context.assertArgs(2)) {
            Boolean bool = context.parseBool(1);
            if (bool == null) {
                return;
            }
            pacifist = bool;
        } else {
            pacifist = !kingdom.isPacifist();
        }
        kingdom.setPacifist(pacifist);
        context.sendMessage(pacifist ? KingdomsLang.COMMAND_ADMIN_PACIFISM_ENABLED : KingdomsLang.COMMAND_ADMIN_PACIFISM_DISABLED, "kingdom", kingdom.getName());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        return CommandAdminPacifism.emptyTab();
    }
}

