/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.PlayerUtils;

public class CommandAdminRank
extends KingdomsCommand {
    public CommandAdminRank(KingdomsParentCommand parent) {
        super("rank", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.requireArgs(2)) {
            return;
        }
        OfflinePlayer player = context.getOfflinePlayer(0);
        if (player == null) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
        context.getSettings().withContext(player);
        if (!kp.hasKingdom()) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_RANK_NO_KINGDOM, new Object[0]);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        Rank rank = kingdom.getRanks().get(context.arg(1));
        context.var("rank", context.arg(1));
        if (rank == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_RANK_NOT_FOUND, new Object[0]);
            return;
        }
        Rank previousRank = kp.getRank();
        context.var("previous_rank", previousRank.getColor() + previousRank.getSymbol() + ' ' + previousRank.getName()).var("rank", rank.getColor() + rank.getSymbol() + ' ' + rank.getName());
        if (rank.equals(previousRank)) {
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_RANK_SAME_RANK, new Object[0]);
            return;
        }
        if (previousRank.isKing()) {
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_RANK_CANT_DEMOTE_KING, new Object[0]);
            return;
        }
        if (rank.isKing()) {
            if (kingdom.setKing(kp, KingdomKingChangeEvent.Reason.ADMIN).isCancelled()) {
                return;
            }
            context.sendMessage(KingdomsLang.COMMAND_ADMIN_RANK_SUCCESS_KING, "previous_rank", previousRank.getName(), "rank", rank.getName(), "name", player.getName(), "kingdom", kingdom.getName());
            return;
        }
        kp.setRank(context.isPlayer() ? KingdomPlayer.getKingdomPlayer((OfflinePlayer)context.senderAsPlayer()) : null, rank);
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_RANK_SUCCESS, new Object[0]);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getPlayers(0);
        }
        if (context.isAtArg(1)) {
            OfflinePlayer player = PlayerUtils.getOfflinePlayer(context.arg(0));
            if (player == null) {
                return CommandAdminRank.emptyTab();
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return CommandAdminRank.emptyTab();
            }
            Set<String> ranks = kingdom.getRanks().getRanks().keySet();
            String starts = context.arg(1).toLowerCase();
            if (starts.isEmpty()) {
                return new ArrayList<String>(ranks);
            }
            return ranks.stream().filter(x -> x.toLowerCase().startsWith(starts)).collect(Collectors.toList());
        }
        return CommandAdminRank.emptyTab();
    }
}

