/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.SetterHandler;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public class CommandAdminShield
extends KingdomsCommand {
    public CommandAdminShield(KingdomsParentCommand parent) {
        super("shield", parent);
    }

    @Override
    public void execute(CommandContext context) {
        String number;
        String action;
        String[] args = context.args;
        CommandSender sender = context.getSender();
        if (args.length < 2) {
            KingdomsLang.COMMAND_ADMIN_SHIELD_USAGE.sendMessage(sender);
            return;
        }
        Kingdom kingdom = Kingdom.getKingdom(args[0]);
        if (kingdom == null) {
            KingdomsLang.COMMAND_ADMIN_SHIELD_INVALID_KINGDOM.sendMessage(sender, "kingdom", args[0]);
            return;
        }
        if (args.length > 2) {
            action = args[1];
            number = args[2];
        } else {
            action = "add";
            number = args[1];
        }
        Long millis = TimeUtils.parseTime(number, TimeUnit.HOURS);
        if (millis == null) {
            KingdomsLang.COMMAND_ADMIN_SHIELD_INVALID_TIME.sendMessage(sender, "time", number);
            return;
        }
        SetterHandler.SetterResult result = SetterHandler.eval(action, (double)kingdom.getShieldTime(), millis.longValue());
        if (result == SetterHandler.SetterResult.NOT_NUMBER) {
            KingdomsLang.INVALID_NUMBER.sendMessage(sender, "arg", number);
            return;
        }
        if (result == SetterHandler.SetterResult.UNKNOWN) {
            KingdomsLang.COMMAND_ADMIN_SHIELD_INVALID_ACTION.sendMessage(sender, "action", action);
            return;
        }
        long time = (long)result.getValue();
        if (time > 0L) {
            kingdom.activateShield(time, true);
        } else {
            kingdom.setShieldTime(time);
        }
        KingdomsLang.COMMAND_ADMIN_SHIELD_SUCCESS.sendMessage(sender, "kingdom", kingdom.getName(), "amount", TimeFormatter.of(kingdom.getShieldTimeLeft()));
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getKingdoms(args[0]);
        }
        if (args.length == 2) {
            return SetterHandler.tabComplete(args[1]);
        }
        if (args.length == 3) {
            return Collections.singletonList("<time>");
        }
        return new ArrayList<String>();
    }
}

