/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.claim;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.indicator.LandVisualizer;

public class CommandAdminClaim
extends KingdomsCommand {
    public CommandAdminClaim(KingdomsParentCommand parent) {
        super("claim", parent);
    }

    @Override
    public void execute(CommandContext context) {
        Kingdom landOwner;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
        Land land = chunk.getLand();
        if (land != null && (landOwner = land.getKingdom()) != null) {
            context.getSettings().withContext(landOwner);
            context.fail(KingdomsLang.COMMAND_ADMIN_CLAIM_ALREADY_CLAIMED, new Object[0]);
            return;
        }
        if (kingdom.claim(chunk, kp, ClaimLandEvent.Reason.ADMIN).isCancelled()) {
            return;
        }
        KingdomsLang.COMMAND_ADMIN_CLAIM_SUCCESS.sendMessage((CommandSender)player, "x", chunk.getX(), "z", chunk.getZ(), "kingdom", kingdom.getName());
        new LandVisualizer().forPlayer(player, kp).forLand(land, chunk.toChunk()).display(true);
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender instanceof Player && args.length == 1) {
            return TabCompleteManager.getKingdoms(args[0]);
        }
        return new ArrayList<String>();
    }
}

