/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.claim;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.claim.CommandAdminUnclaimAll;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminUnclaim
extends KingdomsParentCommand {
    public CommandAdminUnclaim(KingdomsParentCommand parent) {
        super("unclaim", parent);
        new CommandAdminUnclaimAll(this);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        Land land = Land.getLand(player.getLocation());
        if (land == null || !land.isClaimed()) {
            KingdomsLang.COMMAND_ADMIN_UNCLAIM_NOT_CLAIMED.sendMessage((CommandSender)player);
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (land.unclaim(KingdomPlayer.getKingdomPlayer((OfflinePlayer)player), UnclaimLandEvent.Reason.ADMIN).isCancelled()) {
            return;
        }
        SimpleChunkLocation chunk = land.getLocation();
        KingdomsLang.COMMAND_ADMIN_UNCLAIM_SUCCESS.sendMessage((CommandSender)player, "x", chunk.getX(), "z", chunk.getZ(), "kingdom", kingdom.getName());
    }
}

