/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.placeholders.KingdomsPlaceholder;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParser;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminEvaluate
extends KingdomsCommand {
    private static final Pattern HEXADECIMAL = Pattern.compile("0x[A-Za-z0-9]+");
    private static final Pattern SHORT_DECIMAL = Pattern.compile("[^\\d]+(\\.\\d+)");
    private static final Pattern VARIABLE_BINDINGS = Pattern.compile("(?:let|var|const|val|where)\\s+\\w+\\s*=");
    private static final Pattern EXPLICIT_POS_SIGN = Pattern.compile("[^A-Za-z0-9})\\]\\s]\\s*\\+\\s*\\d+");
    private static final String[] NAMES;
    public static final double DEFAULT_VAR_VAL = 10.0;
    private static final List<Pair<String, String>> OPERATIONS;

    private static String getParams(String meth) {
        for (Method method : Math.class.getMethods()) {
            if (!method.getName().equals(meth)) continue;
            return '(' + StringUtils.join(Arrays.stream(method.getParameters()).map(Parameter::getName).toArray(String[]::new), ",") + ')';
        }
        return "()";
    }

    private static StringBuilder argsOf(int count) {
        StringBuilder args = new StringBuilder("(");
        for (int i = 0; i < count; ++i) {
            args.append("arg").append(i);
            if (i >= count - 1) continue;
            args.append(',');
        }
        return args.append(')');
    }

    public CommandAdminEvaluate(KingdomsParentCommand parent) {
        super("evaluate", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return;
        }
        String message = context.joinArgs();
        CommandAdminEvaluate.compile(context.getSender(), message);
    }

    public static MathCompiler.Expression compile(CommandSender sender, String message) {
        MathCompiler.Expression result;
        try {
            result = MathCompiler.compile(message);
        }
        catch (Exception ex) {
            Matcher matcher;
            KingdomsLang.COMMAND_ADMIN_EVALUATE_FAILED.sendError(sender, new MessageBuilder().raws("translated", message, "result", ex.getMessage()));
            if (sender instanceof Player) {
                MessageHandler.sendPluginMessage(sender, "&eWarning&8: &6Due to the nature of Minecraft's font typeface, some error pointers may point to inaccurate characterswithin the expression, to see the correct location, go to &2Options &7-> &2Language &7-> &2Force Unicode Font: ON\n&6or use this command from your console.");
            }
            if (message.contains("**")) {
                MessageHandler.sendMessage(sender, "&eWarning&8: &2^ &6is used as the exponentiation operator not &2**");
            }
            if ((matcher = HEXADECIMAL.matcher(message)).find()) {
                MessageHandler.sendMessage(sender, "&eWarning&8: &6Hexadecimal numbers &2" + matcher.group() + "&2 &6are not supported.");
            }
            if ((matcher = SHORT_DECIMAL.matcher(message)).find()) {
                MessageHandler.sendMessage(sender, "&eWarning&8: &6Short decimal notations &2'" + matcher.group(1) + "&2' &6are not supported.");
            }
            if ((matcher = EXPLICIT_POS_SIGN.matcher(message)).find()) {
                MessageHandler.sendMessage(sender, "&eWarning&8: &6Explicit positive signs &2'" + matcher.group() + "&2' &6are not supported.");
            }
            if ((matcher = VARIABLE_BINDINGS.matcher(message)).find()) {
                MessageHandler.sendMessage(sender, "&eWarning&8: &6Variable bindings &2'" + matcher.group() + "&2' &6are not supported.");
            }
            return null;
        }
        double evaluated = result.eval(x -> {
            if (sender instanceof Player && x.startsWith("kingdoms")) {
                Placeholder parsed = PlaceholderParser.parsePlaceholder(x.substring("kingdoms".length() + 1));
                Object res = parsed.request(new MessageBuilder().withContext(sender));
                try {
                    if (res == null) {
                        MessageHandler.sendMessage(sender, "&cError&8: &6Failed to parse &e'" + x + "&e' &6placeholder, defaulting to &e10");
                        return 10.0;
                    }
                    try {
                        return MathUtils.expectDouble(x, result);
                    }
                    catch (IllegalArgumentException ex) {
                        return Double.parseDouble(res.toString());
                    }
                }
                catch (NumberFormatException ex) {
                    String hint = parsed.modifier == null ? "" : "(&9hint&8: &7Consider removing the &2" + (Object)((Object)parsed.modifier) + " &7placeholder modifier";
                    MessageHandler.sendMessage(sender, "&cError&8: &6The &e'" + x + "&e' &6placeholder isn't a number placeholder, defaulting to &e10 " + hint);
                    return 10.0;
                }
            }
            Object global = new MessageBuilder().withContext(sender).processPlaceholder((String)x);
            if (global != null) {
                return MathUtils.expectDouble(x, global);
            }
            MessageHandler.sendMessage(sender, "&eWarning&8: &6Variable &e'" + x + "' &6is unrecognized. Defaulting to &210.0 &6for evaluation to succeed.");
            return 10.0;
        });
        KingdomsLang.COMMAND_ADMIN_EVALUATE_EVALUATED.sendMessage(sender, "translated", message, "result", evaluated, "object-code", result);
        if (evaluated == Double.POSITIVE_INFINITY || evaluated == Double.NEGATIVE_INFINITY || Double.isNaN(evaluated)) {
            MessageHandler.sendMessage(sender, "&eWarning&8: &2Infinity/NaN &6answer means you've performed an &2undefined &6mathematical operation such as dividing by zero.");
        }
        return result;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (!context.assertArgs(1)) {
            return Arrays.asList(NAMES);
        }
        String arg = context.currentArg().toLowerCase();
        if (context.isNumber(context.args.length - 1)) {
            return CommandAdminEvaluate.emptyTab();
        }
        if (arg.startsWith("k")) {
            return KingdomsPlaceholder.NAMES.keySet().stream().filter(x -> !arg.startsWith("kingdoms_") || x.startsWith(StringUtils.remove(arg, "kingdoms_"))).map(x -> "kingdoms_" + x).collect(Collectors.toList());
        }
        if (arg.startsWith("[")) {
            return CommandAdminEvaluate.tabComplete("[<number> <days|hours|mins|secs>]");
        }
        if (arg.startsWith("{")) {
            return CommandAdminEvaluate.tabComplete("{variable}");
        }
        if (arg.startsWith("(")) {
            return CommandAdminEvaluate.tabComplete("Open subexpression");
        }
        if (arg.startsWith(")")) {
            return CommandAdminEvaluate.tabComplete("Close subexpression");
        }
        if (OPERATIONS.stream().anyMatch(x -> ((String)x.getKey()).equals(arg))) {
            return OPERATIONS.stream().map(x -> (String)x.getKey() + ' ' + (String)x.getValue()).collect(Collectors.toList());
        }
        return context.suggest(context.args.length - 1, NAMES);
    }

    static {
        OPERATIONS = Arrays.asList(Pair.of("+", "Addition"), Pair.of("-", "Subtraction"), Pair.of("*", "Multipication"), Pair.of("/", "Division"), Pair.of("^", "Exponentiation"), Pair.of("%", "Remainder"), Pair.of("#", "Bit Rotation Right"), Pair.of("@", "Bit Rotation Left"), Pair.of("|", "Bitwise OR"), Pair.of("&", "Bitwise AND"), Pair.of("!", "Bitwise XOR"), Pair.of(">", "Bitwise shift right"), Pair.of("<", "Bitwise shift left"));
        NAMES = new String[MathCompiler.getConstants().size() + MathCompiler.getFunctions().size()];
        int i = 0;
        for (String string : MathCompiler.getConstants().keySet()) {
            CommandAdminEvaluate.NAMES[i++] = string;
        }
        for (Map.Entry entry : MathCompiler.getFunctions().entrySet()) {
            String params = CommandAdminEvaluate.getParams((String)entry.getKey());
            CommandAdminEvaluate.NAMES[i++] = (String)entry.getKey() + (params.equals("()") ? CommandAdminEvaluate.argsOf(((MathCompiler.Function)entry.getValue()).getArgCount()) : params);
        }
    }
}

