/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.debugging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;

public class CommandAdminRepl
extends KingdomsCommand
implements Listener {
    private static final Object JSHELL;
    private static final Set<UUID> TOGGLED;

    public CommandAdminRepl(KingdomsParentCommand parent) {
        super("repl", parent);
    }

    private static String tinyEval(Player player, String str) {
        int index = str.indexOf(32);
        String fn = str.substring(0, index);
        String[] params = str.substring(index + 1).split(" ");
        Object[] parameters = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            try {
                parameters[i] = Integer.parseInt(param);
                continue;
            }
            catch (NumberFormatException ex) {
                if (param.equals("true") || param.equals("false")) {
                    parameters[i] = param.equals("true");
                    continue;
                }
                if (param.equals("nil")) {
                    parameters[i] = null;
                    continue;
                }
                throw new IllegalArgumentException("unknown type " + param);
            }
        }
        for (Method meth : player.getClass().getMethods()) {
            if (!meth.getName().equals(fn)) continue;
            try {
                return String.valueOf(meth.invoke((Object)player, parameters));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalArgumentException("Unknown function: " + fn);
    }

    @Override
    public void execute(CommandContext context) {
        Player player = context.senderAsPlayer();
        if (TOGGLED.add(player.getUniqueId())) {
            player.sendMessage("Activated;");
        } else {
            TOGGLED.remove(player.getUniqueId());
            player.sendMessage("Deactivated;");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onREPL(AsyncPlayerChatEvent event) {
        if (!TOGGLED.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        try {
            event.getPlayer().sendMessage("\u03bb> " + event.getMessage());
            String response = CommandAdminRepl.tinyEval(event.getPlayer(), event.getMessage());
            event.getPlayer().sendMessage("\u279c " + response);
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.filter(Arrays.stream(Player.class.getMethods()).map(Method::getName), 0).collect(Collectors.toList());
        }
        Optional<Method> meth = Arrays.stream(Player.class.getMethods()).filter(x -> x.getName().equals(context.arg(0))).findFirst();
        if (!meth.isPresent()) {
            return CommandAdminRepl.tabComplete("Unknown method");
        }
        Parameter[] params = meth.get().getParameters();
        if (params.length < context.args.length) {
            return CommandAdminRepl.tabComplete("Too many arguments");
        }
        Parameter param = params[context.args.length - 1];
        return CommandAdminRepl.tabComplete(param.getName() + ": " + param.getType().getName());
    }

    static {
        TOGGLED = new HashSet<UUID>();
        Object jshell = null;
        try {
            Class<?> jshellClass = Class.forName("jdk.jshell.JShell");
            jshell = jshellClass.getMethod("create", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        JSHELL = jshell;
    }
}

