/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.item;

import com.google.common.base.Function;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.admin.item.CommandAdminItem;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.internal.Fn;
import org.kingdoms.utils.string.StringUtils;

public class CommandAdminItemStructure
extends KingdomsCommand {
    public CommandAdminItemStructure(KingdomsParentCommand parent) {
        super("structure", parent);
    }

    @Override
    public void execute(CommandContext context) {
        KingdomPlayer kp;
        Kingdom kingdom;
        Player target;
        if (context.requireArgs(1)) {
            return;
        }
        StructureStyle style = StructureRegistry.getStyles().get(context.arg(0).toLowerCase(Locale.ENGLISH));
        if (style == null) {
            String styles = StringUtils.join("&8, ", StructureRegistry.getStyles().keySet(), (Function<String, String>)((Function)s -> "&6" + s));
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_STRUCTURE_UNKNOWN_STYLE, "style", context.arg(0), "styles", styles);
            return;
        }
        if (!style.hasItem()) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_STYLE_HAS_NO_ITEM, "style", context.arg(0));
            return;
        }
        int amount = 1;
        if (context.assertArgs(2)) {
            if (!context.isNumber(1)) {
                context.sendError(KingdomsLang.INVALID_NUMBER, "arg", context.arg(1));
                return;
            }
            amount = Integer.parseInt(context.arg(1));
            if (amount < 1) {
                context.sendError(KingdomsLang.INVALID_AMOUNT, "amount", amount);
                return;
            }
        }
        if (context.assertArgs(3)) {
            target = context.getPlayer(2);
            if (target == null) {
                return;
            }
        } else {
            if (!context.isPlayer()) {
                context.wrongUsage();
                return;
            }
            target = context.senderAsPlayer();
        }
        if ((kingdom = (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)target)).getKingdom()) == null) {
            context.sendError(KingdomsLang.COMMAND_ADMIN_ITEM_NEEDS_KINGDOM, new Object[0]);
            return;
        }
        ItemStack item = style.buildItem(kingdom);
        item.setAmount(amount);
        XItemStack.giveOrDrop(target, item);
        context.sendMessage(KingdomsLang.COMMAND_ADMIN_ITEM_STRUCTURE_DONE, "amount", amount, "item", context.arg(0), "target", target.getName());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandAdminItem.getValidStyles((Map)Fn.cast(StructureRegistry.getStyles()));
        }
        if (context.isAtArg(1)) {
            return CommandAdminItemStructure.tabComplete("&9[amount]");
        }
        if (context.isAtArg(2)) {
            return context.getPlayers(2);
        }
        return CommandAdminItemStructure.emptyTab();
    }
}

