/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.item;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.kingdoms.commands.admin.CommandAdminLanguagePack;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.GUIOption;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Reflection;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.xseries.SkullUtils;
import org.kingdoms.libs.xseries.XEnchantment;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.internal.TriConsumer;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTWrappers;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.string.tree.StringPathBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\"\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u001e\u0010 \u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000eJ\u001c\u0010#\u001a\n \t*\u0004\u0018\u00010\u000e0\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J0\u0010$\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00170&J\u0006\u0010'\u001a\u00020\u0017J*\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170,J\"\u0010-\u001a\u00020\u00172\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0,2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170,J\u0006\u0010.\u001a\u00020\u000bJ.\u0010/\u001a\u00020\u00172\b\u0010)\u001a\u0004\u0018\u0001002\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000,2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170,J\u0006\u00101\u001a\u00020\u000bJ\u0006\u00102\u001a\u00020\u0017J\u0012\u00103\u001a\u00020\u0005*\u00020\u00052\u0006\u00104\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/kingdoms/commands/admin/item/ItemEditor;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "(Lorg/bukkit/entity/Player;Lorg/bukkit/inventory/ItemStack;)V", "rootNBT", "Lorg/kingdoms/utils/nbt/NBTWrappers$NBTTagCompound;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "buildPathsFrom", "", "list", "", "", "nbt", "currentPath", "constructNBT", "Lorg/kingdoms/utils/nbt/NBTWrappers$NBTBase;", "type", "value", "", "finalize", "Lorg/kingdoms/gui/InteractiveGUI;", "gui", "getEditsForAttribute", "Lorg/kingdoms/locale/provider/MessageBuilder;", "attribute", "Lorg/bukkit/attribute/Attribute;", "modifier", "Lorg/bukkit/attribute/AttributeModifier;", "getEditsForItem", "getItemFromGUI", "Lorg/kingdoms/gui/KingdomsGUI;", "optionName", "getTypeOfNBT", "openAttributeBuilderGUI", "guiModifier", "Lorg/kingdoms/utils/internal/TriConsumer;", "openAttributeGUI", "openAttributeOperationsGUI", "currentValue", "Lorg/bukkit/attribute/AttributeModifier$Operation;", "selected", "Ljava/util/function/Consumer;", "openAttributeTypesGUI", "openEnchantsGUI", "openEquipmentSlotSelector", "Lorg/bukkit/inventory/EquipmentSlot;", "openFlagsGUI", "openGUI", "inheritLoreAndType", "other", "NBTEditor", "core"})
public final class ItemEditor {
    @NotNull
    private final Player player;
    @NotNull
    private ItemStack item;
    private final NBTWrappers.NBTTagCompound rootNBT;

    public ItemEditor(@NotNull Player player, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.player = player;
        this.item = item;
        this.rootNBT = ItemNBT.getTag(this.item);
    }

    private final MessageBuilder getEditsForItem() {
        String string;
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        MessageBuilder messageBuilder = new MessageBuilder();
        Object[] objectArray = new Object[2];
        objectArray[0] = "item_name";
        if (meta.hasDisplayName()) {
            String string2 = meta.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"meta.displayName");
            string = StringsKt.replace$default((String)string2, (char)'\u00a7', (char)'&', (boolean)false, (int)4, null);
        } else {
            string = StringUtils.capitalize(this.item.getType().name());
        }
        objectArray[1] = string;
        MessageBuilder settings = messageBuilder.placeholders(objectArray).raw("item_amount", this.item.getAmount()).raw("item_material", KingdomsLang.translateMaterial(XMaterial.matchXMaterial(this.item))).raw("item_custom_model_data", XMaterial.supports(14) && meta.hasCustomModelData() ? meta.getCustomModelData() : 0).raw("item_unbreakable", meta.isUnbreakable());
        Intrinsics.checkNotNullExpressionValue((Object)XItemStack.ITEM_FLAGS, (String)"ITEM_FLAGS");
        for (ItemFlag flag : XItemStack.ITEM_FLAGS) {
            StringBuilder stringBuilder = new StringBuilder().append("item_flag_");
            String string3 = flag.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            settings.raw(stringBuilder.append(string3).toString(), meta.hasItemFlag(flag) ? KingdomsLang.ENABLED.parse(new Object[0]) : KingdomsLang.DISABLED.parse(new Object[0]));
        }
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings");
        return settings;
    }

    private final MessageBuilder getEditsForAttribute(Attribute attribute, AttributeModifier modifier) {
        MessageBuilder messageBuilder = new MessageBuilder();
        Object[] objectArray = new Object[12];
        objectArray[0] = "attribute_type";
        objectArray[1] = StringUtils.capitalize(attribute.name());
        objectArray[2] = "attribute_uuid";
        objectArray[3] = modifier.getUniqueId();
        objectArray[4] = "attribute_name";
        objectArray[5] = modifier.getName();
        objectArray[6] = "attribute_amount";
        objectArray[7] = modifier.getAmount();
        objectArray[8] = "attribute_operation";
        objectArray[9] = StringUtils.capitalize(modifier.getOperation().name());
        objectArray[10] = "attribute_equipment_slot";
        Object object = modifier.getSlot();
        if (object == null || (object = object.name()) == null) {
            object = "Any";
        }
        objectArray[11] = StringUtils.capitalize((String)object);
        MessageBuilder messageBuilder2 = messageBuilder.raws(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)messageBuilder2, (String)"MessageBuilder()\n       \u2026 ?: \"Any\"),\n            )");
        return messageBuilder2;
    }

    private final String getTypeOfNBT(NBTWrappers.NBTBase<?> nbt) {
        NBTWrappers.NBTBase<?> nBTBase = nbt;
        return nBTBase instanceof NBTWrappers.NBTTagString ? "string" : (nBTBase instanceof NBTWrappers.NBTTagInt ? "int" : (nBTBase instanceof NBTWrappers.NBTTagDouble ? "double" : (nBTBase instanceof NBTWrappers.NBTTagByte ? "byte" : (nBTBase instanceof NBTWrappers.NBTTagLong ? "long" : (nBTBase instanceof NBTWrappers.NBTTagShort ? "short" : (nBTBase instanceof NBTWrappers.NBTTagEnd ? "end" : (nBTBase instanceof NBTWrappers.NBTTagFloat ? "float" : (nBTBase instanceof NBTWrappers.NBTTagCompound ? "compound" : (nBTBase instanceof NBTWrappers.NBTTagList ? "list" : nbt.getClass().getSimpleName())))))))));
    }

    private final void buildPathsFrom(List<String> list2, NBTWrappers.NBTTagCompound nbt, String currentPath) {
        if (((Map)nbt.getValue()).isEmpty()) {
            list2.add(currentPath);
            return;
        }
        Object t = nbt.getValue();
        Intrinsics.checkNotNullExpressionValue(t, (String)"nbt.value");
        for (Map.Entry entry : ((Map)t).entrySet()) {
            String path;
            String key = (String)entry.getKey();
            NBTWrappers.NBTBase value = (NBTWrappers.NBTBase)entry.getValue();
            String string = path = ((CharSequence)currentPath).length() == 0 ? key : currentPath + '/' + key;
            if (value instanceof NBTWrappers.NBTTagCompound) {
                NBTWrappers.NBTTagCompound nBTTagCompound = (NBTWrappers.NBTTagCompound)value;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                this.buildPathsFrom(list2, nBTTagCompound, path);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            list2.add(path);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final NBTWrappers.NBTBase<?> constructNBT(@NotNull String type, @NotNull Collection<String> value) {
        NBTWrappers.NBTBase nBTBase;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        switch (type) {
            case "NBTTagCompound": {
                nBTBase = new NBTWrappers.NBTTagCompound();
                break;
            }
            case "NBTTagList": {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void x;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new NBTWrappers.NBTTagString((String)x));
                }
                List list2 = (List)destination$iv$iv;
                nBTBase = new NBTWrappers.NBTTagList(list2);
                break;
            }
            case "NBTTagEnd": {
                nBTBase = new NBTWrappers.NBTTagEnd();
                break;
            }
            case "NBTTagByte": {
                nBTBase = new NBTWrappers.NBTTagByte(Byte.parseByte(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagShort": {
                nBTBase = new NBTWrappers.NBTTagShort(Short.parseShort(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagInt": {
                nBTBase = new NBTWrappers.NBTTagInt(Integer.parseInt(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagLong": {
                nBTBase = new NBTWrappers.NBTTagLong(Long.parseLong(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagFloat": {
                nBTBase = new NBTWrappers.NBTTagFloat(Float.parseFloat(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagDouble": {
                nBTBase = new NBTWrappers.NBTTagDouble(Double.parseDouble(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null)));
                break;
            }
            case "NBTTagString": {
                nBTBase = new NBTWrappers.NBTTagString(CollectionsKt.joinToString$default((Iterable)value, null, null, null, (int)0, null, null, (int)63, null));
                break;
            }
            case "NBTTagByteArray": {
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String x = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Byte.parseByte(x));
                }
                byte[] byArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                nBTBase = new NBTWrappers.NBTTagByteArray(byArray);
                break;
            }
            case "NBTTagIntArray": {
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String x = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Integer.parseInt(x));
                }
                int[] nArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                nBTBase = new NBTWrappers.NBTTagIntArray(nArray);
                break;
            }
            case "NBTTagLongArray": {
                Iterable $this$map$iv = value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String x = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Long.parseLong(x));
                }
                long[] lArray = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
                nBTBase = new NBTWrappers.NBTTagLongArray(lArray);
                break;
            }
            default: {
                nBTBase = null;
            }
        }
        return nBTBase;
    }

    @NotNull
    public final InteractiveGUI openGUI() {
        Object t = new GUIBuilder(KingdomsGUI.ITEM$EDITOR_MAIN).forPlayer(this.player).withSettings(this.getEditsForItem()).inventoryGUIOnly().build();
        Intrinsics.checkNotNull(t);
        InventoryInteractiveGUI gui = (InventoryInteractiveGUI)t;
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        gui.option("item").editItem(arg_0 -> ItemEditor.openGUI$lambda-4(this, arg_0)).done();
        gui.option("name").onNormalClicks(ItemEditor::openGUI$lambda-5).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda-6(meta, this, arg_0, arg_1)).done();
        gui.option("lore").onNormalClicks(ItemEditor::openGUI$lambda-7).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda-8(meta, this, arg_0, arg_1)).editItem(arg_0 -> ItemEditor.openGUI$lambda-10(meta, arg_0)).done();
        gui.option("material").onNormalClicks(ItemEditor::openGUI$lambda-11).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda-12(this, arg_0, arg_1)).editItem(arg_0 -> ItemEditor.openGUI$lambda-13(this, arg_0)).done();
        gui.option("amount").onNormalClicks(ItemEditor::openGUI$lambda-14).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda-15(this, arg_0, arg_1)).done();
        gui.option("custom-model-data").onNormalClicks(ItemEditor::openGUI$lambda-16).setConversation((arg_0, arg_1) -> ItemEditor.openGUI$lambda-17(this, meta, arg_0, arg_1)).done();
        gui.option("enchantments").onNormalClicks(() -> ItemEditor.openGUI$lambda-18(this)).editItem(arg_0 -> ItemEditor.openGUI$lambda-19(meta, arg_0)).done();
        gui.option("attributes").onNormalClicks(() -> ItemEditor.openGUI$lambda-20(this)).done();
        gui.option("flags").onNormalClicks(() -> ItemEditor.openGUI$lambda-21(this)).done();
        gui.option("nbt").onNormalClicks(() -> ItemEditor.openGUI$lambda-24(this)).editItem(arg_0 -> ItemEditor.openGUI$lambda-26(this, arg_0)).done();
        gui.option("unbreakable").onNormalClicks(() -> ItemEditor.openGUI$lambda-27(meta, this)).done();
        gui.onClose(() -> ItemEditor.openGUI$lambda-28(gui, this));
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    @NotNull
    public final InteractiveGUI openAttributeGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_LIST, this.getEditsForItem());
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        gui.option("add-attribute").onNormalClicks(() -> ItemEditor.openAttributeGUI$lambda-31(meta, this)).done();
        gui.option("remove-all").onNormalClicks(() -> ItemEditor.openAttributeGUI$lambda-32(meta, this)).done();
        ReusableOptionHandler reusableOptionHandler = gui.getReusableOption("attribute");
        Intrinsics.checkNotNull((Object)reusableOptionHandler);
        ReusableOptionHandler attrOpt = reusableOptionHandler;
        Object object = meta.getAttributeModifiers();
        if (object != null && (object = object.entries()) != null) {
            Object it = object;
            boolean bl = false;
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"it");
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                attrOpt.on(ClickType.LEFT, () -> ItemEditor.openAttributeGUI$lambda-38$lambda-35(this, attribute, modifier, meta)).on(ClickType.RIGHT, () -> ItemEditor.openAttributeGUI$lambda-38$lambda-36(meta, attribute, modifier, this));
                attrOpt.editItem(arg_0 -> ItemEditor.openAttributeGUI$lambda-38$lambda-37(this, attribute, arg_0));
                MessageBuilder messageBuilder = attrOpt.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attribute");
                Intrinsics.checkNotNullExpressionValue((Object)modifier, (String)"modifier");
                messageBuilder.addAll((Map)this.getEditsForAttribute(attribute, modifier).getPlaceholders());
                attrOpt.done();
            }
        }
        gui.push("back", () -> ItemEditor.openAttributeGUI$lambda-39(this), new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
        return this.finalize(gui);
    }

    @NotNull
    public final ItemStack getItemFromGUI(@NotNull KingdomsGUI gui, @NotNull Player player, @NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)gui, (String)"gui");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        InteractiveGUI fakeGUI = GUIAccessor.prepare(player, gui);
        Object[] objectArray = new Object[]{"enabled", true};
        OptionHandler opt = fakeGUI.option(optionName).setEdits(objectArray);
        GUIOption obj = opt.constructGUIOptionObject();
        obj.defineVariables(opt.getSettings());
        ItemStack itemStack = obj.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"obj.item");
        return itemStack;
    }

    @NotNull
    public final ItemStack inheritLoreAndType(@NotNull ItemStack $this$inheritLoreAndType, @NotNull ItemStack other) {
        Intrinsics.checkNotNullParameter((Object)$this$inheritLoreAndType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        $this$inheritLoreAndType.setType(other.getType());
        if (other.hasItemMeta()) {
            String skinValue;
            ItemMeta itemMeta = other.getItemMeta();
            Intrinsics.checkNotNull((Object)itemMeta);
            ItemMeta otherMeta = itemMeta;
            ItemMeta itemMeta2 = $this$inheritLoreAndType.getItemMeta();
            Intrinsics.checkNotNull((Object)itemMeta2);
            ItemMeta meta = itemMeta2;
            if (otherMeta instanceof SkullMeta && (skinValue = SkullUtils.getSkinValue(otherMeta)) != null) {
                SkullUtils.applySkin((ItemMeta)((SkullMeta)meta), skinValue);
            }
            if (otherMeta.hasLore()) {
                meta.setLore(otherMeta.getLore());
            }
            $this$inheritLoreAndType.setItemMeta(meta);
        }
        return $this$inheritLoreAndType;
    }

    @NotNull
    public final InteractiveGUI openAttributeBuilderGUI(@NotNull Attribute attribute, @NotNull AttributeModifier modifier, @NotNull TriConsumer<Attribute, AttributeModifier, InteractiveGUI> guiModifier) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Intrinsics.checkNotNullParameter(guiModifier, (String)"guiModifier");
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_EDITOR, this.getEditsForAttribute(attribute, modifier));
        gui.option("type").onNormalClicks(() -> ItemEditor.openAttributeBuilderGUI$lambda-43(this, modifier, guiModifier, attribute)).editItem(arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-44(this, attribute, arg_0)).done();
        gui.option("operation").onNormalClicks(() -> ItemEditor.openAttributeBuilderGUI$lambda-48(this, modifier, attribute, guiModifier)).editItem(arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-49(this, modifier, arg_0)).done();
        gui.option("equipment-slot").onNormalClicks(() -> ItemEditor.openAttributeBuilderGUI$lambda-53(this, modifier, attribute, guiModifier)).editItem(arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-54(this, modifier, arg_0)).done();
        gui.option("uuid").onNormalClicks(ItemEditor::openAttributeBuilderGUI$lambda-55).setConversation((arg_0, arg_1) -> ItemEditor.openAttributeBuilderGUI$lambda-56(this, attribute, modifier, guiModifier, arg_0, arg_1)).done();
        gui.option("name").onNormalClicks(ItemEditor::openAttributeBuilderGUI$lambda-57).setConversation((arg_0, arg_1) -> ItemEditor.openAttributeBuilderGUI$lambda-58(this, attribute, modifier, guiModifier, arg_0, arg_1)).done();
        gui.option("amount").onNormalClicks(ItemEditor::openAttributeBuilderGUI$lambda-59).setConversation((arg_0, arg_1) -> ItemEditor.openAttributeBuilderGUI$lambda-60(this, attribute, modifier, guiModifier, arg_0, arg_1)).done();
        guiModifier.accept(attribute, modifier, gui);
        Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
        return this.finalize(gui);
    }

    @NotNull
    public final InteractiveGUI openAttributeTypesGUI(@NotNull Consumer<Attribute> selected, @NotNull Consumer<InteractiveGUI> guiModifier) {
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        Intrinsics.checkNotNullParameter(guiModifier, (String)"guiModifier");
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_TYPES);
        Intrinsics.checkNotNullExpressionValue((Object)EnumCache.ATTRIBUTES, (String)"ATTRIBUTES");
        for (Attribute attr : EnumCache.ATTRIBUTES) {
            String string = StringUtils.configOption((Enum)attr);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(attr)");
            gui.option(string).onNormalClicks(() -> ItemEditor.openAttributeTypesGUI$lambda-61(selected, attr)).done();
        }
        guiModifier.accept(gui);
        Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
        return this.finalize(gui);
    }

    @NotNull
    public final InteractiveGUI openEquipmentSlotSelector(@Nullable EquipmentSlot currentValue, @NotNull Consumer<EquipmentSlot> selected, @NotNull Consumer<InteractiveGUI> guiModifier) {
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        Intrinsics.checkNotNullParameter(guiModifier, (String)"guiModifier");
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_EQUIPMENT$SLOTS);
        Intrinsics.checkNotNullExpressionValue((Object)EnumCache.EQUIPMENT_SLOTS, (String)"EQUIPMENT_SLOTS");
        for (EquipmentSlot equipSlot : EnumCache.EQUIPMENT_SLOTS) {
            String string = StringUtils.configOption((Enum)equipSlot);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(equipSlot)");
            Object[] objectArray = new Object[]{"enabled", currentValue == equipSlot};
            gui.option(string).setEdits(objectArray).onNormalClicks(() -> ItemEditor.openEquipmentSlotSelector$lambda-62(selected, equipSlot)).done();
        }
        Object[] objectArray = new Object[]{"enabled", currentValue == null};
        gui.option("none").setEdits(objectArray).onNormalClicks(() -> ItemEditor.openEquipmentSlotSelector$lambda-63(selected)).done();
        guiModifier.accept(gui);
        Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
        return this.finalize(gui);
    }

    @NotNull
    public final InteractiveGUI openAttributeOperationsGUI(@NotNull AttributeModifier.Operation currentValue, @NotNull Consumer<AttributeModifier.Operation> selected, @NotNull Consumer<InteractiveGUI> guiModifier) {
        Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        Intrinsics.checkNotNullParameter(guiModifier, (String)"guiModifier");
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_OPERATIONS);
        for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
            String string = StringUtils.configOption((Enum)operation);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(operation)");
            Object[] objectArray = new Object[]{"enabled", currentValue == operation};
            gui.option(string).setEdits(objectArray).onNormalClicks(() -> ItemEditor.openAttributeOperationsGUI$lambda-64(selected, operation)).done();
        }
        guiModifier.accept(gui);
        Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
        return this.finalize(gui);
    }

    public final void openFlagsGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_FLAGS, this.getEditsForItem());
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        for (String option : gui.getRemainingOptions("flag")) {
            String string = option.substring("slot-".length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            com.google.common.base.Optional flagOpt = Enums.getIfPresent(ItemFlag.class, (String)StringsKt.replace$default((String)string2, (char)'-', (char)'_', (boolean)false, (int)4, null));
            if (flagOpt.isPresent()) {
                ItemFlag flag = (ItemFlag)flagOpt.get();
                Object[] objectArray = new Object[]{"supported", true, "enabled", meta.hasItemFlag(flag)};
                gui.option(option).setEdits(objectArray).onNormalClicks(() -> ItemEditor.openFlagsGUI$lambda-65(meta, flag, this)).done();
                continue;
            }
            Object[] objectArray = new Object[]{"supported", false, "enabled", false};
            gui.option(option).setEdits(objectArray).done();
        }
        gui.option("remove-all").onNormalClicks(() -> ItemEditor.openFlagsGUI$lambda-66(meta, this)).done();
        gui.option("back").onNormalClicks(() -> ItemEditor.openFlagsGUI$lambda-67(this)).done();
        Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
        this.finalize(gui);
    }

    public final void openEnchantsGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.ITEM$EDITOR_ENCHANTMENTS, this.getEditsForItem());
        ItemMeta itemMeta = this.item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        Intrinsics.checkNotNullExpressionValue((Object)XEnchantment.VALUES, (String)"VALUES");
        for (XEnchantment xEnchant : XEnchantment.VALUES) {
            Enchantment enchant;
            String string = StringUtils.configOption(xEnchant);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(xEnchant)");
            OptionHandler option = gui.option(string);
            if (!xEnchant.isSupported()) {
                Object[] objectArray = new Object[]{"enabled", false, "supported", false};
                option.setEdits(objectArray).done();
                continue;
            }
            Intrinsics.checkNotNull((Object)xEnchant.getEnchant());
            Object[] objectArray = new Object[]{"enabled", meta.hasEnchant(enchant), "supported", true, "level", meta.getEnchantLevel(enchant)};
            option.setEdits(objectArray).on(ClickType.LEFT, ItemEditor::openEnchantsGUI$lambda-68).setConversation((arg_0, arg_1) -> ItemEditor.openEnchantsGUI$lambda-69(this, meta, enchant, arg_0, arg_1)).on(ClickType.RIGHT, () -> ItemEditor.openEnchantsGUI$lambda-70(meta, enchant, this)).done();
        }
        gui.option("remove-all").onNormalClicks(() -> ItemEditor.openEnchantsGUI$lambda-72(meta, this)).done();
        gui.option("back").onNormalClicks(() -> ItemEditor.openEnchantsGUI$lambda-73(this)).done();
        Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
        this.finalize(gui);
    }

    private final InteractiveGUI finalize(InteractiveGUI gui) {
        gui.onClose(() -> ItemEditor.finalize$lambda-74(gui, this));
        InteractiveGUI.open$default(gui, false, false, 3, null);
        return gui;
    }

    private static final ItemStack openGUI$lambda-4(ItemEditor this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.item;
    }

    private static final void openGUI$lambda-5(OptionHandler ctx) {
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_NAME_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda-6(ItemMeta $meta, ItemEditor this$0, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $meta.setDisplayName(input);
        this$0.item.setItemMeta($meta);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final void openGUI$lambda-7(OptionHandler ctx) {
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_LORE_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda-8(ItemMeta $meta, ItemEditor this$0, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
        String[] stringArray = new String[]{"\\n"};
        $meta.setLore(CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
        this$0.item.setItemMeta($meta);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final ItemStack openGUI$lambda-10(ItemMeta $meta, ItemStack optionItem) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
            ItemMeta itemMeta = optionItem.getItemMeta();
            if (itemMeta == null) break block0;
            ItemMeta optionMeta = itemMeta;
            boolean bl = false;
            optionMeta.setLore($meta.getLore());
            optionItem.setItemMeta(optionMeta);
        }
        return optionItem;
    }

    private static final void openGUI$lambda-11(OptionHandler ctx) {
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_MATERIAL_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda-12(ItemEditor this$0, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Optional<XMaterial> optional = XMaterial.matchXMaterial(input);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"matchXMaterial(input)");
        Optional<XMaterial> material = optional;
        if (!material.isPresent()) {
            ctx.getSettings().raw("material", input);
            ctx.sendError(KingdomsLang.INVALID_MATERIAL, new Object[0]);
            return;
        }
        material.get().setType(this$0.item);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final ItemStack openGUI$lambda-13(ItemEditor this$0, ItemStack optionItem) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        optionItem.setType(this$0.item.getType());
        return optionItem;
    }

    private static final void openGUI$lambda-14(OptionHandler ctx) {
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_AMOUNT_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda-15(ItemEditor this$0, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Integer n = StringUtils.parseInt(this$0.player, input);
        if (n == null) {
            return;
        }
        int amount = n;
        if (amount <= 0) {
            ctx.sendError(KingdomsLang.INVALID_NUMBER_NEGATIVE, new Object[0]);
            return;
        }
        if (amount > 127) {
            ctx.sendError(KingdomsLang.ITEM_EDITOR_AMOUNT_WARNING, new Object[0]);
        }
        this$0.item.setAmount(amount);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final void openGUI$lambda-16(OptionHandler ctx) {
        if (!XMaterial.supports(14)) {
            ctx.sendError(KingdomsLang.ITEM_EDITOR_CUSTOM_MODEL_DATA_NOT_SUPPORTED, new Object[0]);
            return;
        }
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_CUSTOM_MODEL_DATA_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openGUI$lambda-17(ItemEditor this$0, ItemMeta $meta, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Integer n = StringUtils.parseInt(this$0.player, input);
        if (n == null) {
            return;
        }
        int amount = n;
        $meta.setCustomModelData(Integer.valueOf(amount));
        this$0.item.setItemMeta($meta);
        ctx.endConversation();
        this$0.openGUI();
    }

    private static final void openGUI$lambda-18(ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openEnchantsGUI();
    }

    private static final ItemStack openGUI$lambda-19(ItemMeta $meta, ItemStack innerItem) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        ItemMeta itemMeta = innerItem.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta innerMeta = itemMeta;
        if (innerMeta.hasLore()) {
            List list3 = innerMeta.getLore();
            list2 = list3;
            Intrinsics.checkNotNull((Object)list3);
        } else {
            list2 = new ArrayList();
        }
        List lore = list2;
        Map map = $meta.getEnchants();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"meta.enchants");
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            String string = MessageCompiler.compile("&7\u26ab {$p}" + (Object)((Object)XEnchantment.matchXEnchantment(enchant)) + "{$sep}: {$s}" + level, new MessageCompilerSettings().colorize().translatePlaceholders()).buildPlain(new MessageBuilder());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compile(\n               \u2026ldPlain(MessageBuilder())");
            lore.add(string);
        }
        innerMeta.setLore(lore);
        innerItem.setItemMeta(innerMeta);
        return innerItem;
    }

    private static final void openGUI$lambda-20(ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openAttributeGUI();
    }

    private static final void openGUI$lambda-21(ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openFlagsGUI();
    }

    private static final void openGUI$lambda-24$lambda-23$lambda-22(ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openGUI();
    }

    private static final void openGUI$lambda-24$lambda-23(ItemEditor this$0, InteractiveGUI innerGUI) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
        innerGUI.push("back", () -> ItemEditor.openGUI$lambda-24$lambda-23$lambda-22(this$0), new Object[0]);
    }

    private static final void openGUI$lambda-24(ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        NBTWrappers.NBTTagCompound nBTTagCompound = this$0.rootNBT;
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"rootNBT");
        boolean $i$f$emptyArray = false;
        this$0.new NBTEditor(nBTTagCompound, (String[])((Object[])new String[0]), arg_0 -> ItemEditor.openGUI$lambda-24$lambda-23(this$0, arg_0)).openNBTViewerGUI();
    }

    /*
     * WARNING - void declaration
     */
    private static final ItemStack openGUI$lambda-26(ItemEditor this$0, ItemStack innerItem) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ItemMeta itemMeta = innerItem.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta innerMeta = itemMeta;
        if (innerMeta.hasLore()) {
            List list3 = innerMeta.getLore();
            list2 = list3;
            Intrinsics.checkNotNull((Object)list3);
        } else {
            list2 = new ArrayList();
        }
        List lore = list2;
        List builtPaths = new ArrayList();
        NBTWrappers.NBTTagCompound nBTTagCompound = this$0.rootNBT;
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"rootNBT");
        this$0.buildPathsFrom(builtPaths, nBTTagCompound, "");
        Iterable iterable = new StringPathBuilder(builtPaths).toStringTree(CommandAdminLanguagePack.Companion.getTREE_STYLE()).print().getLines();
        List list4 = lore;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void x;
            StringBuilder stringBuilder = (StringBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = x.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"x.toString()");
            collection.add(string);
        }
        list4.addAll((List)destination$iv$iv);
        innerMeta.setLore(lore);
        innerItem.setItemMeta(innerMeta);
        return innerItem;
    }

    private static final void openGUI$lambda-27(ItemMeta $meta, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $meta.setUnbreakable(!$meta.isUnbreakable());
        this$0.item.setItemMeta($meta);
        this$0.openGUI();
    }

    private static final void openGUI$lambda-28(InventoryInteractiveGUI $gui, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$gui, (String)"$gui");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($gui.wasSwitched()) {
            return;
        }
        int[] nArray = $gui.option("item").constructGUIOptionObject().getSettings().getSlots();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"gui.option(\"item\").const\u2026onObject().settings.slots");
        int slot = ArraysKt.first((int[])nArray);
        ItemStack itemInSlot = $gui.getInventory().getItem(slot);
        if (itemInSlot != null) {
            ItemStack[] itemStackArray = new ItemStack[]{itemInSlot};
            XItemStack.giveOrDrop(this$0.player, itemStackArray);
        }
    }

    private static final void openAttributeGUI$lambda-31$lambda-30$lambda-29(ItemMeta $meta, Attribute $attr, AttributeModifier $modifier, Attribute $newAttr, AttributeModifier $mod, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)$attr, (String)"$attr");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $meta.removeAttributeModifier($attr, $modifier);
        $meta.addAttributeModifier($newAttr, $mod);
        this$0.item.setItemMeta($meta);
        this$0.openAttributeGUI();
    }

    private static final void openAttributeGUI$lambda-31$lambda-30(ItemMeta $meta, Attribute $attr, AttributeModifier $modifier, ItemEditor this$0, Attribute newAttr, AttributeModifier mod, InteractiveGUI gui) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)$attr, (String)"$attr");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        gui.push("back", () -> ItemEditor.openAttributeGUI$lambda-31$lambda-30$lambda-29($meta, $attr, $modifier, newAttr, mod, this$0), new Object[0]);
    }

    private static final void openAttributeGUI$lambda-31(ItemMeta $meta, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Attribute attr = Attribute.GENERIC_ATTACK_DAMAGE;
        AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), "attribute", 1.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
        $meta.addAttributeModifier(attr, modifier);
        this$0.item.setItemMeta($meta);
        this$0.openAttributeBuilderGUI(attr, modifier, (arg_0, arg_1, arg_2) -> ItemEditor.openAttributeGUI$lambda-31$lambda-30($meta, attr, modifier, this$0, arg_0, arg_1, arg_2));
    }

    private static final void openAttributeGUI$lambda-32(ItemMeta $meta, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $meta.setAttributeModifiers(null);
        this$0.item.setItemMeta($meta);
        this$0.openAttributeGUI();
    }

    private static final void openAttributeGUI$lambda-38$lambda-35$lambda-34$lambda-33(ItemMeta $meta, Attribute $attribute, AttributeModifier $modifier, Attribute $newAttr, AttributeModifier $newMod, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $meta.removeAttributeModifier($attribute, $modifier);
        $meta.addAttributeModifier($newAttr, $newMod);
        this$0.item.setItemMeta($meta);
        this$0.openAttributeGUI();
    }

    private static final void openAttributeGUI$lambda-38$lambda-35$lambda-34(ItemMeta $meta, Attribute $attribute, AttributeModifier $modifier, ItemEditor this$0, Attribute newAttr, AttributeModifier newMod, InteractiveGUI gui) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        gui.push("back", () -> ItemEditor.openAttributeGUI$lambda-38$lambda-35$lambda-34$lambda-33($meta, $attribute, $modifier, newAttr, newMod, this$0), new Object[0]);
    }

    private static final void openAttributeGUI$lambda-38$lambda-35(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, ItemMeta $meta) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullExpressionValue((Object)$attribute, (String)"attribute");
        Intrinsics.checkNotNullExpressionValue((Object)$modifier, (String)"modifier");
        this$0.openAttributeBuilderGUI($attribute, $modifier, (arg_0, arg_1, arg_2) -> ItemEditor.openAttributeGUI$lambda-38$lambda-35$lambda-34($meta, $attribute, $modifier, this$0, arg_0, arg_1, arg_2));
    }

    private static final void openAttributeGUI$lambda-38$lambda-36(ItemMeta $meta, Attribute $attribute, AttributeModifier $modifier, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $meta.removeAttributeModifier($attribute, $modifier);
        this$0.item.setItemMeta($meta);
        this$0.openAttributeGUI();
    }

    private static final ItemStack openAttributeGUI$lambda-38$lambda-37(ItemEditor this$0, Attribute $attribute, ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Player player = this$0.player;
        String string = StringUtils.configOption((Enum)$attribute);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(attribute)");
        item.setType(this$0.getItemFromGUI(KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_TYPES, player, string).getType());
        return item;
    }

    private static final void openAttributeGUI$lambda-39(ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openGUI();
    }

    private static final void openAttributeBuilderGUI$lambda-43$lambda-40(ItemEditor this$0, AttributeModifier $modifier, TriConsumer $guiModifier, Attribute type) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this$0.openAttributeBuilderGUI(type, $modifier, $guiModifier);
    }

    private static final void openAttributeBuilderGUI$lambda-43$lambda-42$lambda-41(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        this$0.openAttributeBuilderGUI($attribute, $modifier, $guiModifier);
    }

    private static final void openAttributeBuilderGUI$lambda-43$lambda-42(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier, InteractiveGUI innerGUI) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
        innerGUI.push("back", () -> ItemEditor.openAttributeBuilderGUI$lambda-43$lambda-42$lambda-41(this$0, $attribute, $modifier, $guiModifier), new Object[0]);
    }

    private static final void openAttributeBuilderGUI$lambda-43(ItemEditor this$0, AttributeModifier $modifier, TriConsumer $guiModifier, Attribute $attribute) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        this$0.openAttributeTypesGUI(arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-43$lambda-40(this$0, $modifier, $guiModifier, arg_0), arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-43$lambda-42(this$0, $attribute, $modifier, $guiModifier, arg_0));
    }

    private static final ItemStack openAttributeBuilderGUI$lambda-44(ItemEditor this$0, Attribute $attribute, ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
        Player player = this$0.player;
        String string = StringUtils.configOption((Enum)$attribute);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(attribute)");
        return this$0.inheritLoreAndType(item, this$0.getItemFromGUI(KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_TYPES, player, string));
    }

    private static final void openAttributeBuilderGUI$lambda-48$lambda-45(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier, AttributeModifier.Operation operation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        this$0.openAttributeBuilderGUI($attribute, new AttributeModifier($modifier.getUniqueId(), $modifier.getName(), $modifier.getAmount(), operation, $modifier.getSlot()), $guiModifier);
    }

    private static final void openAttributeBuilderGUI$lambda-48$lambda-47$lambda-46(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        this$0.openAttributeBuilderGUI($attribute, $modifier, $guiModifier);
    }

    private static final void openAttributeBuilderGUI$lambda-48$lambda-47(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier, InteractiveGUI innerGUI) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
        innerGUI.push("back", () -> ItemEditor.openAttributeBuilderGUI$lambda-48$lambda-47$lambda-46(this$0, $attribute, $modifier, $guiModifier), new Object[0]);
    }

    private static final void openAttributeBuilderGUI$lambda-48(ItemEditor this$0, AttributeModifier $modifier, Attribute $attribute, TriConsumer $guiModifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        AttributeModifier.Operation operation = $modifier.getOperation();
        Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"modifier.operation");
        this$0.openAttributeOperationsGUI(operation, arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-48$lambda-45(this$0, $attribute, $modifier, $guiModifier, arg_0), arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-48$lambda-47(this$0, $attribute, $modifier, $guiModifier, arg_0));
    }

    private static final ItemStack openAttributeBuilderGUI$lambda-49(ItemEditor this$0, AttributeModifier $modifier, ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
        Player player = this$0.player;
        String string = StringUtils.configOption((Enum)$modifier.getOperation());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(modifier.operation)");
        return this$0.inheritLoreAndType(item, this$0.getItemFromGUI(KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_OPERATIONS, player, string));
    }

    private static final void openAttributeBuilderGUI$lambda-53$lambda-50(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier, EquipmentSlot slot) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        this$0.openAttributeBuilderGUI($attribute, new AttributeModifier($modifier.getUniqueId(), $modifier.getName(), $modifier.getAmount(), $modifier.getOperation(), slot), $guiModifier);
    }

    private static final void openAttributeBuilderGUI$lambda-53$lambda-52$lambda-51(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        this$0.openAttributeBuilderGUI($attribute, $modifier, $guiModifier);
    }

    private static final void openAttributeBuilderGUI$lambda-53$lambda-52(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier, InteractiveGUI innerGUI) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
        innerGUI.push("back", () -> ItemEditor.openAttributeBuilderGUI$lambda-53$lambda-52$lambda-51(this$0, $attribute, $modifier, $guiModifier), new Object[0]);
    }

    private static final void openAttributeBuilderGUI$lambda-53(ItemEditor this$0, AttributeModifier $modifier, Attribute $attribute, TriConsumer $guiModifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        this$0.openEquipmentSlotSelector($modifier.getSlot(), arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-53$lambda-50(this$0, $attribute, $modifier, $guiModifier, arg_0), arg_0 -> ItemEditor.openAttributeBuilderGUI$lambda-53$lambda-52(this$0, $attribute, $modifier, $guiModifier, arg_0));
    }

    private static final ItemStack openAttributeBuilderGUI$lambda-54(ItemEditor this$0, AttributeModifier $modifier, ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
        Player player = this$0.player;
        Object object = $modifier.getSlot();
        if (object == null || (object = object.name()) == null) {
            object = "none";
        }
        String string = StringUtils.configOption((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configOption(modifier.slot?.name ?: \"none\")");
        return this$0.inheritLoreAndType(item, this$0.getItemFromGUI(KingdomsGUI.ITEM$EDITOR_ATTRIBUTES_EQUIPMENT$SLOTS, player, string));
    }

    private static final void openAttributeBuilderGUI$lambda-55(OptionHandler ctx) {
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_ATTRIBUTES_UUID_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openAttributeBuilderGUI$lambda-56(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        UUID id = null;
        try {
            UUID uUID = UUID.fromString(input);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(input)");
            id = uUID;
        }
        catch (IllegalArgumentException ex) {
            ctx.sendError(KingdomsLang.INVALID_UUID, new Object[0]);
            return;
        }
        ctx.endConversation();
        this$0.openAttributeBuilderGUI($attribute, new AttributeModifier(id, $modifier.getName(), $modifier.getAmount(), $modifier.getOperation(), $modifier.getSlot()), $guiModifier);
    }

    private static final void openAttributeBuilderGUI$lambda-57(OptionHandler ctx) {
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_ATTRIBUTES_NAME_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openAttributeBuilderGUI$lambda-58(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        ctx.endConversation();
        this$0.openAttributeBuilderGUI($attribute, new AttributeModifier($modifier.getUniqueId(), input, $modifier.getAmount(), $modifier.getOperation(), $modifier.getSlot()), $guiModifier);
    }

    private static final void openAttributeBuilderGUI$lambda-59(OptionHandler ctx) {
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_ATTRIBUTES_AMOUNT_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openAttributeBuilderGUI$lambda-60(ItemEditor this$0, Attribute $attribute, AttributeModifier $modifier, TriConsumer $guiModifier, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifier, (String)"$modifier");
        Intrinsics.checkNotNullParameter((Object)$guiModifier, (String)"$guiModifier");
        Double d = StringUtils.parseDouble(this$0.player, input);
        if (d == null) {
            return;
        }
        double amount = d;
        ctx.endConversation();
        this$0.openAttributeBuilderGUI($attribute, new AttributeModifier($modifier.getUniqueId(), $modifier.getName(), amount, $modifier.getOperation(), $modifier.getSlot()), $guiModifier);
    }

    private static final void openAttributeTypesGUI$lambda-61(Consumer $selected, Attribute $attr) {
        Intrinsics.checkNotNullParameter((Object)$selected, (String)"$selected");
        $selected.accept($attr);
    }

    private static final void openEquipmentSlotSelector$lambda-62(Consumer $selected, EquipmentSlot $equipSlot) {
        Intrinsics.checkNotNullParameter((Object)$selected, (String)"$selected");
        $selected.accept($equipSlot);
    }

    private static final void openEquipmentSlotSelector$lambda-63(Consumer $selected) {
        Intrinsics.checkNotNullParameter((Object)$selected, (String)"$selected");
        $selected.accept(null);
    }

    private static final void openAttributeOperationsGUI$lambda-64(Consumer $selected, AttributeModifier.Operation $operation) {
        Intrinsics.checkNotNullParameter((Object)$selected, (String)"$selected");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        $selected.accept($operation);
    }

    private static final void openFlagsGUI$lambda-65(ItemMeta $meta, ItemFlag $flag, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($meta.hasItemFlag($flag)) {
            ItemFlag[] itemFlagArray = new ItemFlag[]{$flag};
            $meta.removeItemFlags(itemFlagArray);
        } else {
            ItemFlag[] itemFlagArray = new ItemFlag[]{$flag};
            $meta.addItemFlags(itemFlagArray);
        }
        this$0.item.setItemMeta($meta);
        this$0.openFlagsGUI();
    }

    private static final void openFlagsGUI$lambda-66(ItemMeta $meta, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ItemFlag[] itemFlagArray = XItemStack.ITEM_FLAGS;
        $meta.removeItemFlags(Arrays.copyOf(itemFlagArray, itemFlagArray.length));
        this$0.item.setItemMeta($meta);
        this$0.openFlagsGUI();
    }

    private static final void openFlagsGUI$lambda-67(ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openGUI();
    }

    private static final void openEnchantsGUI$lambda-68(OptionHandler ctx) {
        ctx.sendMessage(KingdomsLang.ITEM_EDITOR_ENCHANT_ENTER, new Object[0]);
        ctx.startConversation();
    }

    private static final void openEnchantsGUI$lambda-69(ItemEditor this$0, ItemMeta $meta, Enchantment $enchant, OptionHandler ctx, String input) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)$enchant, (String)"$enchant");
        Integer n = StringUtils.parseInt(this$0.player, input);
        if (n == null) {
            return;
        }
        int level = n;
        $meta.addEnchant($enchant, level, true);
        this$0.item.setItemMeta($meta);
        ctx.endConversation();
        this$0.openEnchantsGUI();
    }

    private static final void openEnchantsGUI$lambda-70(ItemMeta $meta, Enchantment $enchant, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)$enchant, (String)"$enchant");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($meta.hasEnchant($enchant)) {
            $meta.removeEnchant($enchant);
            this$0.item.setItemMeta($meta);
            this$0.openEnchantsGUI();
        }
    }

    private static final void openEnchantsGUI$lambda-72(ItemMeta $meta, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$meta, (String)"$meta");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $meta.getEnchants().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Enchantment enchantment = (Enchantment)element$iv;
            boolean bl = false;
            $meta.removeEnchant(enchantment);
        }
        this$0.item.setItemMeta($meta);
        this$0.openEnchantsGUI();
    }

    private static final void openEnchantsGUI$lambda-73(ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openGUI();
    }

    private static final void finalize$lambda-74(InteractiveGUI $gui, ItemEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$gui, (String)"$gui");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($gui.wasSwitched()) {
            return;
        }
        ItemStack[] itemStackArray = new ItemStack[]{this$0.item};
        XItemStack.giveOrDrop(this$0.player, itemStackArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\tR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/commands/admin/item/ItemEditor$NBTEditor;", "", "nbt", "Lorg/kingdoms/utils/nbt/NBTWrappers$NBTTagCompound;", "path", "", "", "handler", "Ljava/util/function/Consumer;", "Lorg/kingdoms/gui/InteractiveGUI;", "(Lorg/kingdoms/commands/admin/item/ItemEditor;Lorg/kingdoms/utils/nbt/NBTWrappers$NBTTagCompound;[Ljava/lang/String;Ljava/util/function/Consumer;)V", "getHandler", "()Ljava/util/function/Consumer;", "getNbt", "()Lorg/kingdoms/utils/nbt/NBTWrappers$NBTTagCompound;", "getPath", "()[Ljava/lang/String;", "[Ljava/lang/String;", "openNBTAdder", "openNBTViewerGUI", "core"})
    public final class NBTEditor {
        @NotNull
        private final NBTWrappers.NBTTagCompound nbt;
        @NotNull
        private final String[] path;
        @NotNull
        private final Consumer<InteractiveGUI> handler;

        public NBTEditor(@NotNull NBTWrappers.NBTTagCompound nbt, @NotNull String[] path, Consumer<InteractiveGUI> handler) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.nbt = nbt;
            this.path = path;
            this.handler = handler;
        }

        @NotNull
        public final NBTWrappers.NBTTagCompound getNbt() {
            return this.nbt;
        }

        @NotNull
        public final String[] getPath() {
            return this.path;
        }

        @NotNull
        public final Consumer<InteractiveGUI> getHandler() {
            return this.handler;
        }

        @NotNull
        public final InteractiveGUI openNBTAdder() {
            InteractiveGUI gui = GUIAccessor.prepare(ItemEditor.this.player, KingdomsGUI.ITEM$EDITOR_NBT$TYPES);
            for (Pair<String, OptionHandler> pair : gui.getRemainingOptionsOf("nbt")) {
                String key = (String)((Map.Entry)pair).getKey();
                OptionHandler opt = (OptionHandler)((Map.Entry)pair).getValue();
                AtomicReference newName = new AtomicReference();
                opt.onNormalClicks(NBTEditor::openNBTAdder$lambda-0).setConversation((arg_0, arg_1) -> NBTEditor.openNBTAdder$lambda-3(key, newName, ItemEditor.this, this, arg_0, arg_1)).done();
            }
            Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
            InteractiveGUI.open$default(gui, false, false, 3, null);
            return gui;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final InteractiveGUI openNBTViewerGUI() {
            InteractiveGUI gui = GUIAccessor.prepare(ItemEditor.this.player, KingdomsGUI.ITEM$EDITOR_NBT);
            gui.getSettings().parse("path", "{$s}" + ArraysKt.joinToString$default((Object[])this.path, (CharSequence)" {$sep}\u27a1 {$s}", null, null, (int)0, null, null, (int)62, null));
            ReusableOptionHandler reusableOptionHandler = gui.getReusableOption("tag");
            Intrinsics.checkNotNull((Object)reusableOptionHandler);
            ReusableOptionHandler tag = reusableOptionHandler;
            Object t = this.nbt.getValue();
            Intrinsics.checkNotNullExpressionValue(t, (String)"nbt.value");
            for (Map.Entry entry : ((Map)t).entrySet()) {
                List list2;
                Collection collection;
                String key = (String)entry.getKey();
                NBTWrappers.NBTBase value = (NBTWrappers.NBTBase)entry.getValue();
                gui.getSettings().raw("key", key);
                MessageBuilder messageBuilder = gui.getSettings();
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                messageBuilder.raw("tag", ItemEditor.this.getTypeOfNBT(value));
                NBTWrappers.NBTBase nBTBase = value;
                if (nBTBase instanceof NBTWrappers.NBTTagCompound) {
                    void $this$mapTo$iv$iv;
                    ArrayList builtPaths = new ArrayList();
                    ItemEditor.this.buildPathsFrom(builtPaths, (NBTWrappers.NBTTagCompound)value, "");
                    Iterable $this$map$iv = new StringPathBuilder(builtPaths).toStringTree(CommandAdminLanguagePack.Companion.getTREE_STYLE()).print().getLines();
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (NBTWrappers.NBTBase item$iv$iv2 : $this$mapTo$iv$iv) {
                        void x;
                        StringBuilder stringBuilder = (StringBuilder)((Object)item$iv$iv2);
                        collection = destination$iv$iv;
                        boolean bl = false;
                        String string = x.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"x.toString()");
                        collection.add(string);
                    }
                    list2 = (List)destination$iv$iv;
                } else if (nBTBase instanceof NBTWrappers.NBTTagList) {
                    void $this$mapTo$iv$iv;
                    Object t2 = ((NBTWrappers.NBTTagList)value).getValue();
                    Intrinsics.checkNotNullExpressionValue(t2, (String)"value.value");
                    Iterable $this$map$iv = (Iterable)t2;
                    boolean $i$f$map = false;
                    Iterable $i$f$map2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void x;
                        NBTWrappers.NBTBase item$iv$iv2;
                        item$iv$iv2 = (NBTWrappers.NBTBase)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(x.toString());
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = CollectionsKt.listOf((Object)value.getValue().toString());
                }
                List stringValue = list2;
                tag.editItem(arg_0 -> NBTEditor.openNBTViewerGUI$lambda-6(stringValue, arg_0));
                ((ReusableOptionHandler)tag.on(ClickType.LEFT, NBTEditor::openNBTViewerGUI$lambda-7)).setConversation((arg_0, arg_1) -> NBTEditor.openNBTViewerGUI$lambda-8(this, key, ItemEditor.this, value, arg_0, arg_1));
                tag.on(ClickType.RIGHT, arg_0 -> NBTEditor.openNBTViewerGUI$lambda-9(this, key, arg_0));
                if (value instanceof NBTWrappers.NBTTagCompound) {
                    tag.onNormalClicks(() -> NBTEditor.openNBTViewerGUI$lambda-12(ItemEditor.this, value, this, key)).done();
                    continue;
                }
                tag.done();
            }
            gui.option("add-nbt").onNormalClicks(arg_0 -> NBTEditor.openNBTViewerGUI$lambda-13(this, arg_0)).done();
            this.handler.accept(gui);
            Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
            return ItemEditor.this.finalize(gui);
        }

        private static final void openNBTAdder$lambda-0(OptionHandler ctx) {
            ctx.sendMessage(KingdomsLang.ITEM_EDITOR_NBT_NAME_ENTER, new Object[0]);
            ctx.startConversation();
        }

        private static final void openNBTAdder$lambda-3$lambda-2$lambda-1(ItemEditor this$0, NBTEditor this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            this$0.new NBTEditor(this$1.nbt, this$1.path, this$1.handler).openNBTViewerGUI();
        }

        private static final void openNBTAdder$lambda-3$lambda-2(ItemEditor this$0, NBTEditor this$1, InteractiveGUI innerGUI) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
            innerGUI.push("back", () -> NBTEditor.openNBTAdder$lambda-3$lambda-2$lambda-1(this$0, this$1), new Object[0]);
        }

        private static final void openNBTAdder$lambda-3(String $key, AtomicReference $newName, ItemEditor this$0, NBTEditor this$1, OptionHandler ctx, String input) {
            Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            boolean isCompound = Intrinsics.areEqual((Object)$key, (Object)"NBTTagCompound");
            if ($newName.get() == null && !isCompound) {
                ctx.sendMessage(KingdomsLang.ITEM_EDITOR_NBT_VALUE_ENTER, new Object[0]);
                $newName.set(input);
            } else {
                String[] stringArray;
                if (isCompound) {
                    $newName.set(input);
                }
                try {
                    List list2;
                    Intrinsics.checkNotNullExpressionValue((Object)$key, (String)"key");
                    if (isCompound) {
                        list2 = CollectionsKt.emptyList();
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                        stringArray = new String[]{" "};
                        list2 = StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    }
                    stringArray = this$0.constructNBT($key, list2);
                }
                catch (Throwable ex) {
                    ctx.getSettings().raw("error", ex.getMessage());
                    ctx.sendError(KingdomsLang.ITEM_EDITOR_NBT_VALUE_ERROR, new Object[0]);
                    return;
                }
                String[] newNBT = stringArray;
                this$1.nbt.set((String)$newName.get(), (NBTWrappers.NBTBase<?>)newNBT);
                ctx.endConversation();
                ItemStack itemStack = ItemNBT.setTag(this$0.item, this$0.rootNBT);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"setTag(item, rootNBT)");
                this$0.item = itemStack;
                if (newNBT instanceof NBTWrappers.NBTTagCompound) {
                    NBTWrappers.NBTTagCompound nBTTagCompound = (NBTWrappers.NBTTagCompound)newNBT;
                    Object[] objectArray = this$1.path;
                    Object v = $newName.get();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"newName.get()");
                    this$0.new NBTEditor(nBTTagCompound, (String[])ArraysKt.plus((Object[])objectArray, v), arg_0 -> NBTEditor.openNBTAdder$lambda-3$lambda-2(this$0, this$1, arg_0)).openNBTViewerGUI();
                } else {
                    this$1.openNBTViewerGUI();
                }
            }
        }

        private static final ItemStack openNBTViewerGUI$lambda-6(List $stringValue, ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)$stringValue, (String)"$stringValue");
            ItemMeta meta = item.getItemMeta();
            List lore = StringUtils.splitByLength($stringValue, 40);
            if (lore.size() > 20) {
                List list2 = lore;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"lore");
                lore = CollectionsKt.take((Iterable)list2, (int)20);
                lore.add("...");
            }
            ItemMeta itemMeta = meta;
            if (itemMeta != null) {
                itemMeta.setLore(lore);
            }
            item.setItemMeta(meta);
            return item;
        }

        private static final void openNBTViewerGUI$lambda-7(OptionHandler ctx) {
            ctx.sendMessage(KingdomsLang.ITEM_EDITOR_NBT_VALUE_ENTER, new Object[0]);
        }

        private static final void openNBTViewerGUI$lambda-8(NBTEditor this$0, String $key, ItemEditor this$1, NBTWrappers.NBTBase $value, OptionHandler ctx, String input) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            NBTWrappers.NBTTagCompound nBTTagCompound = this$0.nbt;
            String string = Reflection.getOrCreateKotlinClass($value.getClass()).getSimpleName();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
            String[] stringArray = new String[]{" "};
            nBTTagCompound.set($key, this$1.constructNBT(string, StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
            ctx.endConversation();
            this$0.openNBTViewerGUI();
        }

        private static final void openNBTViewerGUI$lambda-9(NBTEditor this$0, String $key, OptionHandler optionHandler) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.nbt.remove($key);
            this$0.openNBTViewerGUI();
        }

        private static final void openNBTViewerGUI$lambda-12$lambda-11$lambda-10(ItemEditor this$0, NBTEditor this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            this$0.new NBTEditor(this$1.nbt, this$1.path, this$1.handler).openNBTViewerGUI();
        }

        private static final void openNBTViewerGUI$lambda-12$lambda-11(ItemEditor this$0, NBTEditor this$1, InteractiveGUI innerGUI) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)innerGUI, (String)"innerGUI");
            innerGUI.push("back", () -> NBTEditor.openNBTViewerGUI$lambda-12$lambda-11$lambda-10(this$0, this$1), new Object[0]);
        }

        private static final void openNBTViewerGUI$lambda-12(ItemEditor this$0, NBTWrappers.NBTBase $value, NBTEditor this$1, String $key) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullExpressionValue((Object)$value, (String)"value");
            NBTWrappers.NBTTagCompound nBTTagCompound = (NBTWrappers.NBTTagCompound)$value;
            Object[] objectArray = this$1.path;
            Intrinsics.checkNotNullExpressionValue((Object)$key, (String)"key");
            this$0.new NBTEditor(nBTTagCompound, (String[])ArraysKt.plus((Object[])objectArray, (Object)$key), arg_0 -> NBTEditor.openNBTViewerGUI$lambda-12$lambda-11(this$0, this$1, arg_0)).openNBTViewerGUI();
        }

        private static final void openNBTViewerGUI$lambda-13(NBTEditor this$0, OptionHandler optionHandler) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.openNBTAdder();
        }
    }
}

