/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.commands.general.claims.CommandClaimAuto;
import org.kingdoms.commands.general.claims.CommandClaimClipboard;
import org.kingdoms.commands.general.claims.CommandClaimConfirm;
import org.kingdoms.commands.general.claims.CommandClaimCorner;
import org.kingdoms.commands.general.claims.CommandClaimFill;
import org.kingdoms.commands.general.claims.CommandClaimLine;
import org.kingdoms.commands.general.claims.CommandClaimList;
import org.kingdoms.commands.general.claims.CommandClaimSquare;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.config.ConfigUtils;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.managers.land.indicator.LandVisualizer;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.string.StringUtils;

public class CommandClaim
extends KingdomsParentCommand {
    private static final Cooldown<Integer> CONFIRMATION = new Cooldown();

    public CommandClaim() {
        super("claim", true);
        if (this.isDisabled()) {
            return;
        }
        new CommandClaimAuto(this);
        new CommandClaimSquare(this);
        new CommandClaimFill(this);
        new CommandClaimLine(this);
        new CommandClaimConfirm(this);
        new CommandClaimClipboard(this);
        new CommandClaimCorner(this);
        new CommandClaimList(this);
    }

    public static SimpleChunkLocation.WorldlessWrapper getChunkCoords(CommandSender sender, String xString, String zString) {
        if (!StringUtils.isNumeric(xString) || !StringUtils.isNumeric(zString)) {
            String invalid = StringUtils.isNumeric(xString) ? zString : xString;
            KingdomsLang.INVALID_NUMBER.sendError(sender, "arg", invalid);
            return null;
        }
        int x = Integer.parseInt(xString);
        int z = Integer.parseInt(zString);
        return new SimpleChunkLocation.WorldlessWrapper(x, z);
    }

    @Override
    public void execute(CommandContext context) {
        Long confirmation;
        ClaimProcessor processor;
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player, KingdomsLang.DISABLED_WORLD)) {
            return;
        }
        if (ConfigUtils.isInDisabledWorld(KingdomsConfig.Claims.DISABLED_WORLDS.getManager(), player, KingdomsLang.COMMAND_CLAIM_DISABLED_WORLD)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return;
        }
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            StandardKingdomPermission.CLAIM.sendDeniedMessage(player);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        Location loc = player.getLocation();
        SimpleChunkLocation chunk = SimpleChunkLocation.of(loc);
        boolean home = true;
        if (context.assertArgs(1)) {
            int maxDistance;
            if (!context.assertArgs(2)) {
                context.sendError(KingdomsLang.COMMAND_CLAIM_CHUNK_USAGE, new Object[0]);
                super.execute(context);
                return;
            }
            if (!context.hasPermission(KingdomsPluginPermission.COMMAND_CLAIM_CHUNK)) {
                KingdomsLang.COMMAND_CLAIM_CHUNK_PERMISSION.sendError((CommandSender)player, new Object[0]);
                return;
            }
            SimpleChunkLocation.WorldlessWrapper coords = CommandClaim.getChunkCoords((CommandSender)player, context.arg(0), context.arg(1));
            if (coords == null) {
                return;
            }
            chunk = coords.inWorld(player.getWorld());
            int distance = (int)chunk.distance(SimpleChunkLocation.of(loc));
            if (distance > (maxDistance = KingdomsConfig.Claims.COORDINATES_CLAIM_MAX_DISTANCE.getManager().getInt())) {
                KingdomsLang.COMMAND_CLAIM_CHUNK_MAX_DISTANCE.sendError((CommandSender)player, "distance", distance, "max", maxDistance);
                return;
            }
            loc = chunk.getCenterLocation();
            home = false;
        }
        if (!(processor = new ClaimProcessor(chunk, kp, kingdom).process()).isSuccessful()) {
            processor.sendIssue(context.getSender());
            return;
        }
        if (processor.hasCosts() && !kp.isAdmin() && (confirmation = KingdomsConfig.Claims.CONFIRMATION.getManager().getTimeMillis(TimeUnit.SECONDS)) != null && confirmation > 0L && !CONFIRMATION.isInCooldown(player.getEntityId())) {
            KingdomsLang.COMMAND_CLAIM_CONFIRMATION.sendMessage((CommandSender)player, processor.getContextHolder());
            CONFIRMATION.add((Integer)player.getEntityId(), confirmation);
            return;
        }
        processor.finalizeRequest();
        if (processor.shouldOverclaim()) {
            chunk.getLand().unclaim(kp, UnclaimLandEvent.Reason.OVERCLAIM, false);
        }
        if (kingdom.claim(chunk, kp, ClaimLandEvent.Reason.CLAIMED).isCancelled()) {
            return;
        }
        CONFIRMATION.stop(player.getEntityId());
        KingdomsLang.COMMAND_CLAIM_SUCCESS.sendMessage((CommandSender)player, "x", chunk.getX(), "z", chunk.getZ());
        if (home && KingdomsConfig.HOME_SET_ON_FIRST_CLAIM.getBoolean() && kingdom.getLandLocations().size() == 1) {
            CommandSetHome.setHome(kingdom, loc, kp);
        }
        new LandVisualizer().forPlayer(player, kp).forLand(chunk.getLand(), chunk.toChunk()).display(true);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            List<String> cmds = TabCompleteManager.getSubCommand(context.getSender(), this, context.getArgs());
            if (context.hasPermission(KingdomsPluginPermission.COMMAND_CLAIM_CHUNK) && cmds.isEmpty() && context.isNumber(0)) {
                cmds.addAll(CommandClaim.tabComplete("&2<x>"));
            }
            return cmds;
        }
        if (context.isAtArg(1)) {
            return CommandClaim.tabComplete("&2<z>");
        }
        return CommandClaim.emptyTab();
    }
}

