/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.HashSet;
import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.managers.land.claiming.ClaimProcessor;

public class CommandClaimConfirm
extends KingdomsCommand {
    public CommandClaimConfirm(KingdomsParentCommand parent) {
        super("confirm", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        ClaimClipboard session = ClaimClipboard.getClipboards().remove(player.getUniqueId());
        if (session == null) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_CONFIRM_EMPTY, new Object[0]);
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = Objects.requireNonNull(kp.getKingdom(), () -> "Player without a kingdom has a clipboard: " + player.getName());
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            StandardKingdomPermission.CLAIM.sendDeniedMessage(player);
            return;
        }
        HashSet<SimpleChunkLocation> finalClaimables = new HashSet<SimpleChunkLocation>();
        for (AbstractClaimProcessor result : session.getClaims().values()) {
            SimpleChunkLocation chunk = result.getChunk();
            if (!result.isSuccessful()) continue;
            ClaimProcessor newResult = (ClaimProcessor)result.recompile();
            if (!newResult.isSuccessful()) {
                newResult.getContextHolder().raw("x", chunk.getX()).raw("z", chunk.getZ()).raw("error", newResult.processIssue());
                KingdomsLang.COMMAND_CLAIM_CONFIRM_FAIL.sendError(context.getSender(), newResult.getContextHolder());
                continue;
            }
            newResult.finalizeRequest();
            finalClaimables.add(chunk);
        }
        if (!finalClaimables.isEmpty()) {
            KingdomsLang.COMMAND_CLAIM_CONFIRM_SUCCESS.sendMessage((CommandSender)player);
            kingdom.claim(finalClaimables, kp, ClaimLandEvent.Reason.CLAIMED, true);
        }
    }
}

