/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.election;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.election.CommandElection;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.daily.ElectionsManager;
import org.kingdoms.utils.MathUtils;

public class CommandElectionVote
extends KingdomsCommand {
    private static final Comparator<KingdomPlayer> CANDIDATE_COMPARATOR = new Comparator<KingdomPlayer>(){

        @Override
        public int compare(KingdomPlayer first, KingdomPlayer second) {
            int firstVotes = ElectionsManager.getCandidate((UUID)first.getId()).votes;
            int secondVotes = ElectionsManager.getCandidate((UUID)second.getId()).votes;
            int sComp = Integer.compare(firstVotes, secondVotes);
            if (sComp != 0) {
                return sComp;
            }
            return first.compareTo(second);
        }
    };

    public CommandElectionVote(KingdomsParentCommand parent) {
        super("vote", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (CommandElection.checkOngoingElection(context)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            context.sendMessage(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> CommandElectionVote.openCandidates(player, 0));
    }

    public static void openCandidates(Player player, int page) {
        InteractiveGUI gui = GUIAccessor.prepare(player, (OfflinePlayer)player, "election-candidates", "page", page + 1);
        ReusableOptionHandler holder = gui.getReusableOption("candidates");
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        List<KingdomPlayer> members = kingdom.getKingdomPlayers();
        members.sort(CANDIDATE_COMPARATOR);
        int eachPage = holder.slotsCount();
        int maxPages = MathUtils.getPageNumbers(members.size(), eachPage);
        gui.getSettings().raw("pages", maxPages);
        gui.push("next-page", () -> {
            if (page + 1 >= maxPages) {
                KingdomsLang.GUIS_PAGES_NEXT_PAGE_NOT_AVAILABLE.sendError((CommandSender)player, "pages", maxPages, "page", page + 1);
                return;
            }
            CommandElectionVote.openCandidates(player, page + 1);
        }, new Object[0]);
        gui.push("previous-page", () -> {
            if (page + 1 >= maxPages) {
                KingdomsLang.GUIS_PAGES_PREVIOUS_PAGE_NOT_AVAILABLE.sendError((CommandSender)player, "pages", maxPages, "page", page + 1);
                return;
            }
            CommandElectionVote.openCandidates(player, page - 1);
        }, new Object[0]);
        for (KingdomPlayer member : (KingdomPlayer[])members.stream().skip((long)page * (long)eachPage).limit(eachPage).toArray(KingdomPlayer[]::new)) {
            OfflinePlayer memberPlayer = member.getOfflinePlayer();
            ElectionsManager.CandidateDetails candidate = ElectionsManager.getCandidate(member.getId());
            holder.setEdits("votes", candidate.votes, "candidates-description", candidate.statement != null ? candidate.statement : KingdomsLang.ELECTIONS_DEFAULT_STATEMENT.parse(memberPlayer, new Object[0])).onNormalClicks(() -> {
                OfflinePlayer previous = ElectionsManager.vote(player, member.getId());
                if (previous == null) {
                    KingdomsLang.COMMAND_ELECTION_VOTE_VOTED.sendMessage((CommandSender)player, "candidate", memberPlayer.getName());
                    player.closeInventory();
                    CommandElectionVote.openCandidates(player, page);
                } else if (previous.getUniqueId().equals(member.getId())) {
                    KingdomsLang.COMMAND_ELECTION_VOTE_ALREADY_VOTED.sendMessage((CommandSender)player, "candidate", memberPlayer.getName());
                } else {
                    KingdomsLang.COMMAND_ELECTION_VOTE_VOTED_AGAIN.sendMessage((CommandSender)player, "candidate", memberPlayer.getName(), "previous-candidate", previous.getName());
                }
            }).pushHead(memberPlayer);
        }
        gui.open();
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(1)) {
            return context.getPlayers(0);
        }
        return CommandElectionVote.emptyTab();
    }
}

