/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.home;

import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;

public class CommandUnsetHome
extends KingdomsCommand {
    public CommandUnsetHome() {
        super("unsethome", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.SET_HOME)) {
            StandardKingdomPermission.SET_HOME.sendDeniedMessage(player);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        Location home = kingdom.getHome();
        if (home == null) {
            KingdomsLang.COMMAND_UNSETHOME_NOT_SET.sendMessage((CommandSender)player);
            return;
        }
        if (kingdom.setHome(null, kp).isCancelled()) {
            return;
        }
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_UNSETHOME_SUCCESS.sendMessage((CommandSender)member, "x", home.getBlockX(), "y", home.getBlockY(), "z", home.getBlockZ());
        }
    }
}

