/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.KingdomInviteEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.time.TimeUtils;

public class CommandInvite
extends KingdomsCommand
implements Listener {
    public CommandInvite() {
        super("invite", true);
    }

    @Override
    public void execute(CommandContext context) {
        KingdomInvite previousInvite;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        final Player inviter = context.senderAsPlayer();
        final OfflinePlayer invited = context.getOfflinePlayer(0);
        if (invited == null) {
            return;
        }
        if (invited.getUniqueId().equals(inviter.getUniqueId())) {
            KingdomsLang.COMMAND_INVITE_SELF.sendError((CommandSender)inviter, new Object[0]);
            return;
        }
        KingdomPlayer inviterKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)inviter);
        if (!inviterKp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendError((CommandSender)inviter, new Object[0]);
            return;
        }
        if (!inviterKp.hasPermission(StandardKingdomPermission.INVITE)) {
            StandardKingdomPermission.INVITE.sendDeniedMessage(inviter);
            return;
        }
        final KingdomPlayer invitedPlayer = KingdomPlayer.getKingdomPlayer(invited);
        if (invitedPlayer.hasKingdom()) {
            if (invitedPlayer.getKingdomId().equals(inviterKp.getKingdomId())) {
                KingdomsLang.COMMAND_INVITE_ALREADY_JOINED.sendMessage((CommandSender)inviter, "invited", invited.getName());
                return;
            }
            if (!KingdomsConfig.INVITATIONS_ALLOW_FROM_OTHER_KINGDOMS.getBoolean()) {
                KingdomsLang.COMMAND_INVITE_ALREADY_IN_KINGDOM.sendMessage((CommandSender)inviter, "invited", invited.getName());
                return;
            }
        }
        if ((previousInvite = invitedPlayer.getInvites().get(inviterKp.getKingdomId())) != null) {
            KingdomsLang.COMMAND_INVITE_ALREADY_INVITED.sendMessage((CommandSender)inviter, "inviter", previousInvite.getKingdomPlayer().getOfflinePlayer().getName());
            return;
        }
        final Kingdom kingdom = inviterKp.getKingdom();
        if (kingdom.isFull()) {
            KingdomsLang.COMMAND_INVITE_MAX_MEMBERS.sendMessage((CommandSender)inviter);
            return;
        }
        Long time = null;
        if (context.assertArgs(2)) {
            time = TimeUtils.parseTime(context.arg(1), TimeUnit.HOURS);
        }
        if (time == null) {
            time = TimeUtils.parseTime(KingdomsConfig.INVITATIONS_EXPIRATION_DEFAULT_EXPIRE.getString(), TimeUnit.HOURS);
        }
        KingdomInviteEvent event = new KingdomInviteEvent(kingdom, invitedPlayer, inviterKp, time);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        time = event.getAcceptTime();
        final KingdomInvite invitation = new KingdomInvite(inviterKp.getId(), time);
        invitedPlayer.getInvites().put(kingdom.getId(), invitation);
        final Object[] edits = new Object[]{"inviter", inviter.getName(), "invited", invited.getName(), "kingdom", kingdom.getName()};
        if (time < TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS)) {
            new BukkitRunnable(){

                public void run() {
                    KingdomInvite currentInvite = invitedPlayer.getInvites().get(kingdom.getId());
                    if (currentInvite == invitation) {
                        if (invited.isOnline()) {
                            KingdomsLang.COMMAND_INVITE_EXPIRED.sendMessage((CommandSender)invited.getPlayer(), edits);
                        }
                        if (inviter.isOnline()) {
                            KingdomsLang.COMMAND_INVITE_EXPIRED_NOTIFY.sendMessage((CommandSender)inviter, edits);
                        }
                    }
                }
            }.runTaskLaterAsynchronously((Plugin)Kingdoms.get(), TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS) * 20L);
        }
        if (KingdomsConfig.INVITATIONS_ANNOUNCE.getBoolean()) {
            for (Player member : kingdom.getOnlineMembers()) {
                KingdomsLang.COMMAND_INVITE_ANNOUNCE.sendMessage((CommandSender)member, edits);
            }
        }
        if (invited.isOnline()) {
            KingdomsLang.COMMAND_INVITE_INVITED.sendMessage((CommandSender)invited.getPlayer(), edits);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender instanceof Player) {
            if (args.length == 1) {
                Player player = (Player)sender;
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                Kingdom kingdom = kp.getKingdom();
                if (kingdom == null) {
                    return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
                }
                return TabCompleteManager.getPlayers(args[0], p -> !kingdom.isMember((OfflinePlayer)p));
            }
            if (args.length == 2) {
                return Collections.singletonList(ChatColor.GREEN + "[expiration]");
            }
        }
        return new ArrayList<String>();
    }
}

