/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.invitations;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIPagination;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.inviterequests.JoinRequests;
import org.kingdoms.utils.time.TimeFormatter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/kingdoms/commands/general/invitations/CommandJoinRequests;", "Lorg/kingdoms/commands/KingdomsCommand;", "()V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
public final class CommandJoinRequests
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CommandJoinRequests() {
        super("joinRequests", true);
    }

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        if (!kp.hasPermission(StandardKingdomPermission.INVITE)) {
            CommandResult commandResult = context.fail(StandardKingdomPermission.INVITE.getDeniedMessage(), new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(StandardKin\u2026ion.INVITE.deniedMessage)");
            return commandResult;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kp, (String)"kp");
        Companion.openGUI(kp, 0);
        return CommandResult.SUCCESS;
    }

    @JvmStatic
    public static final void openGUI(@NotNull KingdomPlayer viewer, int page) {
        Companion.openGUI(viewer, page);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/kingdoms/commands/general/invitations/CommandJoinRequests$Companion;", "", "()V", "openGUI", "", "viewer", "Lorg/kingdoms/constants/player/KingdomPlayer;", "page", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void openGUI(@NotNull KingdomPlayer viewer, int page) {
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            InteractiveGUI gui = GUIAccessor.prepare(viewer.getPlayer(), KingdomsGUI.KINGDOM$JOIN$REQUESTS);
            Kingdom kingdom = viewer.getKingdom();
            Intrinsics.checkNotNull((Object)kingdom);
            Kingdom kingdom2 = kingdom;
            Pair pair = GUIPagination.paginate(gui, (Collection)JoinRequests.Companion.getJoinRequests(kingdom2).entrySet(), "requests", page, arg_0 -> Companion.openGUI$lambda-0(viewer, arg_0));
            Intrinsics.checkNotNullExpressionValue(pair, (String)"paginate(\n              \u2026penGUI(viewer, newPage) }");
            ReusableOptionHandler option = (ReusableOptionHandler)((Map.Entry)pair).getKey();
            Collection requests = (Collection)((Map.Entry)pair).getValue();
            for (Map.Entry joinRequest : requests) {
                OfflinePlayer offlinePlayer;
                KingdomPlayer kp;
                Intrinsics.checkNotNullExpressionValue((Object)KingdomPlayer.getKingdomPlayer((UUID)joinRequest.getKey()), (String)"getKingdomPlayer(joinRequest.key)");
                Player player = kp.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)kp.getOfflinePlayer(), (String)"kp.offlinePlayer");
                Object[] objectArray = new Object[]{"sent_date", TimeFormatter.dateOf(((Number)joinRequest.getValue()).longValue())};
                ((ReusableOptionHandler)option.setEdits(objectArray).on(ClickType.LEFT, arg_0 -> Companion.openGUI$lambda-1(kingdom2, kp, viewer, player, offlinePlayer, page, arg_0))).on(ClickType.RIGHT, arg_0 -> Companion.openGUI$lambda-2(kingdom2, kp, viewer, player, offlinePlayer, page, arg_0)).pushHead(offlinePlayer);
            }
            Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"gui");
            InteractiveGUI.open$default(gui, false, false, 3, null);
        }

        private static final void openGUI$lambda-0(KingdomPlayer $viewer, Integer newPage) {
            Intrinsics.checkNotNullParameter((Object)$viewer, (String)"$viewer");
            Intrinsics.checkNotNullExpressionValue((Object)newPage, (String)"newPage");
            Companion.openGUI($viewer, newPage);
        }

        private static final void openGUI$lambda-1(Kingdom $kingdom, KingdomPlayer $kp, KingdomPlayer $viewer, Player $player, OfflinePlayer $offlinePlayer, int $page, OptionHandler ctx) {
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)$kp, (String)"$kp");
            Intrinsics.checkNotNullParameter((Object)$viewer, (String)"$viewer");
            Intrinsics.checkNotNullParameter((Object)$offlinePlayer, (String)"$offlinePlayer");
            JoinRequests.Companion.processJoinRequest($kingdom, $kp, true, $kp);
            ctx.getSettings().withContext($viewer.getOfflinePlayer());
            if ($player != null) {
                ctx.sendMessage((CommandSender)$player, KingdomsLang.COMMAND_JOINREQUESTS_ACCEPTED_PLAYER, new Object[0]);
            }
            ctx.getSettings().withContext($offlinePlayer);
            ctx.sendMessage(KingdomsLang.COMMAND_JOINREQUESTS_ACCEPTED_SELF, new Object[0]);
            Companion.openGUI($viewer, $page);
        }

        private static final void openGUI$lambda-2(Kingdom $kingdom, KingdomPlayer $kp, KingdomPlayer $viewer, Player $player, OfflinePlayer $offlinePlayer, int $page, OptionHandler ctx) {
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)$kp, (String)"$kp");
            Intrinsics.checkNotNullParameter((Object)$viewer, (String)"$viewer");
            Intrinsics.checkNotNullParameter((Object)$offlinePlayer, (String)"$offlinePlayer");
            JoinRequests.Companion.processJoinRequest($kingdom, $kp, false, $kp);
            ctx.getSettings().withContext($viewer.getOfflinePlayer());
            if ($player != null) {
                ctx.sendMessage((CommandSender)$player, KingdomsLang.COMMAND_JOINREQUESTS_DENIED_PLAYER, new Object[0]);
            }
            ctx.getSettings().withContext($offlinePlayer);
            ctx.sendMessage(KingdomsLang.COMMAND_JOINREQUESTS_DENIED_SELF, new Object[0]);
            Companion.openGUI($viewer, $page);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

