/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.jail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.structures.objects.JailStructure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.structures.JailManager;
import org.kingdoms.utils.KingdomsBukkitExtensions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/commands/general/jail/CommandUnjail;", "Lorg/kingdoms/commands/KingdomsCommand;", "()V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
public final class CommandUnjail
extends KingdomsCommand {
    public CommandUnjail() {
        super("unjail", true);
    }

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = context.getKingdom();
        Intrinsics.checkNotNull((Object)kingdom);
        Kingdom kingdom2 = kingdom;
        if (!kp.hasPermission(StandardKingdomPermission.JAIL)) {
            CommandResult commandResult = context.fail(StandardKingdomPermission.JAIL.getDeniedMessage(), new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(StandardKin\u2026ssion.JAIL.deniedMessage)");
            return commandResult;
        }
        OfflinePlayer offlinePlayer = context.getOfflinePlayer(0);
        if (offlinePlayer == null) {
            return CommandResult.FAILED;
        }
        OfflinePlayer target = offlinePlayer;
        KingdomPlayer targetKp = KingdomsBukkitExtensions.INSTANCE.asKingdomPlayer(target);
        if (!kingdom2.isMember(target)) {
            CommandResult commandResult = context.fail(null, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(null)");
            return commandResult;
        }
        if (targetKp.getJailCell() == null) {
            CommandResult commandResult = context.fail(null, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(null)");
            return commandResult;
        }
        JailStructure jailStructure = JailManager.Companion.getCell(target);
        Intrinsics.checkNotNull((Object)jailStructure);
        JailStructure cell = jailStructure;
        cell.release();
        return CommandResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isPlayer()) {
            Kingdom kingdom = context.getKingdom();
            if (kingdom == null) {
                List<String> list2 = KingdomsCommand.emptyTab();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyTab()");
                return list2;
            }
            Kingdom kingdom2 = kingdom;
            if (context.isAtArg(0)) {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                OfflinePlayer x;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Set<UUID> set = kingdom2.getMembers();
                Intrinsics.checkNotNullExpressionValue(set, (String)"kingdom.members");
                Iterable iterable = set;
                int n = 0;
                CommandTabContext commandTabContext = context;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    UUID uUID = (UUID)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
                    collection.add((String)KingdomsBukkitExtensions.INSTANCE.asOfflinePlayer((UUID)x));
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    x = (OfflinePlayer)element$iv$iv;
                    boolean bl = false;
                    if (!(KingdomsBukkitExtensions.INSTANCE.asKingdomPlayer(x).getJailCell() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
                $this$filter$iv = collection;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    x = (OfflinePlayer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(x.getName());
                }
                collection = (List)destination$iv$iv;
                List<String> list3 = commandTabContext.suggest(n, collection);
                Intrinsics.checkNotNullExpressionValue(list3, (String)"context.suggest(0, kingd\u2026    .map { x -> x.name })");
                return list3;
            }
        }
        List<String> list4 = KingdomsCommand.emptyTab();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"emptyTab()");
        return list4;
    }
}

