/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.home.CommandSetHome;
import org.kingdoms.commands.general.text.CommandRename;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.string.StringUtils;

public class CommandCreate
extends KingdomsCommand {
    private static final Cooldown<Integer> CONFIRMATION_COOLDOWN = new Cooldown();

    public CommandCreate() {
        super("create", true);
    }

    @Override
    public void execute(CommandContext context) {
        Block block;
        boolean claimed;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.hasKingdom()) {
            context.sendError(KingdomsLang.COMMAND_CREATE_ALREADY_IN_KINGDOM, new Object[0]);
            return;
        }
        String name = StringUtils.buildArguments(context.args, KingdomsConfig.KINGDOM_NAME_ALLOW_SPACES.getBoolean() ? " " : "");
        if (CommandRename.forbidden(player, name)) {
            return;
        }
        if (!kp.isAdmin()) {
            double cost;
            if (!CommandRename.checkName(name, player)) {
                return;
            }
            if (ServiceHandler.bankServiceAvailable() && (cost = KingdomsConfig.ECONOMY_COSTS_CREATE_KINGDOM.getDouble()) > 0.0) {
                if (!ServiceVault.hasMoney((OfflinePlayer)player, cost)) {
                    KingdomsLang.COMMAND_CREATE_COST.sendMessage((CommandSender)player, "cost", cost);
                    return;
                }
                if (!CONFIRMATION_COOLDOWN.add((Integer)player.getEntityId(), KingdomsConfig.ECONOMY_CREATE_CONFIRMATION.getTimeMillis())) {
                    KingdomsLang.COMMAND_CREATE_CONFIRMATION.sendMessage((CommandSender)player, "cost", cost);
                    return;
                }
                ServiceVault.withdraw((OfflinePlayer)player, cost);
            }
        }
        Kingdom kingdom = new Kingdom(player.getUniqueId(), name);
        if (KingdomsConfig.ANNOUNCEMENTS_CREATE_KINGDOM.getBoolean()) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_CREATE_ANNOUNCE.sendMessage((CommandSender)online, (OfflinePlayer)player, new Object[]{"kingdom", name});
            }
        } else {
            KingdomsLang.COMMAND_CREATE_SUCCESS.sendMessage((CommandSender)player, "kingdom", name);
        }
        if (KingdomsConfig.TAGS_ATTEMPT_AUTOMATIC_SETTING.getBoolean()) {
            String tagName = StringUtils.findCapitalized(name);
            if (tagName.isEmpty()) {
                tagName = name.substring(0, Math.min(5, name.length()));
            }
            kingdom.setTag(tagName);
        }
        if (KingdomsConfig.Invasions.PACIFISM_ENABLED.getManager().getBoolean() && KingdomsConfig.CREATION_KINGDOMS_SHOW_KINGDOM_TYPE_GUI.getBoolean()) {
            InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.KINGDOM$CREATE);
            if (gui == null) {
                return;
            }
            gui.push("pacifist", () -> {
                kingdom.setPacifist(true);
                KingdomsLang.COMMAND_CREATE_PACIFIST.sendMessage((CommandSender)player);
                player.closeInventory();
            }, new Object[0]).push("aggressor", () -> {
                kingdom.setPacifist(false);
                KingdomsLang.COMMAND_CREATE_AGGRESSOR.sendMessage((CommandSender)player);
                player.closeInventory();
            }, new Object[0]);
            gui.open();
        }
        SimpleChunkLocation chunkLocation = SimpleChunkLocation.of(player.getLocation());
        ClaimProcessor claimProcessor = new ClaimProcessor(chunkLocation, kp, kingdom).process();
        boolean canClaim = claimProcessor.isSuccessful();
        int claims = KingdomsConfig.Claims.CLAIM_ON_CREATE.getManager().getInt();
        boolean bl = claimed = claims >= 0 && canClaim;
        if (claimed) {
            boolean bl2 = claimed = !kingdom.claim(Collections.singleton(chunkLocation), kp, ClaimLandEvent.Reason.INITIAL_KINGDOM_CLAIMS, false).isCancelled();
        }
        if (claimed) {
            claimProcessor.finalizeRequest();
        }
        if (claimed && claims > 0) {
            for (SimpleChunkLocation chunk : chunkLocation.getChunksAround(claims)) {
                if (chunk.equalsIgnoreWorld(chunkLocation)) continue;
                kingdom.claim(Collections.singleton(chunk), kp, ClaimLandEvent.Reason.INITIAL_KINGDOM_CLAIMS, false);
            }
        }
        if (KingdomsConfig.HOME_SET_ON_CREATE.getBoolean()) {
            if (KingdomsConfig.HOME_CLAIMED.getBoolean()) {
                if (claimed) {
                    CommandSetHome.setHome(kingdom, player.getLocation().add(0.0, 1.0, 0.0), kp);
                }
            } else {
                CommandSetHome.setHome(kingdom, player.getLocation().add(0.0, 1.0, 0.0), kp);
            }
        }
        if (claimed && KingdomsConfig.NEXUS_PLACE_ON_CREATE.getBoolean() && chunkLocation.getLand().getStructures().isEmpty() && !LocationUtils.exceedsBuildLimit(player.getLocation()) && (block = LocationUtils.findEmptyBlock(player.getLocation().getBlock())) != null) {
            kingdom.placeOrMoveNexus(block.getLocation(), kp);
        }
        XSound.play(player, KingdomsConfig.CREATION_KINGDOMS_SOUND.getString());
        CONFIRMATION_COOLDOWN.stop(player.getEntityId());
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return Collections.singletonList("<name>");
        }
        return new ArrayList<String>();
    }
}

