/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;

public class CommandDonate
extends KingdomsCommand {
    public CommandDonate() {
        super("donate");
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(2)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return;
        }
        if (!kp.hasPermission(StandardKingdomPermission.WITHDRAW)) {
            StandardKingdomPermission.WITHDRAW.sendDeniedMessage(player);
            return;
        }
        Kingdom to = context.getKingdom(0);
        Integer donate = context.getInt(1);
        if (donate == null) {
            return;
        }
        if (donate <= 0) {
            KingdomsLang.COMMAND_DONATE_INVALID.sendMessage((CommandSender)player, "kingdom", to.getName(), "rp", donate);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom.getResourcePoints() < (long)donate.intValue()) {
            KingdomsLang.COMMAND_DONATE_DONT_HAVE.sendMessage((CommandSender)player, "kingdom", to.getName(), "rp", donate);
            return;
        }
        kingdom.addResourcePoints(-donate.intValue());
        to.addResourcePoints(donate.intValue());
        context.sendMessage(KingdomsLang.COMMAND_DONATE_DONE, "kingdom", to.getName(), "rp", donate);
        for (Player member : to.getOnlineMembers()) {
            KingdomsLang.COMMAND_DONATE_DONATED.sendMessage((CommandSender)member, "kingdom", kingdom.getName(), "rp", donate);
        }
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getKingdoms(args[0]);
        }
        if (args.length == 2) {
            return Collections.singletonList("<amount>");
        }
        return new ArrayList<String>();
    }
}

