/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.utils.internal.integer.IntHashSet;
import org.kingdoms.utils.scoreboards.Glow;
import org.kingdoms.utils.scoreboards.XScoreboard;

public class CommandGlow
extends KingdomsCommand
implements Listener {
    public static final IntHashSet ACTIVATED = new IntHashSet();

    public CommandGlow() {
        super("glow");
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!ACTIVATED.remove(player.getEntityId())) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        for (Player entity : kingdom.getOnlineMembers()) {
            Glow.removeGlow(player);
        }
    }

    @Override
    public void execute(CommandContext context) {
        if (ReflectionUtils.supports(17)) {
            MessageHandler.sendMessage(context.getSender(), "&4This command is currently not supported in 1.17+");
            return;
        }
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        Kingdom kingdom = context.getKingdom();
        if (kingdom == null) {
            context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return;
        }
        if (ACTIVATED.remove(player.getEntityId())) {
            Glow.removeGlow(player);
            context.sendMessage(KingdomsLang.COMMAND_GLOW_DISABLED, new Object[0]);
        } else {
            ACTIVATED.add(player.getEntityId());
            for (Player member : kingdom.getOnlineMembers()) {
                if (member == player) continue;
                Glow.setGlowing(player, XScoreboard.Color.DARK_RED, new Entity[]{member});
            }
            context.sendMessage(KingdomsLang.COMMAND_GLOW_ENABLED, new Object[0]);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
    }
}

