/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.integer.IntHashSet;

public class CommandInventory
extends KingdomsCommand
implements Listener {
    private static final IntHashSet VIEWING = new IntHashSet();

    public CommandInventory() {
        super("inventory");
    }

    public static InteractiveGUI invsee(Player viewer, Player target) {
        int i;
        EntityEquipment armor;
        ItemStack offhandItem;
        InventoryInteractiveGUI gui = (InventoryInteractiveGUI)new GUIBuilder(KingdomsGUI.INVSEE).forPlayer(viewer).withSettings(new MessageBuilder().withContext(target).raw("target", target.getName()).raw("held_slot", target.getInventory().getHeldItemSlot() + 1)).inventoryGUIOnly().build();
        Inventory inventory = gui.getInventory();
        ConfigSection options = gui.getConfig();
        ItemStack mainHand = target.getInventory().getItemInMainHand();
        if (mainHand.getType() != Material.AIR) {
            gui.option("mainhand").editItem(item -> mainHand).done();
        }
        if ((offhandItem = target.getInventory().getItemInOffHand()).getType() != Material.AIR) {
            gui.option("offhand").editItem(item -> offhandItem).done();
        }
        if ((armor = target.getEquipment()).getHelmet() != null) {
            gui.option("helmet").editItem(item -> armor.getHelmet()).done();
        }
        if (armor.getChestplate() != null) {
            gui.option("chestplate").editItem(item -> armor.getChestplate()).done();
        }
        if (armor.getLeggings() != null) {
            gui.option("leggings").editItem(item -> armor.getLeggings()).done();
        }
        if (armor.getBoots() != null) {
            gui.option("boots").editItem(item -> armor.getBoots()).done();
        }
        gui.setRemainingOptions();
        int startSlot = 9 * (options.getInt("context-start-row") - 1);
        ItemStack[] items = target.getInventory().getStorageContents();
        for (i = 9; i < items.length; ++i) {
            inventory.setItem(startSlot++, items[i]);
        }
        for (i = 0; i < 9; ++i) {
            inventory.setItem(startSlot++, items[i]);
        }
        return gui;
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (!context.assertArgs(1)) {
            context.sendError(KingdomsLang.COMMAND_INVENTORY_USAGE, new Object[0]);
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        boolean othersPermission = context.hasPermission(KingdomsPluginPermission.COMMAND_INVENTORY_OTHERS);
        if (kingdom == null && !othersPermission) {
            context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return;
        }
        if (!othersPermission && !kp.hasPermission(StandardKingdomPermission.INVSEE)) {
            context.sendError(KingdomsLang.COMMAND_INVENTORY_PERMISSION, new Object[0]);
            return;
        }
        Player target = context.getPlayer(0);
        if (target == null) {
            return;
        }
        if (!othersPermission && !kingdom.isMember((OfflinePlayer)target)) {
            context.sendError(KingdomsLang.COMMAND_INVENTORY_NOT_IN_KINGDOM, "target", target.getName());
            return;
        }
        VIEWING.add(player.getEntityId());
        CommandInventory.invsee(player, target).open(false, false);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (VIEWING.contains(event.getView().getPlayer().getEntityId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (VIEWING.contains(event.getView().getPlayer().getEntityId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (event.getInventory().getType() != InventoryType.CHEST) {
            return;
        }
        VIEWING.remove(event.getPlayer().getEntityId());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            if (context.hasPermission(KingdomsPluginPermission.COMMAND_INVENTORY_OTHERS)) {
                return context.getPlayers(0);
            }
            KingdomPlayer kp = context.getKingdomPlayer();
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return CommandInventory.tabComplete(KingdomsLang.NO_KINGDOM_DEFAULT.parse(new Object[0]));
            }
            return context.getKingdomPlayers(kingdom, 0);
        }
        return CommandInventory.emptyTab();
    }
}

