/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.locale.KingdomsLang;

public class CommandLeave
extends KingdomsCommand {
    public CommandLeave() {
        super("leave", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (kp.getRank().isKing()) {
            KingdomsLang.COMMAND_LEAVE_KING.sendError((CommandSender)player, new Object[0]);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        kp.leaveKingdom(LeaveReason.LEFT);
        KingdomsLang.COMMAND_LEAVE_SUCCESS.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_LEAVE_ANNOUNCE.sendMessage((CommandSender)member, "left", player.getName());
        }
    }
}

