/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.List;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KingdomsPluginPermission;

public class CommandVault
extends KingdomsCommand {
    public CommandVault() {
        super("vault", true);
    }

    @Override
    public void execute(CommandContext context) {
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertArgs(1)) {
            if (!context.hasPermission(KingdomsPluginPermission.COMMAND_VAULT_OTHERS)) {
                context.sendError(KingdomsLang.COMMAND_VAULT_OTHERS_PERMISSION, new Object[0]);
                return;
            }
            kingdom = context.getKingdom();
            if (kingdom == null) {
                return;
            }
        } else {
            KingdomPlayer kp = context.getKingdomPlayer();
            kingdom = kp.getKingdom();
            if (kingdom == null) {
                context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
                return;
            }
        }
        Player player = context.senderAsPlayer();
        player.openInventory(kingdom.getNexusChest());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0) && context.hasPermission(KingdomsPluginPermission.COMMAND_VAULT_OTHERS, true)) {
            return context.getKingdoms(0);
        }
        return CommandVault.emptyTab();
    }
}

