/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.relation;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.RelationUtil;

public class CommandRevoke
extends KingdomsCommand {
    public CommandRevoke() {
        super("revoke", true);
    }

    static StandardKingdomPermission getPermissionForRelation(KingdomRelation relation) {
        switch (relation) {
            case ALLY: {
                return StandardKingdomPermission.ALLIANCE;
            }
            case TRUCE: {
                return StandardKingdomPermission.TRUCE;
            }
            case ENEMY: {
                return StandardKingdomPermission.ENEMY;
            }
        }
        return null;
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        Kingdom to = context.getKingdom(0);
        if (to == null) {
            return;
        }
        context.getSettings().other(to);
        context.var("kingdom", to.getName());
        if (!RelationUtil.hasAnyRelationManagementPermissions(kp)) {
            return;
        }
        if (kingdom.getId().equals(to.getId())) {
            context.sendError(KingdomsLang.COMMAND_REVOKE_SELF, new Object[0]);
            return;
        }
        KingdomRelation relation = kingdom.getRelationWith(to);
        context.var("relation", relation.getColor() + relation.getName().buildPlain(context.getSettings()));
        if (relation == KingdomRelation.NEUTRAL) {
            context.sendError(KingdomsLang.COMMAND_REVOKE_ALREADY_NEUTRAL, new Object[0]);
            return;
        }
        if (!kp.hasPermission(CommandRevoke.getPermissionForRelation(relation))) {
            context.sendError(KingdomsLang.COMMAND_REVOKE_SPECIFIC_PERMISSION, new Object[0]);
            return;
        }
        if (relation == KingdomRelation.ENEMY) {
            KingdomRelationshipRequest request = kingdom.getRelationshipRequests().remove(to.getId());
            if (request != null) {
                KingdomRelation requestRelation = request.getRelation();
                if (requestRelation != KingdomRelation.NEUTRAL) {
                    KingdomsLang.RELATIONS_ANOTHER_REQUEST.sendError((CommandSender)player, "kingdom", to.getName(), "relation", requestRelation.getColor() + requestRelation.getName().buildPlain(context.getSettings()));
                    return;
                }
                RelationUtil.acceptRequest(player, kingdom, to, KingdomRelation.NEUTRAL, KingdomsLang.COMMAND_REVOKE_NEUTRALS);
                return;
            }
            if (kingdom.sendRelationshipRequest(kp, to, KingdomRelation.NEUTRAL).isCancelled()) {
                return;
            }
            KingdomsLang.COMMAND_REVOKE_REQUEST_SENDER.sendMessage((CommandSender)player, "kingdom", to.getName());
            for (Player member : to.getOnlineMembers()) {
                KingdomsLang.COMMAND_REVOKE_REQUEST_RECEIVER.sendMessage((CommandSender)member, "kingdom", kingdom.getName(), "relation", KingdomRelation.NEUTRAL.getColor() + KingdomRelation.NEUTRAL.getName().buildPlain(context.getSettings()));
            }
        } else {
            RelationUtil.acceptRequest(player, kingdom, to, KingdomRelation.NEUTRAL, KingdomsLang.COMMAND_REVOKE_SENDER, KingdomsLang.COMMAND_REVOKE_RECEIVER);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isPlayer() && context.isAtArg(0)) {
            Kingdom kingdom = context.getKingdom();
            if (kingdom == null) {
                return CommandRevoke.emptyTab();
            }
            return context.suggest(0, (String[])kingdom.getRelations().keySet().stream().map(Kingdom::getKingdom).map(x -> x.getName()).toArray(String[]::new));
        }
        return CommandRevoke.emptyTab();
    }
}

