/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.relation;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.general.relation.CommandEnemy;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.GroupRelationshipChangeEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.RelationUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/commands/general/relation/RelationalCommandProcessor;", "", "()V", "Companion", "core"})
public final class RelationalCommandProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final CommandResult execute(@NotNull KingdomRelation relation, @NotNull CommandContext context, @NotNull Messenger requestLang) {
        return Companion.execute(relation, context, requestLang);
    }

    @JvmStatic
    @NotNull
    public static final List<String> tabComplete(@NotNull KingdomRelation relation, @NotNull CommandTabContext context) {
        return Companion.tabComplete(relation, context);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/commands/general/relation/RelationalCommandProcessor$Companion;", "", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "relation", "Lorg/kingdoms/constants/group/model/relationships/KingdomRelation;", "context", "Lorg/kingdoms/commands/CommandContext;", "requestLang", "Lorg/kingdoms/locale/messenger/Messenger;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CommandResult execute(@NotNull KingdomRelation relation, @NotNull CommandContext context, @NotNull Messenger requestLang) {
            KingdomRelationshipRequest kingdomRelationshipRequest;
            Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)requestLang, (String)"requestLang");
            if (context.assertPlayer()) {
                return CommandResult.FAILED;
            }
            if (context.requireArgs(1)) {
                return CommandResult.FAILED;
            }
            if (context.assertHasKingdom()) {
                return CommandResult.FAILED;
            }
            context.var("relation", relation.getColor() + relation.getName().buildPlain(context.getSettings()));
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = context.getKingdomPlayer();
            Kingdom kingdom = kp.getKingdom();
            Intrinsics.checkNotNull((Object)kingdom);
            Kingdom kingdom2 = kingdom;
            StandardKingdomPermission standardKingdomPermission = relation.getPermission();
            Intrinsics.checkNotNull((Object)standardKingdomPermission);
            if (!kp.hasPermission(standardKingdomPermission)) {
                StandardKingdomPermission standardKingdomPermission2 = relation.getPermission();
                Intrinsics.checkNotNull((Object)standardKingdomPermission2);
                standardKingdomPermission2.sendDeniedMessage(player);
                return CommandResult.FAILED;
            }
            int relations = kingdom2.countRelationships(relation);
            double maxRelations = MathUtils.eval(relation.getLimit(), (PlaceholderContextProvider)context.getSettings());
            context.var("max", maxRelations);
            if (maxRelations > 0.0 && (double)relations >= maxRelations) {
                String[] stringArray = new String[]{"limit"};
                CommandResult commandResult = context.fail(context.lang(stringArray), new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(context.lang(\"limit\"))");
                return commandResult;
            }
            Kingdom kingdom3 = context.getKingdom(0);
            if (kingdom3 == null) {
                return CommandResult.FAILED;
            }
            Kingdom to = kingdom3;
            context.getSettings().other(to);
            if (Intrinsics.areEqual((Object)kingdom2.getId(), (Object)to.getId())) {
                String[] stringArray = new String[]{"self"};
                CommandResult commandResult = context.fail(context.lang(stringArray), new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(context.lang(\"self\"))");
                return commandResult;
            }
            if (kingdom2.getRelationWith(to) == relation) {
                String[] stringArray = new String[]{"already"};
                CommandResult commandResult = context.fail(context.lang(stringArray), new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(context.lang(\"already\"))");
                return commandResult;
            }
            Companion $this$execute_u24lambda_u2d0 = this;
            boolean bl2 = false;
            KingdomRelationshipRequest first = to.getRelationshipRequests().get(kingdom2.getId());
            String[] other = kingdom2.getRelationshipRequests().get(to.getId());
            if (first != null && other != null) {
                kingdom2.getRelationshipRequests().remove(to.getId());
                kingdomRelationshipRequest = to.getRelationshipRequests().remove(kingdom2.getId());
            } else {
                KingdomRelationshipRequest kingdomRelationshipRequest2 = first;
                if ((kingdomRelationshipRequest2 != null ? kingdomRelationshipRequest2.getRelation() : null) == relation) {
                    String[] stringArray = new String[]{"already-requested"};
                    CommandResult commandResult = context.fail(context.lang(stringArray), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(context.lang(\"already-requested\"))");
                    return commandResult;
                }
                kingdomRelationshipRequest = null;
            }
            if (relation != KingdomRelation.ENEMY) {
                KingdomRelationshipRequest request = kingdom2.getRelationshipRequests().get(to.getId());
                if (request != null) {
                    if (request.getRelation() != relation) {
                        CommandResult commandResult = context.fail(KingdomsLang.RELATIONS_ANOTHER_REQUEST, new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLan\u2026ELATIONS_ANOTHER_REQUEST)");
                        return commandResult;
                    }
                    if (RelationUtil.acceptRequest(player, kingdom2, to, relation, requestLang).isCancelled()) {
                        return CommandResult.FAILED;
                    }
                    return CommandResult.SUCCESS;
                }
                if (kingdom2.sendRelationshipRequest(kp, to, relation).isCancelled()) {
                    return CommandResult.FAILED;
                }
                String[] bl2 = new String[]{"sender"};
                Messenger messenger = context.lang(bl2);
                Intrinsics.checkNotNullExpressionValue((Object)messenger, (String)"context.lang(\"sender\")");
                context.sendMessage(messenger, new Object[0]);
                for (Player member : to.getOnlineMembers()) {
                    Intrinsics.checkNotNullExpressionValue((Object)member, (String)"member");
                    CommandSender commandSender = (CommandSender)member;
                    other = new String[]{"receiver"};
                    Messenger messenger2 = context.lang(other);
                    Intrinsics.checkNotNullExpressionValue((Object)messenger2, (String)"context.lang(\"receiver\")");
                    context.sendMessage(commandSender, messenger2, new Object[0]);
                }
            } else {
                Object[] objectArray;
                if (kingdom2.isStrongerThan(to)) {
                    CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ENEMY_HIGHER_STRENGTH, new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLan\u2026ND_ENEMY_HIGHER_STRENGTH)");
                    return commandResult;
                }
                long cost = (long)MathUtils.eval(relation.getCost(), (PlaceholderContextProvider)context.getSettings());
                context.var("cost", cost);
                if (cost != 0L && !kingdom2.hasResourcePoints(cost)) {
                    CommandResult commandResult = context.fail(KingdomsLang.COMMAND_ENEMY_COST, new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLang.COMMAND_ENEMY_COST)");
                    return commandResult;
                }
                GroupRelationshipChangeEvent event = new GroupRelationshipChangeEvent(kp, kingdom2, to, relation);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return CommandResult.FAILED;
                }
                if (cost != 0L) {
                    kingdom2.addResourcePoints(-cost);
                }
                Map<UUID, KingdomRelation> map = kingdom2.getRelations();
                Intrinsics.checkNotNullExpressionValue(map, (String)"kingdom.relations");
                KingdomRelation[] kingdomRelationArray = map;
                kingdomRelationArray.put((UUID)to.getId(), (KingdomRelation)relation);
                Map<UUID, KingdomRelation> map2 = to.getRelations();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"to.relations");
                kingdomRelationArray = map2;
                kingdomRelationArray.put((UUID)kingdom2.getId(), (KingdomRelation)relation);
                kingdom2.getRelationshipRequests().remove(to.getId());
                to.getRelationshipRequests().remove(kingdom2.getId());
                for (Player member : kingdom2.getOnlineMembers()) {
                    objectArray = new Object[]{"kingdom", to.getName()};
                    KingdomsLang.COMMAND_ENEMY_ENEMIES.sendMessage((CommandSender)member, objectArray);
                }
                for (Player member : to.getOnlineMembers()) {
                    objectArray = new Object[]{"kingdom", kingdom2.getName()};
                    KingdomsLang.COMMAND_ENEMY_ENEMIES.sendMessage((CommandSender)member, objectArray);
                }
                kingdomRelationArray = new KingdomRelation[]{KingdomRelation.ALLY};
                kingdom2.getKingdomsWithRelation(kingdomRelationArray).stream().filter(arg_0 -> Companion.execute$lambda-1(to, arg_0)).forEach(arg_0 -> Companion.execute$lambda-2(kingdom2, to, arg_0));
                kingdomRelationArray = new KingdomRelation[]{KingdomRelation.ALLY};
                to.getKingdomsWithRelation(kingdomRelationArray).stream().filter(arg_0 -> Companion.execute$lambda-3(kingdom2, arg_0)).forEach(arg_0 -> Companion.execute$lambda-4(kingdom2, to, arg_0));
            }
            return CommandResult.SUCCESS;
        }

        @JvmStatic
        @NotNull
        public final List<String> tabComplete(@NotNull KingdomRelation relation, @NotNull CommandTabContext context) {
            KingdomPlayer kp;
            Kingdom kingdom;
            Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (context.isPlayer() && (kingdom = (kp = context.getKingdomPlayer()).getKingdom()) != null) {
                List<String> list2 = context.getKingdoms(0, arg_0 -> Companion.tabComplete$lambda-5(kingdom, relation, arg_0));
                Intrinsics.checkNotNullExpressionValue(list2, (String)"context.getKingdoms(0) {\u2026ion\n                    }");
                return list2;
            }
            return CollectionsKt.emptyList();
        }

        private static final boolean execute$lambda-1(Kingdom $to, Kingdom x) {
            Intrinsics.checkNotNullParameter((Object)$to, (String)"$to");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.getRelationWith($to) == KingdomRelation.ALLY;
        }

        private static final void execute$lambda-2(Kingdom $kingdom, Kingdom $to, Kingdom x) {
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)$to, (String)"$to");
            CommandEnemy.notify(x, $kingdom, $to);
        }

        private static final boolean execute$lambda-3(Kingdom $kingdom, Kingdom x) {
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return x.getRelationWith($kingdom) == KingdomRelation.ALLY;
        }

        private static final void execute$lambda-4(Kingdom $kingdom, Kingdom $to, Kingdom x) {
            Intrinsics.checkNotNullParameter((Object)$kingdom, (String)"$kingdom");
            Intrinsics.checkNotNullParameter((Object)$to, (String)"$to");
            CommandEnemy.notify(x, $kingdom, $to);
        }

        private static final boolean tabComplete$lambda-5(Kingdom $kingdom, KingdomRelation $relation, String otherKingdomName) {
            Intrinsics.checkNotNullParameter((Object)((Object)$relation), (String)"$relation");
            String string = otherKingdomName;
            Intrinsics.checkNotNull((Object)string);
            Kingdom otherKingdom = Kingdom.getKingdom(string);
            return !Intrinsics.areEqual((Object)$kingdom, (Object)otherKingdom) && $kingdom.getRelationWith(otherKingdom) != $relation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

