/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.resourcepoints;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePoints;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.GroupResourcePointConvertEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.utils.string.StringUtils;

public class CommandResourcePointsWithdraw
extends KingdomsCommand {
    public CommandResourcePointsWithdraw(KingdomsParentCommand parent) {
        super("withdraw", parent);
    }

    public static boolean handleWithdraw(KingdomPlayer kp, Player player, Kingdom kingdom, long rp) {
        long min;
        if (kp.hasKingdom() && !kp.hasPermission(StandardKingdomPermission.WITHDRAW)) {
            StandardKingdomPermission.WITHDRAW.sendDeniedMessage(player);
            return false;
        }
        if (!kingdom.hasResourcePoints(rp)) {
            String fancyRp = StringUtils.toFancyNumber(rp);
            KingdomsLang.COMMAND_RESOURCEPOINTS_NOT_ENOUGH_RESOURCE_POINTS.sendMessage((CommandSender)player, "rp", fancyRp);
            return false;
        }
        GroupResourcePointConvertEvent event = kp.donate(kingdom, -rp);
        if (event.isCancelled()) {
            return false;
        }
        rp = -event.getAmount();
        if (rp < (min = KingdomsConfig.ECONOMY_RESOURCE_POINTS_MIN_WITHDRAW.getLong())) {
            String fancyMinRp = StringUtils.toFancyNumber(min);
            KingdomsLang.COMMAND_RESOURCEPOINTS_WITHDRAW_MIN.sendError((CommandSender)player, "min", fancyMinRp);
            return false;
        }
        kingdom.addResourcePoints(-rp);
        double worth = (double)rp * KingdomsConfig.ECONOMY_RESOURCE_POINTS_WORTH.getDouble();
        ServiceVault.deposit((OfflinePlayer)player, worth);
        String fancyRp = StringUtils.toFancyNumber(rp);
        String fancyWorth = StringUtils.toFancyNumber(worth);
        String fancyBalance = StringUtils.toFancyNumber(ServiceVault.getMoney((OfflinePlayer)player));
        KingdomsLang.COMMAND_RESOURCEPOINTS_WITHDRAW_SUCCESS.sendMessage((CommandSender)player, "rp", fancyRp, "worth", fancyWorth, "balance", fancyBalance);
        return true;
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return;
        }
        Long amount = CommandResourcePoints.validateAmount(true, context, KingdomsLang.COMMAND_RESOURCEPOINTS_WITHDRAW_USAGE, 0);
        if (amount == null) {
            return;
        }
        CommandResourcePointsWithdraw.handleWithdraw(kp, player, kingdom, amount);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return CommandResourcePoints.processTabComplete(context);
    }
}

