/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.managers.land.indicator.LandVisualizer;
import org.kingdoms.utils.string.StringUtils;

public class CommandLore
extends KingdomsCommand {
    public CommandLore() {
        super("lore", true);
    }

    @Override
    public void execute(CommandContext context) {
        Kingdom kingdom;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.LORE)) {
            StandardKingdomPermission.LORE.sendDeniedMessage(player);
            return;
        }
        if (args.length == 1 && KingdomsConfig.KINGDOM_LORE_REMOVE_KEYWORDS.getStringList().contains(args[0])) {
            Kingdom kingdom2 = kp.getKingdom();
            if (kingdom2.setLore(null, kp).isCancelled()) {
                return;
            }
            KingdomsLang.COMMAND_LORE_REMOVED.sendMessage((CommandSender)player);
            return;
        }
        String lore = CommandLore.joinArgs(args);
        if (!kp.isAdmin()) {
            int len;
            int limit = KingdomsConfig.KINGDOM_LORE_MAX_LENGTH.getInt();
            int n = len = KingdomsConfig.KINGDOM_LORE_IGNORE_COLORS.getBoolean() ? MessageHandler.stripColors(MessageHandler.colorize(lore), false).length() : lore.length();
            if (len > limit) {
                KingdomsLang.COMMAND_LORE_NAME_LENGTH.sendMessage(sender, "limit", limit, "length", len);
                return;
            }
            if (!KingdomsConfig.KINGDOM_LORE_ALLOW_NON_ENGLISH.getBoolean() && !StringUtils.isEnglish(lore)) {
                KingdomsLang.COMMAND_LORE_NAME_ENGLISH.sendMessage((CommandSender)player);
                return;
            }
            if (!KingdomsConfig.KINGDOM_LORE_ALLOW_SYMBOLS.getBoolean() && StringUtils.hasSymbol(lore)) {
                KingdomsLang.COMMAND_LORE_NAME_HAS_SYMBOLS.sendMessage((CommandSender)player);
                return;
            }
            boolean match = false;
            if (!match) {
                for (String regex : KingdomsConfig.KINGDOM_LORE_BLACKLISTED_NAMES.getStringList()) {
                    if (!Pattern.compile(regex).matcher(lore).find()) continue;
                    match = true;
                    break;
                }
            }
            if (match) {
                KingdomsLang.COMMAND_LORE_BLACKLISTED.sendMessage(sender);
                return;
            }
        }
        if (KingdomsConfig.KINGDOM_LORE_ALLOW_COLORS.getBoolean()) {
            lore = MessageCompiler.compile(lore, MessageCompilerSettings.none().colorize()).buildPlain(new MessageBuilder());
        }
        if ((kingdom = kp.getKingdom()).setLore(lore, kp).isCancelled()) {
            return;
        }
        new LandVisualizer().forLand(SimpleChunkLocation.of(player.getLocation())).forPlayer(player, kp).forKingdom(kingdom).displayMessages();
    }

    @Override
    public @Nullable List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        List<String> keywords;
        if (args.length == 1 && !(keywords = KingdomsConfig.KINGDOM_LORE_REMOVE_KEYWORDS.getStringList()).isEmpty()) {
            String keyword = keywords.get(0);
            if (args[0].isEmpty() || keyword.toLowerCase(Locale.ENGLISH).startsWith(args[0].toLowerCase(Locale.ENGLISH))) {
                return Collections.singletonList(keywords.get(0));
            }
        }
        return new ArrayList<String>();
    }
}

