/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.text;

import java.util.regex.Pattern;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.string.StringUtils;

public class CommandTag
extends KingdomsCommand {
    public CommandTag() {
        super("tag", true);
    }

    public static boolean checkTag(String name, Player player) {
        int len;
        int max = KingdomsConfig.TAGS_MAX_LENGTH.getInt();
        int min = KingdomsConfig.TAGS_MIN_LENGTH.getInt();
        int n = len = KingdomsConfig.TAGS_IGNORE_COLORS.getBoolean() ? MessageHandler.stripColors(MessageHandler.colorize(name), false).length() : name.length();
        if (len < min || len > max) {
            KingdomsLang.COMMAND_TAG_NAME_LENGTH.sendMessage((CommandSender)player, "max", max, "min", min);
            return false;
        }
        if (!KingdomsConfig.TAGS_ALLOW_NUMBERS.getBoolean() && StringUtils.containsAnyLangNumber(name)) {
            KingdomsLang.COMMAND_TAG_NAME_NUMBERS.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.TAGS_ALLOW_NON_ENGLISH.getBoolean() && !StringUtils.isEnglish(name)) {
            KingdomsLang.COMMAND_TAG_NAME_ENGLISH.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.TAGS_ALLOW_SYMBOLS.getBoolean() && StringUtils.hasSymbol(name)) {
            KingdomsLang.COMMAND_TAG_NAME_HAS_SYMBOLS.sendMessage((CommandSender)player);
            return false;
        }
        boolean match = false;
        String smallName = name.toLowerCase();
        for (String regex : KingdomsConfig.TAGS_BLACKLISTED_NAMES.getStringList()) {
            if (!Pattern.compile(regex).matcher(smallName).find()) continue;
            match = true;
            break;
        }
        if (match) {
            KingdomsLang.KINGDOM_TAG_BLACKLISTED.sendMessage((CommandSender)player, "tag", name);
            return false;
        }
        return true;
    }

    @Override
    public CommandResult executeX(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.LORE)) {
            StandardKingdomPermission.LORE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        String name = StringUtils.buildArguments(context.args, KingdomsConfig.TAGS_ALLOW_SPACES.getBoolean() ? " " : "");
        Kingdom kingdom = kp.getKingdom();
        if (!kp.isAdmin()) {
            if (!CommandTag.checkTag(name, player)) {
                return CommandResult.FAILED;
            }
            double cost = KingdomsConfig.ECONOMY_COSTS_TAG_KINGDOM.getDouble();
            if (!kingdom.hasMoney(cost)) {
                KingdomsLang.COMMAND_TAG_COST.sendMessage((CommandSender)player, "cost", cost);
                return CommandResult.FAILED;
            }
            kingdom.addBank(-cost);
        }
        String previousTag = kingdom.getTag();
        if (kingdom.renameTag(name, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        MessageBuilder settings = new MessageBuilder().parse("tag", previousTag == null ? KingdomsLang.NONE : previousTag).withContext(player);
        KingdomsLang msg = previousTag == null ? KingdomsLang.COMMAND_TAG_SET : KingdomsLang.COMMAND_TAG_CHANGED;
        for (Player member : kingdom.getOnlineMembers()) {
            msg.sendMessage((CommandSender)member, settings);
        }
        return CommandResult.SUCCESS;
    }
}

