/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.visualizer;

import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.visualizer.CommandVisualizeAll;
import org.kingdoms.commands.general.visualizer.CommandVisualizeMarkers;
import org.kingdoms.commands.general.visualizer.CommandVisualizePermanent;
import org.kingdoms.commands.general.visualizer.CommandVisualizeToggle;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.land.indicator.LandVisualizer;

public class CommandVisualize
extends KingdomsParentCommand {
    public CommandVisualize() {
        super("visualize", true);
        if (this.isDisabled()) {
            return;
        }
        new CommandVisualizePermanent(this);
        new CommandVisualizeToggle(this);
        new CommandVisualizeMarkers(this);
        new CommandVisualizeAll(this);
    }

    private static void handleKingdomItem(StringBuilder turrets, Collection<KingdomItem<?>> items) {
        for (KingdomItem<?> item : items) {
            SimpleLocation location = item.getLocation();
            turrets.append("&8- ").append(((KingdomItemStyle)item.getStyle()).getDisplayName().parse(new Object[0])).append(" &7(&2Lvl. &8").append(item.getLevel()).append("&7) &8| &6").append("hover:{&6").append(location.getX()).append("&7, &6").append(location.getY()).append("&7, &6").append(location.getZ()).append(";&2Teleport;/tp ").append(location.getX()).append(' ').append(location.getY()).append(' ').append(location.getZ()).append('}').append('\n');
        }
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
            Land land = chunk.getLand();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            new LandVisualizer().forPlayer(player, kp).forLand(land, chunk.toChunk()).display(true);
            KingdomsLang lang = !context.hasPermission(KingdomsPluginPermission.COMMAND_VISUALIZE_DETAILS, true) ? KingdomsLang.COMMAND_VISUALIZE_DISPLAY : KingdomsLang.COMMAND_VISUALIZE_ADMIN_DISPLAY;
            StringBuilder turrets = new StringBuilder();
            StringBuilder structures = new StringBuilder();
            if (land != null) {
                CommandVisualize.handleKingdomItem(turrets, land.getTurrets().values());
                CommandVisualize.handleKingdomItem(structures, land.getStructures().values());
            }
            StringBuilder protectionSigns = new StringBuilder();
            if (land != null) {
                for (ProtectionSign protection : land.getProtectedBlocks().values()) {
                    SimpleLocation location = protection.getLocation();
                    OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)protection.getOwner());
                    protectionSigns.append("&2").append(owner.getName()).append(" &8| &5").append("hover:{&6").append(location.getX()).append("&7, &6").append(location.getY()).append("&7, &6").append(location.getZ()).append(";&2Teleport;/tp ").append(location.getX()).append(' ').append(location.getY()).append(' ').append(location.getZ()).append('}').append(" &8| &2").append(protection.getProtectionType().getDisplayname()).append('\n');
                }
            }
            if (turrets.length() == 0) {
                turrets.append("&7None");
            }
            if (structures.length() == 0) {
                structures.append("&7None");
            }
            if (protectionSigns.length() == 0) {
                protectionSigns.append("&7None");
            }
            MessageBuilder settings = new MessageBuilder().raws("structures", new PlaceholderTranslationContext(structures, MessageCompilerSettings.all()), "turrets", new PlaceholderTranslationContext(turrets, MessageCompilerSettings.all()), "protection-signs", new PlaceholderTranslationContext(protectionSigns, MessageCompilerSettings.all()), "kingdom", land != null && land.getKingdom() != null ? land.getKingdom().getName() : "wilderness", "x", chunk.getX(), "z", chunk.getZ());
            lang.getMessageObject(kp.getLanguage()).getSimpleProvider().send((CommandSender)player, settings);
        });
    }
}

