/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.compiler.builders.MessageObjectWithContext;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.string.StringUtils;

public class CommandNationShow
extends KingdomsCommand {
    private static final int RELATION_LIMIT = 30;

    public CommandNationShow(KingdomsParentCommand parent) {
        super("show", parent);
    }

    private static void show(CommandContext context, OfflinePlayer placeholder, Nation nation, boolean adminView) {
        CommandSender sender = context.getSender();
        KingdomPlayer kp = context.getKingdomPlayer();
        SupportedLanguage locale = kp.getLanguage();
        OfflinePlayer king = nation.getCapital().getKing().getOfflinePlayer();
        KingdomsLang kingStatus = king.isOnline() ? KingdomsLang.COMMAND_SHOW_ONLINE_PREFIX : KingdomsLang.COMMAND_SHOW_OFFLINE_PREFIX;
        MessageObjectWithContext kingBuilder = new MessageObjectWithContext(kingStatus.getMessageObject(locale), new MessageBuilder().withContext(king));
        MessageObjectLinker membersBuilder = new MessageObjectLinker();
        for (Kingdom kingdom : nation.getKingdoms()) {
            membersBuilder.add(KingdomsLang.COMMAND_NATION_SHOW_KINGDOMS.getMessageObject(locale), new MessageBuilder().withContext(kingdom));
            membersBuilder.add(" ");
        }
        MessageObjectLinker allies = new MessageObjectLinker();
        MessageObjectLinker truces = new MessageObjectLinker();
        MessageObjectLinker enemies = new MessageObjectLinker();
        int ally = 0;
        int truce = 0;
        int enemy = 0;
        ArrayList<UUID> remove = new ArrayList<UUID>();
        for (Map.Entry<UUID, KingdomRelation> relation : nation.getRelations().entrySet()) {
            Nation otherNation = Nation.getNation(relation.getKey());
            if (otherNation == null) {
                remove.add(relation.getKey());
                KLogger.error("Unknown kingdom while mapping relations of kingdom " + nation.getName() + ": " + relation.getKey());
                continue;
            }
            KingdomRelation rel = relation.getValue();
            MessageBuilder settings = new MessageBuilder().withContext(nation);
            MessageObject msg = KingdomsLang.COMMAND_NATION_SHOW_RELATION.getMessageObject(locale);
            switch (rel) {
                case ALLY: {
                    if (ally == 30) {
                        allies.add("...");
                    } else if (ally < 30) {
                        allies.add(msg, settings).add(" ");
                    }
                    ++ally;
                    break;
                }
                case TRUCE: {
                    if (truce == 30) {
                        truces.add("...");
                    } else if (truce < 30) {
                        truces.add(msg, settings).add(" ");
                    }
                    ++truce;
                    break;
                }
                case ENEMY: {
                    if (enemy == 30) {
                        enemies.add("...");
                    } else if (enemy < 30) {
                        enemies.add(msg, settings).add(" ");
                    }
                    ++enemy;
                }
            }
        }
        for (UUID id : remove) {
            nation.getRelations().remove(id);
        }
        MessageBuilder settings = new MessageBuilder().raws("king_status", kingBuilder, "kingdoms", membersBuilder, "truces", truces, "allies", allies, "enemies", enemies);
        if (placeholder == null) {
            settings.withContext(nation);
        } else if (sender instanceof Player) {
            settings.withContext(placeholder).other((Player)sender);
        } else {
            settings.withContext(placeholder);
        }
        KingdomsLang lang = sender instanceof Player ? (adminView ? KingdomsLang.COMMAND_NATION_SHOW_MESSAGE_ADMIN : KingdomsLang.COMMAND_NATION_SHOW_MESSAGE) : KingdomsLang.COMMAND_NATION_SHOW_MESSAGE_ADMIN;
        lang.sendMessage(sender, settings);
        if (ally != 0) {
            KingdomsLang.COMMAND_NATION_SHOW_ALLIES.sendMessage(sender, new MessageBuilder().raws("allies", allies));
        }
        if (truce != 0) {
            KingdomsLang.COMMAND_NATION_SHOW_TRUCES.sendMessage(sender, new MessageBuilder().raws("truces", truces));
        }
        if (enemy != 0) {
            KingdomsLang.COMMAND_NATION_SHOW_ENEMIES.sendMessage(sender, new MessageBuilder().raws("enemies", enemies));
        }
    }

    @Override
    public void execute(CommandContext context) {
        if (!context.isPlayer() && context.requireArgs(1)) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        boolean admin = KingdomsPluginPermission.COMMAND_NATION_SHOW_ADMIN.hasPermission(sender, true);
        Function<Nation, Boolean> hasAdminView = nation -> admin || context.isPlayer() && nation.isMember((OfflinePlayer)context.senderAsPlayer());
        if (args.length == 0) {
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            if (!kp.hasKingdom()) {
                KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
                return;
            }
            Nation nation2 = kp.getKingdom().getNation();
            if (nation2 == null) {
                KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
                return;
            }
            CommandNationShow.show(context, (OfflinePlayer)player, nation2, true);
            return;
        }
        String name = args[0];
        if (args.length == 1) {
            if (StringUtils.isOneOf(name.toLowerCase(Locale.ENGLISH), "#kingdom", "#player")) {
                context.wrongUsage();
                return;
            }
            if (!context.hasPermission(KingdomsPluginPermission.COMMAND_NATION_SHOW_OTHERS)) {
                KingdomsLang.COMMAND_NATION_SHOW_OTHERS_PERMISSION.parse(sender, new Object[0]);
                return;
            }
            Nation nation3 = Nation.getNation(context.arg(0));
            if (nation3 == null) {
                Kingdom kingdom = Kingdom.getKingdom(context.arg(0));
                if (kingdom == null || !kingdom.hasNation()) {
                    OfflinePlayer player = PlayerUtils.getOfflinePlayer(context.arg(0));
                    if (player != null) {
                        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
                        kingdom = kp.getKingdom();
                        nation3 = kingdom.getNation();
                    }
                } else {
                    nation3 = kingdom.getNation();
                }
            }
            if (nation3 == null) {
                KingdomsLang.COMMAND_NATION_NOT_IN_NATION.sendError(sender, new Object[0]);
                return;
            }
            OfflinePlayer placeholder = nation3.getCapital().getKing().getOfflinePlayer();
            CommandNationShow.show(context, placeholder, nation3, hasAdminView.apply(nation3));
            return;
        }
        if (!context.hasPermission(KingdomsPluginPermission.COMMAND_NATION_SHOW_OTHERS)) {
            KingdomsLang.COMMAND_NATION_SHOW_OTHERS_PERMISSION.parse(sender, new Object[0]);
            return;
        }
        switch (name = name.toLowerCase(Locale.ENGLISH)) {
            case "#nation": {
                name = args[1];
                Nation nation4 = Nation.getNation(name.toLowerCase(Locale.ENGLISH));
                if (nation4 == null) {
                    KingdomsLang.NOT_FOUND_NATION.sendMessage(sender, "arg", name);
                    return;
                }
                CommandNationShow.show(context, nation4.getCapital().getKing().getOfflinePlayer(), nation4, hasAdminView.apply(nation4));
                break;
            }
            case "#kingdom": {
                name = args[1];
                Kingdom kingdom = Kingdom.getKingdom(name.toLowerCase());
                if (kingdom == null) {
                    KingdomsLang.NOT_FOUND_KINGDOM.sendMessage(sender, "arg", name);
                    return;
                }
                Nation nation5 = kingdom.getNation();
                CommandNationShow.show(context, kingdom.getKing().getOfflinePlayer(), nation5, hasAdminView.apply(nation5));
                break;
            }
            case "#player": {
                name = args[1];
                OfflinePlayer player = context.getOfflinePlayer(1);
                if (player == null) {
                    return;
                }
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
                if (!kp.hasKingdom()) {
                    KingdomsLang.NOT_FOUND_PLAYER_NO_KINGDOM.sendMessage(sender, "arg", name);
                    return;
                }
                Nation nation6 = kp.getKingdom().getNation();
                if (nation6 == null) {
                    KingdomsLang.COMMAND_NATION_NOT_IN_NATION.sendError(sender, new Object[0]);
                    return;
                }
                CommandNationShow.show(context, player, nation6, hasAdminView.apply(nation6));
                break;
            }
            default: {
                KingdomsLang.COMMAND_NATION_SHOW_USAGE.sendMessage(sender);
            }
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length > 2) {
            return new ArrayList<String>();
        }
        if (args.length == 2) {
            String name;
            switch (name = args[0].toLowerCase(Locale.ENGLISH)) {
                case "#player": {
                    return TabCompleteManager.getPlayers(args[1]);
                }
                case "#kingdom": {
                    return TabCompleteManager.getKingdoms(args[1]);
                }
                case "#nation": {
                    return TabCompleteManager.getNations(args[1], null);
                }
            }
        }
        if (args.length == 1) {
            List<String> names = TabCompleteManager.getPlayers(args[0]);
            names.addAll(TabCompleteManager.getKingdoms(args[0]));
            names.addAll(TabCompleteManager.getNations(args[0], null));
            names.add("#NATION");
            names.add("#KINGDOM");
            names.add("#PLAYER");
            return names;
        }
        return new ArrayList<String>();
    }
}

