/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.invitations;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationJoin
extends KingdomsCommand {
    public CommandNationJoin(KingdomsParentCommand parent) {
        super("join", parent, PermissionDefault.TRUE);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom.hasNation()) {
            KingdomsLang.COMMAND_NATION_JOIN_ALREADY_IN_NATION.sendMessage((CommandSender)player);
            return;
        }
        Nation nation = context.getNation(0);
        if (nation == null) {
            return;
        }
        if (nation.requiresInvite()) {
            KingdomsLang.COMMAND_NATION_JOIN_REQUIRES_INVITE.sendMessage((CommandSender)player, "nation", nation.getName());
            return;
        }
        if (kingdom.joinNation(nation, kp).isCancelled()) {
            return;
        }
        for (Player member : nation.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_JOIN_JOINED.sendMessage((CommandSender)member, (OfflinePlayer)player, new Object[]{"kingdom", kingdom.getName()});
        }
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getNations(args[0], null);
        }
        return new ArrayList<String>();
    }
}

