/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.spawn;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.home.CommandHome;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.GroupHomeTeleportEvent;
import org.kingdoms.events.general.nation.NationSetSpawnEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.teleportation.IsolatedTpManager;
import org.kingdoms.managers.teleportation.TeleportTask;
import org.kingdoms.managers.teleportation.TpManager;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;

public class CommandNationSpawn
extends KingdomsCommand
implements Listener {
    private static final IsolatedTpManager TELEPORTS = new IsolatedTpManager();

    public CommandNationSpawn(KingdomsParentCommand parent) {
        super("spawn", parent, PermissionDefault.TRUE);
    }

    @Override
    public void execute(CommandContext context) {
        BukkitTask task;
        int timer;
        Location home;
        Nation nation;
        if (context.assertPlayer()) {
            return;
        }
        final Player player = context.senderAsPlayer();
        if (TpManager.alreadyTping(player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        GroupHomeTeleportEvent.LocationType locType = GroupHomeTeleportEvent.LocationType.HOME;
        if (!context.assertArgs(1)) {
            if (context.assertHasKingdom()) {
                return;
            }
            if (!kp.hasNationPermission(StandardKingdomPermission.HOME)) {
                StandardKingdomPermission.HOME.sendDeniedMessage(player);
                return;
            }
            nation = kp.getKingdom().getNation();
            if (nation == null) {
                context.sendError(KingdomsLang.NO_NATION, new Object[0]);
                return;
            }
            home = nation.getHome();
            if (home == null) {
                if (KingdomsConfig.HOME_USE_NEXUS_IF_NOT_SET.getBoolean() && nation.getNexus() != null) {
                    SimpleChunkLocation chunk = nation.getNexus().toSimpleChunkLocation();
                    Land nexusLand = chunk.getLand();
                    if (nexusLand != null) {
                        Structure structure = nexusLand.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus());
                        if (structure == null) {
                            MessageHandler.sendConsolePluginMessage("&4Unknown nexus data for &e" + nation.getName() + " (" + nation.getId() + ") &4nation in land &e" + nexusLand.getLocation() + " &4with null structure.");
                            return;
                        }
                        home = LocationUtils.getSafeLocation(structure.getLocation().toBukkitLocation().add(0.5, 0.0, 0.5));
                        locType = GroupHomeTeleportEvent.LocationType.NEXUS;
                    } else {
                        MessageHandler.sendConsolePluginMessage("&4Unknown nexus data for &e" + nation.getName() + " (" + nation.getId() + ") &4nation in land &e" + chunk + " &4with null land data.");
                        return;
                    }
                }
                if (home == null) {
                    context.sendError(KingdomsLang.COMMAND_NATION_SPAWN_NOT_SET, new Object[0]);
                    return;
                }
            }
        } else {
            if (!context.hasPermission(KingdomsPluginPermission.COMMAND_HOME_OTHERS, true)) {
                context.sendError(KingdomsLang.COMMAND_NATION_SPAWN_PERMISSION, new Object[0]);
                return;
            }
            nation = context.getNation(0);
            if (nation == null) {
                return;
            }
            home = nation.getHome();
            if (home == null) {
                context.sendError(KingdomsLang.COMMAND_NATION_SPAWN_NOT_SET_OTHERS, "nation", nation.getName());
                return;
            }
            if (!kp.isAdmin() && !nation.isMember((OfflinePlayer)player)) {
                if (!nation.isHomePublic()) {
                    context.sendError(KingdomsLang.COMMAND_NATION_SPAWN_NOT_PUBLIC, "nation", nation.getName());
                    return;
                }
                if (!nation.hasAttribute(kp.getKingdom().getNation(), StandardRelationAttribute.HOME)) {
                    context.sendError(KingdomsLang.COMMAND_NATION_SPAWN_CANT_USE_PUBLIC_HOME, "nation", nation.getName());
                    return;
                }
                if (Land.getLand(nation.getHome()).isBeingInvaded()) {
                    context.sendError(KingdomsLang.COMMAND_NATION_SPAWN_BEING_INVADED, "nation", nation.getName());
                    return;
                }
            }
        }
        if ((timer = KingdomsConfig.HOME_TELEPORT_DELAY.getInt()) <= 0 || kp.isAdmin() || context.hasPermission(KingdomsPluginPermission.COMMAND_HOME_BYPASS_TIMER) || PlayerUtils.invulnerableGameMode(player)) {
            if ((home = CommandHome.callEvent(nation, player, home, locType)) == null) {
                return;
            }
            player.teleport(home);
            context.sendMessage(KingdomsLang.COMMAND_NATION_SPAWN_SUCCESS, new Object[0]);
            return;
        }
        final Location finalHome = home;
        final GroupHomeTeleportEvent.LocationType finalLocType = locType;
        if (KingdomsConfig.HOME_USE_TIMER_MESSAGE.getBoolean()) {
            task = new BukkitRunnable(){
                int timed;
                {
                    this.timed = timer;
                }

                public void run() {
                    if (this.timed <= 0) {
                        Location finalFinalHome = CommandHome.callEvent(nation, player, finalHome, finalLocType);
                        if (finalFinalHome != null) {
                            player.teleport(finalFinalHome);
                            KingdomsLang.COMMAND_NATION_SPAWN_SUCCESS.sendMessage((CommandSender)player);
                        }
                        TELEPORTS.end((Entity)player);
                        this.cancel();
                    } else {
                        KingdomsLang.COMMAND_NATION_SPAWN_TELEPORTING.sendMessage((CommandSender)player, "countdown", this.timed);
                        --this.timed;
                    }
                }
            }.runTaskTimer((Plugin)plugin, 0L, 20L);
        } else {
            KingdomsLang.COMMAND_NATION_SPAWN_TELEPORTING.sendMessage((CommandSender)player, "countdown", timer);
            task = new BukkitRunnable(){

                public void run() {
                    Location finalFinalHome = CommandHome.callEvent(nation, player, finalHome, finalLocType);
                    if (finalFinalHome != null) {
                        player.teleport(finalHome);
                        KingdomsLang.COMMAND_NATION_SPAWN_SUCCESS.sendMessage((CommandSender)player);
                    }
                    TELEPORTS.end((Entity)player);
                }
            }.runTaskLater((Plugin)plugin, (long)timer * 20L);
        }
        TeleportTask tpTask = new TeleportTask(player, task);
        tpTask.onAnyMove(event -> {
            KingdomsLang.TELEPORTS_MOVED.sendError((CommandSender)player, new Object[0]);
            return true;
        });
        TELEPORTS.put(tpTask);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onHomeSet(NationSetSpawnEvent event) {
        ArrayList<Player> putAnEnd = new ArrayList<Player>();
        for (TeleportTask task : TELEPORTS.getTasks()) {
            if (!event.getNation().isMember((OfflinePlayer)task.player)) continue;
            KingdomsLang.COMMAND_NATION_SPAWN_CHANGED.sendError((CommandSender)task.player, new Object[0]);
            putAnEnd.add(task.player);
        }
        putAnEnd.forEach(TELEPORTS::end);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0) && context.hasPermission(KingdomsPluginPermission.COMMAND_HOME_OTHERS, true)) {
            return context.getKingdoms(0);
        }
        return CommandNationSpawn.emptyTab();
    }
}

