/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.config.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.config.migration.ConfigMigration;
import org.kingdoms.config.migration.ConfigMigrationSession;
import org.kingdoms.config.migration.ConfigRelocation;
import org.kingdoms.config.migration.DefaultValue;
import org.kingdoms.config.migration.DeleteConfigs;
import org.kingdoms.config.migration.SoftwareWideConfigReplacer;
import org.kingdoms.gui.GUIPathContainer;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.comparisons.ComparisonsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.network.UpdateChecker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/config/migration/ConfigMigrationHistory;", "", "()V", "Companion", "core"})
public final class ConfigMigrationHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<ConfigMigration> MIGRATIONS = new ArrayList();

    @JvmStatic
    public static final void register(@NotNull ConfigMigration migration) {
        Companion.register(migration);
    }

    @JvmStatic
    private static final void placeholderChange(String $this$placeholderChange, String oldIdentifier, String newIdentifier) {
        ConfigMigrationHistory.Companion.placeholderChange($this$placeholderChange, oldIdentifier, newIdentifier);
    }

    @JvmStatic
    private static final void delete(String $this$delete, YamlContainer[] adapter) {
        ConfigMigrationHistory.Companion.delete($this$delete, adapter);
    }

    @JvmStatic
    private static final void defaultValue(String $this$defaultValue, YamlWithDefaults adapter, String[][] entries) {
        ConfigMigrationHistory.Companion.defaultValue($this$defaultValue, adapter, entries);
    }

    @JvmStatic
    private static final void relocate(String $this$relocate, YamlContainer from, YamlContainer to, String[] fromPath, String[] toPath) {
        ConfigMigrationHistory.Companion.relocate($this$relocate, from, to, fromPath, toPath);
    }

    @JvmStatic
    private static final YamlContainer[] getGUIConfigsOf(GUIPathContainer gui) {
        return ConfigMigrationHistory.Companion.getGUIConfigsOf(gui);
    }

    @JvmStatic
    public static final void applyMigrations() {
        Companion.applyMigrations();
    }

    static {
        String $this$_init__u24lambda_u2d0 = "1.15.0";
        boolean bl = false;
        YamlContainer[] yamlContainerArray = new YamlContainer[3];
        YamlResource yamlResource = KingdomsConfig.STRUCTURES;
        Intrinsics.checkNotNullExpressionValue((Object)yamlResource, (String)"STRUCTURES");
        yamlContainerArray[0] = yamlResource;
        YamlResource yamlResource2 = KingdomsConfig.MAIN;
        Intrinsics.checkNotNullExpressionValue((Object)yamlResource2, (String)"MAIN");
        yamlContainerArray[1] = yamlResource2;
        YamlResource yamlResource3 = KingdomsConfig.CHAT;
        Intrinsics.checkNotNullExpressionValue((Object)yamlResource3, (String)"CHAT");
        yamlContainerArray[2] = yamlResource3;
        ConfigMigrationHistory.Companion.delete($this$_init__u24lambda_u2d0, yamlContainerArray);
        ConfigMigrationHistory.Companion.delete($this$_init__u24lambda_u2d0, ConfigMigrationHistory.Companion.getGUIConfigsOf(KingdomsGUI.STRUCTURES_EXTRACTOR));
        ConfigMigrationHistory.Companion.delete($this$_init__u24lambda_u2d0, ConfigMigrationHistory.Companion.getGUIConfigsOf(KingdomsGUI.STRUCTURES_OUTPOST));
        String $this$_init__u24lambda_u2d1 = "1.15.3.2";
        boolean bl2 = false;
        ConfigMigrationHistory.Companion.placeholderChange($this$_init__u24lambda_u2d1, "masswar_isrunning", "masswar_is_running");
        ConfigMigrationHistory.Companion.placeholderChange($this$_init__u24lambda_u2d1, "name", "kingdom_name");
        ConfigMigrationHistory.Companion.placeholderChange($this$_init__u24lambda_u2d1, "flag", "kingdom_flag");
        ConfigMigrationHistory.Companion.placeholderChange($this$_init__u24lambda_u2d1, "color", "kingdom_color");
        ConfigMigrationHistory.Companion.placeholderChange($this$_init__u24lambda_u2d1, "lands", "claims");
        ConfigMigrationHistory.Companion.placeholderChange($this$_init__u24lambda_u2d1, "max_lands", "max_claims");
        YamlResource yamlResource4 = KingdomsConfig.CHAMPION_UPGRADES;
        Intrinsics.checkNotNullExpressionValue((Object)yamlResource4, (String)"CHAMPION_UPGRADES");
        yamlContainerArray = new String[3][];
        String[] stringArray = new String[]{"fangs", "cooldown"};
        yamlContainerArray[0] = stringArray;
        stringArray = new String[]{"plow", "cooldown"};
        yamlContainerArray[1] = stringArray;
        stringArray = new String[]{"thor", "cooldown"};
        yamlContainerArray[2] = stringArray;
        ConfigMigrationHistory.Companion.defaultValue($this$_init__u24lambda_u2d1, yamlResource4, (String[][])yamlContainerArray);
        List<ConfigMigration> $this$sortBy$iv = MIGRATIONS;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ConfigMigration x = (ConfigMigration)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(x.getPriority());
                    x = (ConfigMigration)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(x.getPriority()));
                }
            });
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J-\u0010\u0010\u001a\u00020\u0007*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\t0\tH\u0003\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u0007*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0003\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u0007*\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0003J=\u0010\u001b\u001a\u00020\u0007*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0003\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/kingdoms/config/migration/ConfigMigrationHistory$Companion;", "", "()V", "MIGRATIONS", "", "Lorg/kingdoms/config/migration/ConfigMigration;", "applyMigrations", "", "getGUIConfigsOf", "", "Lorg/kingdoms/utils/config/adapters/YamlContainer;", "gui", "Lorg/kingdoms/gui/GUIPathContainer;", "(Lorg/kingdoms/gui/GUIPathContainer;)[Lorg/kingdoms/utils/config/adapters/YamlContainer;", "register", "migration", "defaultValue", "", "adapter", "Lorg/kingdoms/utils/config/adapters/YamlWithDefaults;", "entries", "(Ljava/lang/String;Lorg/kingdoms/utils/config/adapters/YamlWithDefaults;[[Ljava/lang/String;)V", "delete", "(Ljava/lang/String;[Lorg/kingdoms/utils/config/adapters/YamlContainer;)V", "placeholderChange", "oldIdentifier", "newIdentifier", "relocate", "from", "to", "fromPath", "toPath", "(Ljava/lang/String;Lorg/kingdoms/utils/config/adapters/YamlContainer;Lorg/kingdoms/utils/config/adapters/YamlContainer;[Ljava/lang/String;[Ljava/lang/String;)V", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void register(@NotNull ConfigMigration migration) {
            Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
            migration.setId(MIGRATIONS.size());
            MIGRATIONS.add(migration);
        }

        @JvmStatic
        private final void placeholderChange(String $this$placeholderChange, String oldIdentifier, String newIdentifier) {
            new SoftwareWideConfigReplacer(new Regex("(%)?kingdoms_(other_)?((?:fancy|short|time|date|bool)_)?" + oldIdentifier + "(@\\w+)(%)?"), "$1kingdoms_$2$3" + newIdentifier + "$4$1").info($this$placeholderChange, "Update %kingdoms_" + oldIdentifier + "% placeholders to %kingdoms_" + newIdentifier + '%');
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final void delete(String $this$delete, YamlContainer[] adapter) {
            Collection<File> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            YamlContainer[] yamlContainerArray = adapter;
            StringBuilder stringBuilder = new StringBuilder().append("Since ");
            String string = $this$delete;
            DeleteConfigs deleteConfigs = new DeleteConfigs(adapter);
            boolean $i$f$map = false;
            void var5_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void x;
                void item$iv$iv;
                void var11_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(x.getFile());
            }
            collection = (List)destination$iv$iv;
            deleteConfigs.info(string, stringBuilder.append(collection).append(" has undergone too many changes and was deleted entirely for a fresh config.").toString());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final void defaultValue(String $this$defaultValue, YamlWithDefaults adapter, String[][] entries) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = (Object[])entries;
            StringBuilder stringBuilder = new StringBuilder().append("Defaulted the value of the following entries in ").append(adapter.getFile()).append(" config: ");
            String string = $this$defaultValue;
            DefaultValue defaultValue = new DefaultValue(adapter, entries);
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                String[] stringArray = (String[])item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ArraysKt.joinToString$default((Object[])x, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
            }
            collection = (List)destination$iv$iv;
            defaultValue.info(string, stringBuilder.append(collection).toString());
        }

        @JvmStatic
        private final void relocate(String $this$relocate, YamlContainer from, YamlContainer to, String[] fromPath, String[] toPath) {
            String string;
            ConfigRelocation configRelocation = new ConfigRelocation(from, to, fromPath, toPath);
            StringBuilder stringBuilder = new StringBuilder().append("The option '");
            String string2 = Arrays.toString(fromPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append("' was moved from ").append(from.getFile()).append(" to ").append(to.getFile());
            if (Arrays.equals(fromPath, toPath)) {
                StringBuilder stringBuilder3 = new StringBuilder().append(" to path ");
                String string3 = Arrays.toString(toPath);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this)");
                string = stringBuilder3.append(string3).toString();
            } else {
                string = "";
            }
            configRelocation.info($this$relocate, stringBuilder2.append(string).toString());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final YamlContainer[] getGUIConfigsOf(GUIPathContainer gui) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            List<SupportedLanguage> list2 = SupportedLanguage.getInstalled();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstalled()");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                GUIObject it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                SupportedLanguage x = (SupportedLanguage)((Object)element$iv$iv);
                boolean bl2 = false;
                if (x.getGUIs().get(gui.getGUIPath()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                object = (GUIObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(x.getConfig());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            YamlContainer[] yamlContainerArray = thisCollection$iv.toArray(new YamlContainer[0]);
            Intrinsics.checkNotNull((Object)yamlContainerArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            return yamlContainerArray;
        }

        @JvmStatic
        public final void applyMigrations() {
            String highestVersion;
            String string;
            String lastFreshVersion;
            KLogger.info("Checking for config migrations...");
            String string2 = Kingdoms.get().getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get().description.version");
            String currentVersion = string2;
            String[] stringArray = new String[]{"config-migration"};
            ConfigSection section = ConfigManager.getGlobals().createSection(stringArray);
            String string3 = section.getString("last-fresh-version");
            if (string3 == null) {
                string3 = lastFreshVersion = currentVersion;
            }
            if ((string = section.getString("last-applied-migration")) == null) {
                string = "0.0.0";
            }
            String lastAppliedVersion = string;
            ConfigMigrationSession session = new ConfigMigrationSession();
            String string4 = highestVersion = UpdateChecker.isHigher(lastAppliedVersion, lastFreshVersion) ? lastFreshVersion : lastAppliedVersion;
            if (Intrinsics.areEqual((Object)highestVersion, (Object)currentVersion) || UpdateChecker.isHigher(currentVersion, highestVersion)) {
                return;
            }
            for (ConfigMigration migration : MIGRATIONS) {
                if (UpdateChecker.isHigher(migration.getVersion(), highestVersion)) continue;
                migration.apply(session);
                KLogger.info("[Migration][" + migration.getVersion() + "] " + migration.getDescription());
            }
            section.set("last-applied-migration", (Object)currentVersion);
            section.set("last-fresh-version", (Object)lastFreshVersion);
            ConfigManager.getGlobalsAdapter().saveConfig();
            Iterable $this$forEach$iv = session.getConfigsNeedingReload();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                YamlContainer x = (YamlContainer)element$iv;
                boolean bl = false;
                x.saveConfig();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

