/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group;

import java.awt.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.mails.MailRecipientType;
import org.kingdoms.constants.metadata.KingdomMetadata;
import org.kingdoms.constants.metadata.KingdomMetadataHandler;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.data.Pair;
import org.kingdoms.events.general.GroupColorChangeEvent;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.GroupFlagChangeEvent;
import org.kingdoms.events.general.GroupHiddenStateChangeEvent;
import org.kingdoms.events.general.GroupRenameEvent;
import org.kingdoms.events.general.GroupRenameTagEvent;
import org.kingdoms.events.general.MailSendEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.managers.ResourcePointManager;
import org.kingdoms.managers.mails.DraftMail;
import org.kingdoms.managers.structures.StructureManager;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.versionsupport.VersionSupport;

public abstract class Group
extends KingdomsObject<UUID> {
    protected final @NonNull Set<UUID> members;
    protected @NonNull Map<UUID, KingdomRelationshipRequest> relationshipRequests;
    protected @NonNull Map<UUID, KingdomRelation> relations;
    protected @NonNull Map<KingdomRelation, Set<RelationAttribute>> attributes;
    protected @NonNull UUID owner;
    protected final transient UUID id;
    protected @NonNull String name;
    protected @Nullable SimpleLocation nexus;
    protected @Nullable Location home;
    protected long shieldSince;
    protected long shieldTime;
    private transient long lastLogsExpirationCheck;
    protected long resourcePoints;
    protected long since;
    protected @Nullable String tag;
    protected double bank;
    protected double publicHomeCost;
    protected @NonNull RankMap ranks;
    protected boolean requiresInvite;
    protected boolean publicHome;
    protected boolean permanent;
    protected boolean hidden;
    protected @Nullable String tax;
    protected @NonNull Map<String, BookChapter> book;
    private final @NonNull Set<UUID> mails;
    private @Nullable String flag;
    private Color color;
    private final @NonNull LinkedList<AuditLog> logs;

    public Group(@NonNull UUID id, @NonNull UUID owner, @NonNull String name, @Nullable String tag, @Nullable String tax, @NonNull RankMap ranks, long resourcePoints, long since, double bank, boolean publicHome, boolean permanent, boolean requiresInvite, long shieldSince, long shieldTime, @Nullable SimpleLocation nexus, @Nullable Location home, String flag, Color color, @NonNull Set<UUID> members, @NonNull Map<String, BookChapter> book, Map<UUID, KingdomRelation> relations, Map<UUID, KingdomRelationshipRequest> relationshipRequests, Map<KingdomRelation, Set<RelationAttribute>> attributes, @NonNull Set<UUID> mails, @NonNull LinkedList<AuditLog> logs) {
        super(new HashMap<KingdomMetadataHandler, KingdomMetadata>());
        this.id = id;
        this.owner = owner;
        this.name = name;
        this.tag = tag;
        this.tax = tax;
        this.color = color;
        this.flag = flag;
        this.ranks = Objects.requireNonNull(ranks, "Group ranks cannot be null");
        this.resourcePoints = resourcePoints;
        this.since = since;
        this.bank = bank;
        this.book = book;
        this.publicHome = publicHome;
        this.permanent = permanent;
        this.requiresInvite = requiresInvite;
        this.shieldSince = shieldSince;
        this.shieldTime = shieldTime;
        this.nexus = nexus;
        this.home = home;
        this.members = members;
        this.relations = Objects.requireNonNull(relations, "Group relations cannot be null");
        this.relationshipRequests = Objects.requireNonNull(relationshipRequests, "Group relationship requests cannot be null");
        this.attributes = Objects.requireNonNull(attributes, "Group attributes cannot be null");
        this.mails = Objects.requireNonNull(mails, "Mails cannot be null");
        this.logs = Objects.requireNonNull(logs, "Logs cannot be null");
    }

    public Group(@NonNull UUID owner, @Nullable String name) {
        super(new NonNullMap<KingdomMetadataHandler, KingdomMetadata>());
        this.id = UUID.randomUUID();
        this.owner = Objects.requireNonNull(owner, "Group owner cannot be null");
        this.name = Objects.requireNonNull(name, "Group name cannot be null");
        this.since = System.currentTimeMillis();
        this.publicHome = KingdomsConfig.DEFAULT_PUBLIC_HOMES.getBoolean();
        this.requiresInvite = true;
        this.ranks = Rank.copyDefaults();
        this.attributes = KingdomRelation.copyDefaults();
        this.book = new HashMap<String, BookChapter>();
        this.members = new HashSet<UUID>();
        this.relations = new HashMap<UUID, KingdomRelation>();
        this.relationshipRequests = new HashMap<UUID, KingdomRelationshipRequest>();
        this.mails = new LinkedHashSet<UUID>();
        this.logs = new LinkedList();
    }

    public Mail sendMail(Player sender, DraftMail draft) {
        return this.sendMail(draft.getSubject(), sender, draft.getRecipients(), draft.getMessage(), draft.getInReplyTo());
    }

    public Mail sendMail(String subject, Player sender, Map<Group, MailRecipientType> recipients, List<String> message, UUID replyTo) {
        MailSendEvent event = new MailSendEvent(this, sender, recipients, replyTo == null ? null : Mail.getMail(replyTo), message);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        recipients = event.getRecipients();
        message = event.getMessage();
        HashMap<UUID, MailRecipientType> uuidRecipients = new HashMap<UUID, MailRecipientType>(recipients.size());
        recipients.forEach((recipient, mail) -> uuidRecipients.put(recipient.id, (MailRecipientType)((Object)mail)));
        Mail mail2 = new Mail(UUID.randomUUID(), this.id, sender.getUniqueId(), subject, uuidRecipients, message, replyTo);
        this.mails.add(mail2.getId());
        for (Group group : recipients.keySet()) {
            group.mails.add(mail2.getId());
        }
        return mail2;
    }

    public void log(AuditLog log) {
        if (KingdomsConfig.AUDIT_LOGS_DISABLED.getStringList().contains(log.getProvider().getNamespace().getConfigOptionName())) {
            return;
        }
        this.logs.add(log);
    }

    public List<Mail> getSentMails() {
        ArrayList<Mail> sent = new ArrayList<Mail>(this.mails.size() / 2);
        for (Mail mail : this.getMails().values()) {
            if (!mail.getFromGroup().equals(this.id)) continue;
            sent.add(mail);
        }
        return sent;
    }

    public List<Mail> getReceivedMails() {
        ArrayList<Mail> received = new ArrayList<Mail>(this.mails.size() / 2);
        for (Mail mail : this.getMails().values()) {
            if (mail.getFromGroup().equals(this.id)) continue;
            received.add(mail);
        }
        return received;
    }

    public double getPublicHomeCost() {
        return this.publicHomeCost;
    }

    public void setPublicHomeCost(double publicHomeCost) {
        this.publicHomeCost = publicHomeCost;
    }

    public abstract String getTaxOrDefault();

    public static @NonNull Comparator<Group> getTopComparator() {
        return Comparator.comparingDouble(Group::getMight);
    }

    public @NonNull Map<String, BookChapter> getBook() {
        return this.book;
    }

    public void setBook(@NonNull Map<String, BookChapter> book) {
        this.book = book;
    }

    public abstract NexusMoveEvent placeOrMoveNexus(@NonNull Location var1, @Nullable KingdomPlayer var2);

    public NexusMoveEvent abstractPlaceOrMoveNexus(String styleName, @NonNull Location toLocation, @Nullable KingdomPlayer kp) {
        Structure previousNexusStructure;
        SimpleLocation toSimpLoc = SimpleLocation.of(toLocation);
        SimpleChunkLocation chunk = toSimpLoc.toSimpleChunkLocation();
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed() || (this instanceof Kingdom ? !((Kingdom)this).isClaimed(chunk) : !((Nation)this).isMember(land.getKingdomId()))) {
            throw new IllegalArgumentException("Cannot place nexus in a land that does not belong to the kingdom: " + chunk + " -> " + land + " | " + (land == null ? "not claimed" : Boolean.valueOf(land.isClaimed())) + " (" + (this instanceof Kingdom ? !((Kingdom)this).isClaimed(chunk) : !((Nation)this).isMember(land.getKingdomId())) + ')');
        }
        StructureStyle style = Objects.requireNonNull(StructureRegistry.getStyle(styleName), () -> "Cannot find nexus structure properties in Structures folder config: " + styleName);
        KingdomItem newStructure = ((StructureType)style.getType()).build(new KingdomItemBuilder(style, toSimpLoc));
        if (this.nexus != null) {
            SimpleChunkLocation nexusChunk = this.nexus.toSimpleChunkLocation();
            Land nexusLand = nexusChunk.getLand();
            if (nexusLand == null) {
                MessageHandler.sendConsolePluginMessage("&4Invalid nexus land data at &e" + nexusChunk);
                previousNexusStructure = null;
            } else {
                previousNexusStructure = nexusLand.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus());
                if (previousNexusStructure == null) {
                    MessageHandler.sendConsolePluginMessage("&4Invalid nexus structure data at &e" + nexusChunk + " &4for kingdom&8: &e" + this.name);
                }
            }
        } else {
            previousNexusStructure = null;
        }
        NexusMoveEvent event = new NexusMoveEvent(previousNexusStructure, (Structure)newStructure, kp, this.nexus == null ? null : this.nexus, toSimpLoc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        toSimpLoc = event.getTo();
        newStructure = event.getNewStructure();
        if (previousNexusStructure != null) {
            KingdomItemRemoveContext removeCtx = new KingdomItemRemoveContext();
            removeCtx.setPlayer(kp);
            removeCtx.setCause(event);
            removeCtx.setDropsItem(false);
            previousNexusStructure.remove(removeCtx);
        }
        this.nexus = toSimpLoc;
        StructureManager.processStructureProperties(land, (Structure)newStructure, VersionSupport.getPlayerFacing(kp.getPlayer()).getOppositeFace());
        return event;
    }

    @Override
    public @NonNull String getCompressedData() {
        return this.name + Group.compressString(this.tag) + Group.compressString(this.tax) + Group.compressUUID(this.owner) + Group.compressString(this.flag) + Group.compressColor(this.color) + this.resourcePoints + this.since + this.bank + this.shieldTime + this.shieldSince + (this.nexus == null ? "" : this.nexus.getCompressedData()) + Group.compressLocation(this.home) + Group.compressBoolean(this.permanent) + Group.compressBoolean(this.requiresInvite) + Group.compressBoolean(this.hidden) + Group.compressCollecton(this.ranks.getRanks().values(), Rank::getCompressedData) + this.relations.entrySet().stream().map(entry -> Group.compressUUID((UUID)entry.getKey()) + ((KingdomRelation)((Object)((Object)entry.getValue()))).ordinal()).collect(Collectors.joining()) + Group.compressCollecton(this.relationshipRequests.values(), Object::hashCode) + Group.compressMap(this.attributes, this.attributes.size(), Enum::ordinal, x -> Group.compressCollecton(x, RelationAttribute::hashCode)) + this.book.entrySet().stream().map(entry -> (String)entry.getKey() + Group.compressCollecton(((BookChapter)entry.getValue()).getPages(), x -> x)).collect(Collectors.joining()) + Group.compressCollecton(this.members, KingdomsObject::compressUUID) + Group.compressCollecton(this.metadata.values(), Object::hashCode) + Group.compressCollecton(this.mails, Object::hashCode) + this.compressMetadata();
    }

    @Override
    public @NonNull UUID getDataKey() {
        return this.id;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public GroupHiddenStateChangeEvent setHidden(boolean hidden, @Nullable KingdomPlayer player) {
        GroupHiddenStateChangeEvent event = new GroupHiddenStateChangeEvent(this, hidden, player);
        if (this.hidden == hidden) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.hidden = hidden;
        }
        return event;
    }

    public @Nullable String getFlag() {
        return this.flag;
    }

    public GroupFlagChangeEvent setFlag(@Nullable String flag, KingdomPlayer player) {
        GroupFlagChangeEvent event = new GroupFlagChangeEvent(this, flag, player);
        if (Objects.equals(this.flag, flag)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.flag = event.getNewFlag();
        return event;
    }

    public Color getColor() {
        return this.color;
    }

    public GroupColorChangeEvent setColor(Color color, KingdomPlayer player) {
        GroupColorChangeEvent event = new GroupColorChangeEvent(this, color, player);
        if (Objects.equals(this.color, color)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.color = event.getNewColor();
        return event;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.id + '|' + this.name + ']';
    }

    public double getBank() {
        return this.bank;
    }

    public void setBank(double bank) {
        this.bank = bank;
    }

    public @Nullable String getTax() {
        return this.tax;
    }

    public void setTax(@Nullable String tax) {
        this.tax = tax;
    }

    public abstract double getMight();

    public boolean hasMoney(double amount) {
        return this.bank >= amount;
    }

    public boolean hasResourcePoints(long amount) {
        return this.resourcePoints >= amount;
    }

    public @NonNull UUID getId() {
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    protected void setName(@NonNull String name) {
        Validate.notEmpty(name, "Group name cannot be null or empty");
        this.name = name;
    }

    public long getResourcePoints() {
        return this.resourcePoints;
    }

    public void setResourcePoints(long resourcePoints) {
        this.resourcePoints = resourcePoints;
    }

    public @Nullable SimpleLocation getNexus() {
        return this.nexus;
    }

    public void setNexus(@Nullable SimpleLocation nexus) {
        this.nexus = nexus;
    }

    public @Nullable Location getHome() {
        return this.home;
    }

    public boolean hasAttribute(@Nullable Group other, RelationAttribute attribute) {
        return attribute.hasAttribute(this, other);
    }

    public @NonNull Map<UUID, KingdomRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(@NonNull Map<UUID, KingdomRelation> relations) {
        this.relations = relations;
    }

    public @NonNull RankMap getRanks() {
        return this.ranks;
    }

    public void setRanks(@NonNull RankMap ranks) {
        this.ranks = Objects.requireNonNull(ranks, "Ranks cannot be null");
    }

    public abstract @NonNull GroupRenameEvent rename(@NonNull String var1, @Nullable KingdomPlayer var2);

    public @NonNull Map<UUID, KingdomRelationshipRequest> getRelationshipRequests() {
        return this.relationshipRequests;
    }

    public void setRelationshipRequests(@NonNull Map<UUID, KingdomRelationshipRequest> relationshipRequests) {
        this.relationshipRequests = Objects.requireNonNull(relationshipRequests, "Group relationship requests cannot be null");
    }

    public void addResourcePoints(long amount) {
        this.resourcePoints += amount;
    }

    public void activateShield(long time) {
        this.activateShield(time, false);
    }

    public UUID getOwnerId() {
        return this.owner;
    }

    public void activateShield(long time, boolean reset) {
        if (this.getShieldTimeLeft() <= 0L) {
            this.shieldSince = System.currentTimeMillis();
            this.shieldTime = time;
        } else {
            this.shieldTime = reset ? time : (this.shieldTime += time);
        }
    }

    public void deactivateShield() {
        this.shieldTime = 0L;
    }

    public boolean isMember(@NonNull UUID id) {
        return this.members.contains(id);
    }

    public @NonNull Set<UUID> getMembers() {
        return this.members;
    }

    public @NonNull Pair<Long, List<ItemStack>> addToResourcePoints(@NonNull Collection<ItemStack> donations, @Nullable BiFunction<ItemStack, List<ItemStack>, Long> function) {
        Pair<Long, List<ItemStack>> pair = ResourcePointManager.convertToResourcePoints(donations, function);
        this.resourcePoints += pair.getKey().longValue();
        return pair;
    }

    public double addBank(double amount) {
        return this.bank += amount;
    }

    public final boolean isFull() {
        return this.members.size() >= this.getMaxMembers();
    }

    public long getShieldTimeLeft() {
        long current = System.currentTimeMillis();
        long diff = current - this.shieldSince;
        return Math.max(0L, this.shieldTime - diff);
    }

    public int countRelationships(KingdomRelation relation) {
        int count = 0;
        for (KingdomRelation rel : this.relations.values()) {
            if (rel != relation) continue;
            ++count;
        }
        return count;
    }

    public void setRelationShipWith(Group other, @Nullable KingdomRelation relation) {
        Objects.requireNonNull(other);
        if (relation == KingdomRelation.SELF) {
            throw new IllegalArgumentException("SELF relationship is not allowed");
        }
        if (relation == null || relation == KingdomRelation.NEUTRAL) {
            this.relations.remove(other.id);
            other.relations.remove(this.id);
        } else {
            this.relations.put(other.id, relation);
            other.relations.put(this.id, relation);
        }
    }

    public boolean hasShield() {
        return this.getShieldTimeLeft() > 0L;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public long getShieldTime() {
        return this.shieldTime;
    }

    public void setShieldTime(long shieldTime) {
        this.shieldTime = shieldTime;
    }

    public long getShieldSince() {
        return this.shieldSince;
    }

    public void setShieldSince(long shieldSince) {
        this.shieldSince = shieldSince;
    }

    public boolean requiresInvite() {
        return this.requiresInvite;
    }

    public void setRequiresInvite(boolean requiresInvite) {
        this.requiresInvite = requiresInvite;
    }

    public long getSince() {
        return this.since;
    }

    public void setSince(long since) {
        this.since = since;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Group)) {
            return false;
        }
        Group group = (Group)obj;
        return this.id.equals(group.id);
    }

    public @NonNull Map<KingdomRelation, Set<RelationAttribute>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@NonNull Map<KingdomRelation, Set<RelationAttribute>> attributes) {
        this.attributes = Objects.requireNonNull(attributes, "Group relation attributes cannot be null");
    }

    public @Nullable String getTag() {
        return this.tag;
    }

    public void setTag(@Nullable String tag) {
        this.tag = tag;
    }

    public GroupRenameTagEvent renameTag(@Nullable String tag, @Nullable KingdomPlayer by) {
        GroupRenameTagEvent event = new GroupRenameTagEvent(this, tag, by);
        if (Objects.equals(this.tag, tag)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.tag = tag;
        return event;
    }

    public abstract GroupDisband triggerDisbandEvent(GroupDisband.Reason var1);

    public abstract GroupDisband disband(GroupDisband.Reason var1);

    public abstract double calculateTax();

    public abstract int getMaxMembers();

    public boolean isHomePublic() {
        return this.publicHome;
    }

    public void setPublicHome(boolean publicHome) {
        this.publicHome = publicHome;
    }

    public abstract @NonNull List<OfflinePlayer> getPlayerMembers();

    public abstract @NonNull List<Player> getOnlineMembers();

    public abstract @NonNull List<KingdomPlayer> getKingdomPlayers();

    public abstract void updateRankNode(@NonNull String var1, @NonNull String var2);

    public @NonNull Map<UUID, Mail> getMails() {
        LinkedHashMap<UUID, Mail> mappedMails = new LinkedHashMap<UUID, Mail>(this.mails.size());
        Iterator<UUID> iterator = this.mails.iterator();
        while (iterator.hasNext()) {
            UUID mailId = iterator.next();
            Mail mail = Mail.getMail(mailId);
            if (mail == null) {
                iterator.remove();
                continue;
            }
            mappedMails.put(mailId, mail);
        }
        return Collections.unmodifiableMap(mappedMails);
    }

    public @NonNull LinkedList<AuditLog> getLogs() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLogsExpirationCheck < Duration.ofHours(1L).toMillis()) {
            return this.logs;
        }
        long defaultExpiration = KingdomsConfig.AUDIT_LOGS_EXPIRATION_DEFAULT.getTimeMillis();
        YamlConfigAccessor specifics = KingdomsConfig.AUDIT_LOGS_EXPIRATION.getManager().getSection().noDefault();
        Iterator iter = this.logs.iterator();
        while (iter.hasNext()) {
            long time;
            long diff;
            AuditLog log = (AuditLog)iter.next();
            Long expirationTime = specifics.getTimeMillis(log.getProvider().getNamespace().getConfigOptionName());
            if (expirationTime == null) {
                expirationTime = defaultExpiration;
            }
            if ((diff = currentTime - (time = log.getTime())) < expirationTime) continue;
            iter.remove();
        }
        this.lastLogsExpirationCheck = currentTime;
        return this.logs;
    }

    public <C extends AuditLog, T> T getNewestLog(Class<C> base, Function<C, T> transformer) {
        Iterator<AuditLog> descending = this.logs.descendingIterator();
        while (descending.hasNext()) {
            T result;
            AuditLog next = descending.next();
            if (!base.isInstance(next) || (result = transformer.apply(next)) != null) continue;
            return result;
        }
        return null;
    }
}

