/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group;

import java.awt.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.kingdoms.abstraction.ImmutableLocation;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.abstraction.NationOperator;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.group.model.InviteCode;
import org.kingdoms.constants.group.model.KingdomRequest;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.upgradable.KingdomUpgrade;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.group.upgradable.champion.ChampionUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.Pair;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.GroupRelationshipRequestEvent;
import org.kingdoms.events.general.GroupRenameEvent;
import org.kingdoms.events.general.KingdomCreateEvent;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.events.general.KingdomLoreChangeEvent;
import org.kingdoms.events.general.KingdomSetHomeEvent;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.events.members.NationJoinEvent;
import org.kingdoms.events.members.NationLeaveEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XEntity;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.services.ServiceMythicMobs;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.ConditionProcessor;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.FastUUID;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeUtils;

public class Kingdom
extends Group
implements KingdomOperator,
NationOperator {
    private final @NonNull Set<SimpleChunkLocation> lands;
    private @NonNull Map<UUID, KingdomInvite> nationInvites;
    private @NonNull Map<MiscUpgrade, Integer> miscUpgrades;
    private @NonNull Map<Powerup, Integer> powerups;
    private @NonNull Map<ChampionUpgrade, Integer> championUpgrades;
    private @NonNull Map<String, InviteCode> inviteCodes;
    private @NonNull Map<UUID, Long> challenges;
    private @NonNull Inventory nexusChest;
    private @NonNull String championType;
    private @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String lore;
    private boolean pacifist;
    private @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID nation;
    private long lastInvasion;
    private int maxLandsModifier;

    public Kingdom(@NonNull UUID id, @NonNull Map<UUID, KingdomRelationshipRequest> relationshipRequests, @NonNull Set<UUID> mails, @NonNull Map<UUID, Long> challenges, @NonNull Map<String, InviteCode> inviteCodes, @NonNull LinkedList<AuditLog> logs, @NonNull Map<MiscUpgrade, Integer> miscUpgrades, @NonNull Map<Powerup, Integer> powerups, @NonNull Map<ChampionUpgrade, Integer> championUpgrades, @NonNull Set<SimpleChunkLocation> lands, @NonNull RankMap ranks, @NonNull Map<UUID, KingdomRelation> relations, @NonNull Set<UUID> members, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String lore, @NonNull String championType2, boolean pacifist, @NonNull UUID king, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID nation, @NonNull String name, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String tag, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String tax, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable SimpleLocation nexus, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Location home, @NonNull Map<String, BookChapter> book, Map<Integer, ItemStack> nexusChest, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String flag, Color color, long resourcePoints, int maxLandsModifier, double bank, long lastInvasion, long since, boolean publicHome, boolean permanent, boolean requiresInvite, long shieldTime, long shieldSince, @NonNull Map<KingdomRelation, Set<RelationAttribute>> attributes) {
        super(id, king, name, tag, tax, ranks, resourcePoints, since, bank, publicHome, permanent, requiresInvite, shieldSince, shieldTime, nexus, home, flag, color, members, book, relations, relationshipRequests, attributes, mails, logs);
        this.miscUpgrades = Objects.requireNonNull(miscUpgrades, "Misc upgrades cannot be null");
        this.powerups = Objects.requireNonNull(powerups, "Powerups cannot be null");
        this.championUpgrades = Objects.requireNonNull(championUpgrades, "Champions upgrade cannot be null");
        this.lands = Objects.requireNonNull(lands, "Lands cannot be null");
        this.lore = lore;
        this.nation = nation;
        this.pacifist = pacifist;
        this.nationInvites = new HashMap<UUID, KingdomInvite>();
        this.inviteCodes = inviteCodes;
        this.challenges = challenges;
        this.championType = championType2;
        this.maxLandsModifier = maxLandsModifier;
        this.lastInvasion = lastInvasion;
        Inventory chest = Bukkit.createInventory(null, (int)(this.validateChestSize() * 9));
        for (Map.Entry<Integer, ItemStack> items : nexusChest.entrySet()) {
            chest.setItem(items.getKey().intValue(), items.getValue());
        }
        this.nexusChest = chest;
    }

    private int validateChestSize() {
        int chestLvl = Math.abs(this.getUpgradeLevel(MiscUpgrade.CHEST_SIZE));
        if (chestLvl > 5) {
            KLogger.error("Chest level of kingdom " + this.name + " is " + chestLvl + ". Chest levels cannot be greater than 5");
            this.miscUpgrades.put(MiscUpgrade.CHEST_SIZE, 5);
            return 6;
        }
        return chestLvl + 1;
    }

    public InviteCode generateInviteCode(Duration expiration, UUID creator, int uses) {
        String code;
        int minLen = KingdomsConfig.INVITATIONS_CODES_GENERATOR_LENGTH_MIN.getManager().getInt();
        int maxLen = KingdomsConfig.INVITATIONS_CODES_GENERATOR_LENGTH_MAX.getManager().getInt();
        String chars = KingdomsConfig.INVITATIONS_CODES_GENERATOR_CHARACTERS.getManager().getString();
        while (this.inviteCodes.containsKey(code = StringUtils.random(minLen, maxLen, chars))) {
        }
        return new InviteCode(code, System.currentTimeMillis(), expiration.toMillis() == 0L ? 0L : TimeUtils.afterNow(expiration), creator, new HashSet<UUID>(), uses);
    }

    public Kingdom(@NonNull UUID king, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String name) {
        super(king, name);
        this.pacifist = KingdomsConfig.Invasions.PACIFISM_DEFAULT.getManager().getBoolean();
        this.championType = KingdomsConfig.ChampionUpgrades.CHAMPIONS_DEFAULT.getManager().getString();
        this.nexusChest = Bukkit.createInventory(null, (int)9);
        this.inviteCodes = new HashMap<String, InviteCode>();
        this.lands = new HashSet<SimpleChunkLocation>();
        this.nationInvites = new HashMap<UUID, KingdomInvite>();
        this.challenges = new HashMap<UUID, Long>();
        this.powerups = KingdomUpgrade.getDefaults((Enum[])Powerup.VALUES);
        this.miscUpgrades = KingdomUpgrade.getDefaults((Enum[])MiscUpgrade.VALUES);
        this.championUpgrades = KingdomUpgrade.getDefaults((Enum[])ChampionUpgrade.VALUES);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(king);
        kp.joinKingdom(this);
        kp.setRankInternal(this.ranks.getHighestRank().getNode());
        KingdomCreateEvent event = new KingdomCreateEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
        KingdomsDataCenter.get().getKingdomManager().load(this);
    }

    public static @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom getKingdom(@NonNull String name) {
        Validate.notEmpty(name, "Kingdom name cannot be null or empty");
        return KingdomsDataCenter.get().getKingdomManager().getData(name);
    }

    public static @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom getKingdom(@NonNull UUID id) {
        Objects.requireNonNull(id, "Kingdom ID cannot be null");
        return (Kingdom)KingdomsDataCenter.get().getKingdomManager().getData(id);
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    @Override
    public int getMaxMembers() {
        return (int)(MathUtils.eval(KingdomsConfig.MAX_MEMBERS_KINGDOMS.getString(), this, new Object[0]) + MiscUpgrade.MAX_MEMBERS.getScaling(this));
    }

    @Override
    public NexusMoveEvent placeOrMoveNexus(@NonNull Location toLocation, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer kp) {
        return this.abstractPlaceOrMoveNexus("nexus", toLocation, kp);
    }

    public int getMaxClaims() {
        return this.getMaxClaims("default");
    }

    public int getMaxClaims(String world) {
        String maxClaimsEqn = Objects.requireNonNull(KingdomsConfig.Claims.MAX_CLAIMS.getManager().forWorld(world).getString(), "Max claims equation not found");
        int max = (int)MathUtils.eval(maxClaimsEqn, this, "max_claims", MiscUpgrade.MAX_CLAIMS.getScaling(this));
        if (max < 0) {
            throw new IllegalStateException("Max claims has evaluated to a negative number " + max + " for '" + this.name + "' kingdom.");
        }
        return max;
    }

    public void updateChest() {
        HumanEntity[] viewers;
        for (HumanEntity player : viewers = this.nexusChest.getViewers().toArray(new HumanEntity[0])) {
            player.closeInventory();
        }
        Inventory chest = Bukkit.createInventory(null, (int)(this.validateChestSize() * 9));
        for (int i = 0; i < this.nexusChest.getSize(); ++i) {
            ItemStack item = this.nexusChest.getItem(i);
            chest.setItem(i, item);
        }
        this.nexusChest = chest;
        for (HumanEntity player : viewers) {
            player.openInventory(chest);
        }
    }

    public boolean isMember(@NonNull KingdomPlayer kp) {
        return this.isMember(kp.getId());
    }

    public boolean isMember(@NonNull OfflinePlayer player) {
        return this.isMember(player.getUniqueId());
    }

    public boolean isClaimed(@NonNull SimpleChunkLocation location) {
        return this.lands.contains(location);
    }

    public List<Kingdom> getKingdomsWithRelation(KingdomRelation ... relation) {
        Objects.requireNonNull(relation, "Cannot get kingdoms with null relation");
        if (relation.length == 0) {
            return new ArrayList<Kingdom>();
        }
        ArrayList<Kingdom> kingdoms = new ArrayList<Kingdom>(this.relations.size());
        for (Map.Entry rel : this.relations.entrySet()) {
            if (!Arrays.stream(relation).anyMatch(x -> x == rel.getValue())) continue;
            Kingdom kingdom = Kingdom.getKingdom((UUID)rel.getKey());
            if (kingdom == null) {
                MessageHandler.sendConsolePluginMessage("&4Unknown relation with a kingdom with a UUID &e" + rel.getKey() + " &4for kingdom &e" + this.name + " &8(&e" + this.id + "&8)");
            }
            kingdoms.add(kingdom);
        }
        return kingdoms;
    }

    public @NonNull Map<String, InviteCode> getInviteCodes() {
        this.inviteCodes.values().removeIf(InviteCode::hasExpired);
        return this.inviteCodes;
    }

    public void setInviteCodes(@NonNull Map<String, InviteCode> inviteCodes) {
        this.inviteCodes = inviteCodes;
    }

    public int countStructures(Predicate<Structure> filter) {
        int count = 0;
        for (Land land : this.getLands()) {
            for (Structure struct : land.getStructures().values()) {
                if (filter != null && !filter.test(struct)) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Structure> getAllStructures() {
        ArrayList<Structure> structures = new ArrayList<Structure>(this.lands.size());
        for (Land land : this.getLands()) {
            structures.addAll(land.getStructures().values());
        }
        return structures;
    }

    public GroupRelationshipRequestEvent sendRelationshipRequest(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer sender, @NonNull Kingdom kingdom, @NonNull KingdomRelation relation, long acceptTime) {
        Objects.requireNonNull(kingdom, "Cannot send relationship request to null kingdom");
        Objects.requireNonNull(relation, "Cannot have null relations");
        GroupRelationshipRequestEvent event = new GroupRelationshipRequestEvent(this, kingdom, relation, sender);
        if (this.getRelationWith(kingdom) == relation) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        KingdomRelationshipRequest request = new KingdomRelationshipRequest(relation, sender == null ? null : sender.getId(), acceptTime);
        kingdom.relationshipRequests.put(this.id, request);
        return event;
    }

    public GroupRelationshipRequestEvent sendRelationshipRequest(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer sender, @NonNull Kingdom kingdom, @NonNull KingdomRelation relation) {
        return this.sendRelationshipRequest(sender, kingdom, relation, KingdomsConfig.Relations.REQUEST_EXPIRATION.getManager().getTimeMillis());
    }

    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID getKingId() {
        return this.owner;
    }

    @Override
    public @NonNull List<KingdomPlayer> getKingdomPlayers() {
        ArrayList<KingdomPlayer> players = new ArrayList<KingdomPlayer>(this.members.size());
        for (UUID id : this.members) {
            players.add(KingdomPlayer.getKingdomPlayer(id));
        }
        return players;
    }

    public @NonNull List<Land> getLands() {
        ArrayList<SimpleChunkLocation> corrupted = new ArrayList<SimpleChunkLocation>();
        ArrayList<Land> lands = new ArrayList<Land>(this.lands.size());
        for (SimpleChunkLocation loc : this.lands) {
            Land land = loc.getLand();
            if (land == null || !this.id.equals(land.getKingdomId())) {
                MessageHandler.sendConsolePluginMessage("&cDetected unknown land at " + loc + " in kingdom " + this.name + " (" + this.id + ") Removing now...");
                corrupted.add(loc);
                continue;
            }
            lands.add(land);
        }
        if (!corrupted.isEmpty()) {
            this.lands.removeAll(corrupted);
        }
        return lands;
    }

    public @NonNull ClaimLandEvent claim(@NonNull SimpleChunkLocation loc, @NonNull KingdomPlayer claimer, ClaimLandEvent.Reason reason) {
        return this.claim(Collections.singleton(loc), claimer, reason, true);
    }

    public @NonNull ClaimLandEvent claim(@NonNull Set<SimpleChunkLocation> locations, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer claimer, @NonNull ClaimLandEvent.Reason reason, boolean history) {
        Objects.requireNonNull(locations, "Cannot claim null location");
        Objects.requireNonNull(reason, "Claiming reason cannot be null");
        if (locations.isEmpty()) {
            throw new IllegalArgumentException("Claim lands list is empty");
        }
        ClaimLandEvent event = new ClaimLandEvent(claimer, this, locations, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        locations = event.getLandLocations();
        for (SimpleChunkLocation loc : locations) {
            Land land = Land.getLand(loc);
            if (land != null) {
                Validate.isTrue(!land.isClaimed(), "Land already claimed at: " + loc + " while attempting to claim for " + this.name + " (" + this.id + ')');
            } else {
                land = new Land(this, loc);
            }
            land.setKingdom(this.id);
            if (claimer != null) {
                land.setClaimedBy(claimer.getId());
            }
            land.setSince(System.currentTimeMillis());
            this.lands.add(loc);
        }
        if (claimer != null) {
            claimer.processLands(locations, true, history);
        }
        return event;
    }

    public @NonNull UnclaimLandEvent unclaim(@NonNull Set<SimpleChunkLocation> lands, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer by, @NonNull UnclaimLandEvent.Reason reason, boolean history) {
        if (lands.isEmpty()) {
            throw new IllegalArgumentException("Unclaim lands list is empty");
        }
        UnclaimLandEvent event = new UnclaimLandEvent(by, this, lands, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        lands = event.getLandLocations();
        if (by != null) {
            by.processLands(lands, false, history);
        }
        for (SimpleChunkLocation location : lands) {
            Land land;
            if (!this.lands.remove(location)) {
                throw new IllegalArgumentException("This kingdom didn't claim: " + location);
            }
            if (KingdomsConfig.HOME_CLAIMED.getBoolean()) {
                Nation nation;
                if (this.home != null && SimpleChunkLocation.of(this.home).equals(location)) {
                    this.setHome(null, by);
                }
                if ((nation = this.getNation()) != null) {
                    this.home = ImmutableLocation.of(nation.getHome());
                    if (this.home != null && SimpleChunkLocation.of(this.home).equals(location)) {
                        nation.setHome(by, null);
                    }
                }
            }
            if ((land = Objects.requireNonNull(location.getLand(), () -> "for land " + location + " kingdom " + this.name)).getClaimedBy() != null) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(land.getClaimedBy());
                kp.getClaims().remove(location);
            }
            land.silentUnclaim();
        }
        return event;
    }

    @Nonnull
    public UnclaimLandEvent unclaimIf(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer by, UnclaimLandEvent.Reason reason, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Predicate<Land> filter) {
        Objects.requireNonNull(reason, "Unclaim reason cannot be null");
        HashSet<SimpleChunkLocation> unclaimed = new HashSet<SimpleChunkLocation>();
        for (Land land : this.getLands()) {
            if (filter != null && !filter.test(land)) continue;
            unclaimed.add(land.getLocation());
        }
        return this.unclaim(unclaimed, by, reason, true);
    }

    public @NonNull Set<SimpleChunkLocation> getLandLocations() {
        return Collections.unmodifiableSet(this.lands);
    }

    @Override
    public @NonNull List<Player> getOnlineMembers() {
        ArrayList<Player> players = new ArrayList<Player>(this.members.size());
        for (UUID member : this.members) {
            Player player = Bukkit.getPlayer((UUID)member);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    @Override
    public @NonNull List<OfflinePlayer> getPlayerMembers() {
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>(this.members.size());
        for (UUID member : this.members) {
            players.add(Bukkit.getOfflinePlayer((UUID)member));
        }
        return players;
    }

    @Override
    public GroupRenameEvent rename(@NonNull String name, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer renamer) {
        Validate.notEmpty(name, "Cannot rename kingdom to null or empty name");
        GroupRenameEvent event = new GroupRenameEvent(this, name, renamer);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        KingdomsDataCenter.get().getKingdomManager().renameKingdom(this, name);
        this.setName(name);
        return event;
    }

    public @NonNull KingdomRelation getRelationWith(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom kingdom) {
        if (kingdom == null) {
            return KingdomRelation.NEUTRAL;
        }
        if (this.id.equals(kingdom.id)) {
            return KingdomRelation.SELF;
        }
        if (this.nation != null && this.nation.equals(kingdom.nation)) {
            KingdomRelation relation;
            if (KingdomsConfig.Relations.PRIORITIZE_KINGDOM_RELATIONS.getManager().getBoolean() && (relation = (KingdomRelation)((Object)this.relations.get(kingdom.id))) != null) {
                return relation;
            }
            return KingdomRelation.NATION;
        }
        KingdomRelation relation = (KingdomRelation)((Object)this.relations.get(kingdom.id));
        return relation == null ? KingdomRelation.NEUTRAL : relation;
    }

    @Override
    public KingdomDisbandEvent triggerDisbandEvent(GroupDisband.Reason reason) {
        KingdomDisbandEvent event = new KingdomDisbandEvent(this, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Override
    public KingdomDisbandEvent disband(GroupDisband.Reason reason) {
        KingdomDisbandEvent event = null;
        if (reason != null && (event = this.triggerDisbandEvent(reason)).isCancelled()) {
            return event;
        }
        Nation nation = this.getNation();
        if (nation != null) {
            if (nation.getCapitalId().equals(this.id)) {
                nation.disband(reason);
            } else {
                nation.getMembers().remove(this.id);
            }
        }
        for (UUID uUID : this.members) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(uUID);
            kp.silentlyLeaveKingdom();
        }
        this.members.clear();
        for (SimpleChunkLocation simpleChunkLocation : this.lands) {
            Land land = simpleChunkLocation.getLand();
            if (land == null) continue;
            land.silentUnclaim();
        }
        this.lands.clear();
        for (Map.Entry entry : this.relations.entrySet()) {
            Kingdom rel = Kingdom.getKingdom((UUID)entry.getKey());
            if (rel == null) continue;
            rel.relations.remove(this.id);
        }
        KingdomManager manager = KingdomsDataCenter.get().getKingdomManager();
        manager.remove(this);
        manager.delete(this.id);
        return event;
    }

    public boolean hasAttribute(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom kingdom, RelationAttribute attribute) {
        return attribute.hasAttribute(this, kingdom);
    }

    public @NonNull KingdomPlayer getKing() {
        return KingdomPlayer.getKingdomPlayer(this.owner);
    }

    public KingdomKingChangeEvent setKing(@NonNull KingdomPlayer newKing, @NonNull KingdomKingChangeEvent.Reason reason) {
        Objects.requireNonNull(reason);
        Objects.requireNonNull(newKing, "Cannot set a null player as a king");
        KingdomKingChangeEvent event = new KingdomKingChangeEvent(this, newKing, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        newKing = event.getNewKing();
        KingdomPlayer king = KingdomPlayer.getKingdomPlayer(this.owner);
        king.demote(null);
        newKing.setRank(null, this.ranks.getHighestRank());
        this.owner = newKing.getId();
        return event;
    }

    public @NonNull List<Land> getLandsUnderAttack() {
        List<Land> lands = this.getLands();
        Iterator<Land> iterator = lands.iterator();
        while (iterator.hasNext()) {
            Land land = iterator.next();
            if (land.isBeingInvaded()) continue;
            iterator.remove();
        }
        return lands;
    }

    public boolean isBeingInvaded() {
        for (SimpleChunkLocation location : this.lands) {
            Land land = location.getLand();
            if (!land.isBeingInvaded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateRankNode(@NonNull String node, @NonNull String newNode) {
        this.ranks.updateNode(node, newNode);
        for (KingdomPlayer kp : this.getKingdomPlayers()) {
            if (!node.equals(kp.getRankNode())) continue;
            kp.setRankInternal(newNode);
        }
    }

    public @NonNull Map<KingdomPlayer, Invasion> getInvasions() {
        HashMap<KingdomPlayer, Invasion> invadingLands = new HashMap<KingdomPlayer, Invasion>();
        for (KingdomPlayer member : this.getKingdomPlayers()) {
            Invasion invading = member.getInvasion();
            if (invading == null) continue;
            invadingLands.put(member, invading);
        }
        return invadingLands;
    }

    public boolean isInvading() {
        for (UUID id : this.members) {
            if (!KingdomPlayer.getKingdomPlayer(id).isInvading()) continue;
            return true;
        }
        return false;
    }

    public NationLeaveEvent leaveNation(LeaveReason reason) {
        Nation nation = this.getNation();
        Objects.requireNonNull(nation, "Kingdom is not in a nation to leave");
        NationLeaveEvent event = new NationLeaveEvent(this, nation, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        nation.getMembers().remove(this.id);
        this.nation = null;
        return event;
    }

    @Override
    public @NonNull String getCompressedData() {
        return super.getCompressedData() + Kingdom.compressString(this.lore) + Kingdom.compressString(this.championType) + Kingdom.compressUUID(this.nation) + this.maxLandsModifier + this.lastInvasion + Kingdom.compressBoolean(this.pacifist) + Kingdom.compressCollecton(this.miscUpgrades.values(), Object::toString) + Kingdom.compressCollecton(this.championUpgrades.values(), Object::toString) + Kingdom.compressCollecton(this.powerups.values(), Object::toString) + Kingdom.compressMap(this.challenges, 0, UUID::hashCode, Object::toString) + Kingdom.compressInventory(this.nexusChest) + Kingdom.compressMap(this.nationInvites, this.nationInvites.size(), KingdomsObject::compressUUID, KingdomRequest::hashCode) + Kingdom.compressCollecton(this.lands, SimpleChunkLocation::getCompressedData) + Kingdom.compressCollecton(this.inviteCodes.values(), x -> x.getCode() + x.getUses() + x.getUsedBy().hashCode() + x.getCreatedAt() + x.getExpiration() + x.getCreatedBy());
    }

    @Override
    public String toString() {
        return "Kingdom[ID: " + this.id + ", Name: " + this.name + ']';
    }

    public boolean isUnderAttack() {
        return this.getLands().stream().anyMatch(Land::isBeingInvaded);
    }

    public @NonNull KingdomSetHomeEvent setHome(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Location home, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer player) {
        KingdomSetHomeEvent event = new KingdomSetHomeEvent(this, home, player);
        if (Objects.equals(this.home, home)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.home = ImmutableLocation.of(event.getNewLocation());
        }
        return event;
    }

    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String getLore() {
        return this.lore;
    }

    public KingdomLoreChangeEvent setLore(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String lore, KingdomPlayer by) {
        KingdomLoreChangeEvent event = new KingdomLoreChangeEvent(this, lore, by);
        if (Objects.equals(this.lore, lore)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.lore = event.getNewLore();
        return event;
    }

    public boolean isPacifist() {
        return this.pacifist;
    }

    public void setPacifist(boolean pacifist) {
        this.pacifist = pacifist;
    }

    public @NonNull Map<MiscUpgrade, Integer> getMiscUpgrades() {
        return this.miscUpgrades;
    }

    public void setMiscUpgrades(@NonNull Map<MiscUpgrade, Integer> miscUpgrades) {
        this.miscUpgrades = Objects.requireNonNull(miscUpgrades, "Misc upgrades cannot be null");
    }

    public @NonNull Map<Powerup, Integer> getPowerups() {
        return this.powerups;
    }

    public void setPowerups(Map<Powerup, Integer> powerups) {
        Objects.requireNonNull(powerups, "Powerups cannot be null");
        this.powerups = powerups;
    }

    public @NonNull Map<ChampionUpgrade, Integer> getChampionUpgrades() {
        return this.championUpgrades;
    }

    public void setChampionUpgrades(@NonNull Map<ChampionUpgrade, Integer> championUpgrades) {
        this.championUpgrades = Objects.requireNonNull(championUpgrades, "Champion upgrades cannot be null");
    }

    public int getUpgradeLevel(@NonNull KingdomUpgrade upgrade) {
        if (upgrade instanceof ChampionUpgrade) {
            return this.championUpgrades.getOrDefault(upgrade, 0);
        }
        if (upgrade instanceof MiscUpgrade) {
            return this.miscUpgrades.getOrDefault(upgrade, 0);
        }
        if (upgrade instanceof Powerup) {
            return this.powerups.getOrDefault(upgrade, 0);
        }
        throw new IllegalArgumentException("Unknown upgrade type: " + upgrade);
    }

    public long getUpgradeCost(@NonNull KingdomUpgrade upgrade) {
        return (long)upgrade.getUpgradeCost(new PlaceholderContextBuilder().withContext(this).raw("lvl", this.getUpgradeLevel(upgrade)));
    }

    public void setUpgradeLevel(@NonNull KingdomUpgrade upgrade, int newLevel) {
        Objects.requireNonNull(upgrade, "Cannot upgrade null upgrade type");
        if (upgrade instanceof ChampionUpgrade) {
            this.championUpgrades.put((ChampionUpgrade)upgrade, newLevel);
            return;
        }
        if (upgrade instanceof MiscUpgrade) {
            this.miscUpgrades.put((MiscUpgrade)upgrade, newLevel);
            return;
        }
        if (upgrade instanceof Powerup) {
            this.powerups.put((Powerup)upgrade, newLevel);
            return;
        }
        throw new UnsupportedOperationException("Unknown kingdom upgrade: " + upgrade + " (" + upgrade.getClass().getName() + ')');
    }

    public boolean isStrongerThan(Kingdom other) {
        return ConditionProcessor.process(KingdomsConfig.Invasions.STRENGTH_COMPARISON.getManager().getCondition(), new PlaceholderContextBuilder().withContext(this).other(other));
    }

    public ConfigAccessor findChampionSection() {
        ConfigAccessor config = Objects.requireNonNull(KingdomsConfig.CHAMPION_UPGRADES.accessor().noDefault().gotoSection("champions"), "'champions' section not found in champion-upgrades.yml");
        ConfigAccessor championConfig = config.gotoSection(this.championType);
        if (championConfig == null) {
            String defaultType = config.getString("default");
            KLogger.debug((DebugNS)KingdomsDebug.CHAMPION_UNKNOWN$TYPES, () -> "Couldn't find default champion type '" + this.championType + "' for kingdom " + this.getName() + " reverting back to '" + defaultType + '\'');
            this.setChampionType(defaultType);
            championConfig = Objects.requireNonNull(config.gotoSection(defaultType), () -> "The default champion type not found in champion-upgrades.yml: " + defaultType);
        }
        return championConfig;
    }

    public @NonNull Creature spawnChampion(@NonNull Location location) {
        Objects.requireNonNull(location, "Cannot spawn champion at null location");
        ConfigSection section = this.findChampionSection().getSection();
        ConfigSection basedSection = section.getSection("base");
        String mm = basedSection.getString("mythicmob");
        int lvl = this.getUpgradeLevel(ChampionUpgrade.EQUIPMENT);
        boolean isCustom = mm != null;
        Creature champion = isCustom && SoftService.MYTHIC_MOBS.isAvailable() ? (Creature)((ServiceMythicMobs)SoftService.MYTHIC_MOBS.getService()).spawnMythicMob(location, mm, lvl) : (Creature)XEntity.spawn(location, basedSection.toBukkitConfigurationSection());
        champion.setCustomName(MessageCompiler.compile(basedSection.getString("name")).buildPlain(new MessageBuilder().withContext(this)));
        if (!isCustom) {
            int speed;
            ConfigSection lvlSection;
            if (lvl > 0 && (lvlSection = section.getSection("levels", String.valueOf(lvl)).getSection(new String[0])) != null) {
                XEntity.edit((Entity)champion, lvlSection.toBukkitConfigurationSection());
            }
            double hp = ChampionUpgrade.HEALTH.getScaling(this);
            champion.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(hp);
            champion.setHealth(hp);
            int strength = this.getUpgradeLevel(ChampionUpgrade.STRENGTH);
            if (strength > 0) {
                champion.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 2000, strength));
            }
            if ((speed = this.getUpgradeLevel(ChampionUpgrade.SPEED)) > 0) {
                champion.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, (int)ChampionUpgrade.SPEED.getScaling(this) - 1));
            }
        }
        KLogger.debug((DebugNS)KingdomsDebug.CHAMPION_SPAWN, () -> "Spawning champion for " + this.name + " kingdom: MM=" + mm + ", level=" + lvl + ", type=" + this.championType);
        return champion;
    }

    public @NonNull Inventory getNexusChest() {
        return this.nexusChest;
    }

    public void setNexusChest(@NonNull Inventory nexusChest) {
        this.nexusChest = nexusChest;
    }

    public long getLastInvasion() {
        return this.lastInvasion;
    }

    public void setLastInvasion(long lastInvasion) {
        this.lastInvasion = lastInvasion;
    }

    @Override
    public double getMight() {
        return MathUtils.eval(KingdomsConfig.TOP_KINGDOMS_MIGHT.getString(), this, new Object[0]);
    }

    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID getNationId() {
        return this.nation;
    }

    @Override
    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Nation getNation() {
        if (this.nation == null) {
            return null;
        }
        Nation nation = Nation.getNation(this.nation);
        if (nation == null) {
            MessageHandler.sendConsolePluginMessage("&4Invalid nation data for &e" + this.name + " (" + this.id + ") &4kingdom. Removing data...");
            this.nation = null;
            return null;
        }
        return nation;
    }

    public void setNation(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID nation) {
        this.nation = nation;
    }

    @Override
    public @NonNull String getTaxOrDefault() {
        return this.tax == null ? KingdomsConfig.TAX_KINGDOMS_MEMBERS_DEFAULT_EQUATION.getString() : this.tax;
    }

    @Override
    public double calculateTax() {
        String taxEquation = KingdomsConfig.TAX_KINGDOMS_SCALING.getString();
        double pacifismFactor = this.pacifist ? MathUtils.eval(KingdomsConfig.TAX_KINGDOMS_PACIFISM_FACTOR.getString(), this, new Object[0]) : 0.0;
        return MathUtils.eval(taxEquation, this, "pacifism_factor", pacifismFactor, "pacifism_factor", pacifismFactor);
    }

    public double getTax(@NonNull OfflinePlayer player) {
        if (!ServiceHandler.bankServiceAvailable()) {
            return 0.0;
        }
        double money = ServiceVault.getMoney(player);
        try {
            return MathUtils.eval(this.getTaxOrDefault(), player, "money", money, "money", money);
        }
        catch (Exception ex) {
            this.tax = KingdomsConfig.TAX_KINGDOMS_MEMBERS_DEFAULT_EQUATION.getString();
            try {
                return MathUtils.eval(this.tax, player, "money", money, "money", money);
            }
            catch (Exception exFatal) {
                MessageHandler.sendConsolePluginMessage("&cCould not use the default tax equation to get tax for &e" + player.getName() + " (" + player.getUniqueId() + ") " + ' ' + "&cin kingdom &e" + this.name + " (" + this.id + "):");
                ex.printStackTrace();
                exFatal.printStackTrace();
                return 0.0;
            }
        }
    }

    public @NonNull Pair<Boolean, Double> payTaxes(@NonNull OfflinePlayer player) {
        double amount = this.getTax(player);
        if (amount == 0.0) {
            return Pair.of(true, 0.0);
        }
        double money = ServiceVault.getMoney(player);
        if (money - amount < 0.0) {
            this.bank += money;
            ServiceVault.withdraw(player, money);
            return Pair.of(false, money);
        }
        double limit = KingdomsConfig.ECONOMY_BANK_LIMIT_KINGDOMS.getDouble();
        if (this.bank + amount > limit) {
            amount = limit - this.bank;
        }
        this.bank += amount;
        ServiceVault.withdraw(player, amount);
        return Pair.of(true, amount);
    }

    public boolean isInSameNationAs(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom kingdom) {
        return this.nation != null && kingdom != null && kingdom.nation != null && FastUUID.equals(this.nation, kingdom.nation);
    }

    public NationJoinEvent joinNation(@NonNull Nation nation, KingdomPlayer player) {
        NationJoinEvent event = new NationJoinEvent(nation, this, player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        if (this.hasNation()) {
            Nation oldNation = this.getNation();
            oldNation.getMembers().remove(this.id);
        }
        this.nation = nation.getId();
        nation.getMembers().add(this.id);
        return event;
    }

    public @NonNull Map<UUID, KingdomInvite> getNationInvites() {
        return this.nationInvites;
    }

    public void setNationInvites(@NonNull Map<UUID, KingdomInvite> nationInvites) {
        this.nationInvites = nationInvites;
    }

    public int getMaxLandsModifier() {
        return this.maxLandsModifier;
    }

    public void setMaxLandsModifier(int maxLandsModifier) {
        this.maxLandsModifier = maxLandsModifier;
    }

    public @NonNull String getChampionType() {
        return this.championType;
    }

    public void setChampionType(@NonNull String championType2) {
        this.championType = Objects.requireNonNull(championType2, "Champion type cannot be null");
    }

    public double getPower() {
        double power = 0.0;
        for (UUID id : this.members) {
            power += KingdomPlayer.getKingdomPlayer(id).getPower();
        }
        return power;
    }

    public boolean canBeOverclaimed() {
        return this.getPower() < (double)this.getMaxClaims();
    }

    public Map<UUID, Long> getChallenges() {
        if (this.challenges.isEmpty()) {
            return this.challenges;
        }
        long duration = KingdomsConfig.Invasions.CHALLENGES_DURATION.getManager().getTimeMillis();
        Iterator<Long> iter = this.challenges.values().iterator();
        while (iter.hasNext()) {
            long passed;
            long starts = iter.next();
            long now = System.currentTimeMillis();
            if (now < starts || (passed = now - starts) <= duration) continue;
            iter.remove();
        }
        return this.challenges;
    }

    public void setChallenges(Map<UUID, Long> challenges) {
        this.challenges = challenges;
    }

    @Override
    public @NonNull Kingdom getKingdom() {
        return this;
    }

    @Override
    @Nullable
    public Group getGroup() {
        return this;
    }
}

