/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.provider.MessageBuilder;

public class LogKingdomJoin
extends LogPlayerOperator {
    private UUID invitedBy;
    private static final Namespace NS = Namespace.kingdoms("KINGDOM_JOIN");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogKingdomJoin();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogKingdomJoin() {
    }

    public LogKingdomJoin(UUID player, UUID invitedBy) {
        super(player);
        this.invitedBy = invitedBy;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.invitedBy = json.get("invitedBy").asUUID();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("invitedBy", this.invitedBy);
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        OfflinePlayer inviter = this.getInviter();
        builder.parse("inviter", inviter == null ? "&cNot invited" : inviter.getName());
    }

    public OfflinePlayer getInviter() {
        return this.invitedBy == null ? null : Bukkit.getOfflinePlayer((UUID)this.invitedBy);
    }
}

