/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.string.StringUtils;

public class LogKingdomKingChange
extends AuditLog {
    private UUID oldKing;
    private UUID newKing;
    private KingdomKingChangeEvent.Reason reason;
    private static final Namespace NS = Namespace.kingdoms("KINGDOM_KING_CHANGE");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogKingdomKingChange();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogKingdomKingChange() {
    }

    public LogKingdomKingChange(UUID oldKing, UUID newKing, KingdomKingChangeEvent.Reason reason) {
        this.oldKing = oldKing;
        this.newKing = newKing;
        this.reason = reason;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.oldKing = json.get("oldKing").asUUID();
        this.newKing = json.get("newKing").asUUID();
        this.reason = KingdomKingChangeEvent.Reason.valueOf(json.getString("reason"));
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("oldKing", this.oldKing);
        json.setUUID("newKing", this.newKing);
        json.setString("reason", this.reason.name());
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.raw("old-king", Bukkit.getOfflinePlayer((UUID)this.oldKing).getName());
        builder.raw("new-king", Bukkit.getOfflinePlayer((UUID)this.newKing).getName());
        builder.raw("reason", StringUtils.capitalize(this.reason.name()));
    }
}

