/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.provider.MessageBuilder;

public abstract class LogPlayerOperator
extends AuditLog
implements PlayerOperator {
    private UUID player;

    protected LogPlayerOperator() {
    }

    public LogPlayerOperator(UUID player) {
        this.player = player;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.player = json.get("player").asUUID();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("player", this.player);
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.withContext(Bukkit.getOfflinePlayer((UUID)this.player));
    }

    @Override
    public @NonNull KingdomPlayer getPlayer() {
        return KingdomPlayer.getKingdomPlayer(this.player);
    }

    public @NonNull UUID getPlayerId() {
        return this.player;
    }
}

