/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.ranks;

import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.handlers.DataHandlerRank;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.managers.structures.RankEditor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/constants/group/model/logs/misc/ranks/LogRankExistence;", "Lorg/kingdoms/constants/group/model/logs/misc/LogPlayerOperator;", "()V", "player", "Lorg/kingdoms/constants/player/KingdomPlayer;", "rank", "Lorg/kingdoms/constants/player/Rank;", "(Lorg/kingdoms/constants/player/KingdomPlayer;Lorg/kingdoms/constants/player/Rank;)V", "addEdits", "", "builder", "Lorg/kingdoms/locale/provider/MessageBuilder;", "deserialize", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
public abstract class LogRankExistence
extends LogPlayerOperator {
    @Nullable
    private Rank rank;

    protected LogRankExistence() {
    }

    public LogRankExistence(@NotNull KingdomPlayer player, @NotNull Rank rank) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)rank, (String)"rank");
        super(player.getId());
        this.rank = rank;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.deserialize(context);
        SectionableDataGetter provider = context.getDataProvider();
        SectionableDataGetter rankSection = provider.get("rank").asSection();
        String node = rankSection.get("node").asString();
        this.rank = DataHandlerRank.deserializeRank(node, rankSection);
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        SectionableDataSetter section = context.getDataProvider().createSection("rank");
        DataHandlerRank.serializeRank(this.rank, section);
        Rank rank = this.rank;
        Intrinsics.checkNotNull((Object)rank);
        section.setString("node", rank.getNode());
    }

    @Override
    public void addEdits(@NotNull MessageBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.addEdits(builder);
        builder.inheritPlaceholders(RankEditor.getRankEdits(this.rank));
    }
}

