/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.purchases;

import java.util.UUID;
import org.kingdoms.constants.group.model.logs.purchases.LogResourcePoints;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.provider.MessageBuilder;

public abstract class LogKingdomUpgrade
extends LogResourcePoints {
    private int oldLevel;
    private int newLevel;

    public LogKingdomUpgrade() {
    }

    public int getOldLevel() {
        return this.oldLevel;
    }

    public int getNewLevel() {
        return this.newLevel;
    }

    public LogKingdomUpgrade(long resourcePoints, UUID player, int oldLevel, int newLevel) {
        super(resourcePoints, player);
        this.oldLevel = oldLevel;
        this.newLevel = newLevel;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.oldLevel = json.get("oldLevel").asInt();
        this.newLevel = json.get("newLevel").asInt();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setInt("oldLevel", this.oldLevel);
        json.setInt("newLevel", this.newLevel);
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.raw("old_level", this.oldLevel);
        builder.raw("new_level", this.newLevel);
    }
}

